/*
 * Decompiled with CFR 0.152.
 */
package com.arashpayan.filetree;

import com.arashpayan.filetree.Constants;
import java.io.File;

public class FileTreeNode {
    public File file;
    public static final String WINDOWS_MYCOMPUTER = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}";
    public static final String WINDOWS_MYNETWORKPLACES = "::{208D2C60-3AEA-1069-A2D7-08002B30309D}";
    public static final String WINDOWSVISTA_NETWORK = "::{F02C1A0D-BE21-4350-88B0-7367FC96EF3C}";

    public FileTreeNode(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file not allowed");
        }
        this.file = file;
    }

    public String toString() {
        String name = this.file.getName();
        if (!Constants.isWindows) {
            return name;
        }
        if (name.length() == 0) {
            return this.file.getPath();
        }
        if (Constants.isVista) {
            if (name.equals(WINDOWS_MYCOMPUTER)) {
                return "Computer";
            }
            if (name.equals(WINDOWSVISTA_NETWORK)) {
                return "Network";
            }
            return name;
        }
        if (name.equals(WINDOWS_MYCOMPUTER)) {
            return "My Computer";
        }
        if (name.equals(WINDOWS_MYNETWORKPLACES)) {
            return "My Network Places";
        }
        return name;
    }
}

