/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.swing.SearchList;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.DefaultSearchListener;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;

public class SwingSearchWindow
extends JFrame
implements GUISearchWindow {
    public static int SEARCH_EXTERNAL_WINDOW = 0;
    public static int SEARCH_TABBED_PANE = 1;
    public static int SEARCH_MENU_BAR = 2;
    int style = 0;
    private boolean isSetup = false;
    String defaultMessage = "Search PDF Here";
    JTextField searchText = null;
    JCheckBox searchAll;
    JTextField searchCount;
    DefaultListModel listModel;
    SearchList results;
    JLabel label = null;
    private JPanel advancedPanel;
    private JComboBox searchType;
    private JCheckBox wholeWordsOnlyBox;
    private JCheckBox caseSensitiveBox;
    MouseListener ML;
    ActionListener AL = null;
    WindowListener WL;
    KeyListener KL;
    SwingWorker searcher = null;
    public boolean isSearch = false;
    JButton searchButton = null;
    private int itemFoundCount = 0;
    Map textPages = new HashMap();
    Map textRectangles = new HashMap();
    final JPanel nav = new JPanel();
    Values commonValues;
    SwingGUI currentGUI;
    PdfDecoder decode_pdf;
    private boolean deleteOnClick;

    public SwingSearchWindow(SwingGUI swingGUI) {
        this.currentGUI = swingGUI;
        this.setName("searchFrame");
    }

    public Component getContentPanel() {
        return this.getContentPane();
    }

    public void find(PdfDecoder pdfDecoder, Values values) {
        this.decode_pdf = pdfDecoder;
        this.commonValues = values;
        if (this.isSetup) {
            this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.searchText.selectAll();
            this.searchText.grabFocus();
        } else {
            this.isSetup = true;
            this.defaultMessage = Messages.getMessage("PdfViewerSearchGUI.DefaultMessage");
            this.searchText = new JTextField(this.defaultMessage);
            this.searchText.setName("searchText");
            this.searchButton = new JButton(Messages.getMessage("PdfViewerSearch.Button"));
            this.advancedPanel = new JPanel(new GridBagLayout());
            this.searchType = new JComboBox<String>(new String[]{"Match Exact word or phrase", "Match Any of the words"});
            this.wholeWordsOnlyBox = new JCheckBox("Whole words only");
            this.wholeWordsOnlyBox.setName("wholeWords");
            this.caseSensitiveBox = new JCheckBox("Case-Sensitive");
            this.caseSensitiveBox.setName("caseSensitive");
            this.searchType.setName("combo");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.advancedPanel.setPreferredSize(new Dimension(this.advancedPanel.getPreferredSize().width, 150));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 19;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            this.advancedPanel.add((Component)new JLabel("Return results containing:"), gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridy = 1;
            this.advancedPanel.add((Component)this.searchType, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.advancedPanel.add((Component)new JLabel("Use these additional criteria:"), gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridy = 3;
            this.advancedPanel.add((Component)this.wholeWordsOnlyBox, gridBagConstraints);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 4;
            this.advancedPanel.add((Component)this.caseSensitiveBox, gridBagConstraints);
            this.advancedPanel.setVisible(false);
            this.nav.setLayout(new BorderLayout());
            this.WL = new WindowListener(){

                public void windowOpened(WindowEvent windowEvent) {
                }

                public void windowClosing(WindowEvent windowEvent) {
                    SwingSearchWindow.this.removeSearchWindow(true);
                }

                public void windowClosed(WindowEvent windowEvent) {
                }

                public void windowIconified(WindowEvent windowEvent) {
                }

                public void windowDeiconified(WindowEvent windowEvent) {
                }

                public void windowActivated(WindowEvent windowEvent) {
                }

                public void windowDeactivated(WindowEvent windowEvent) {
                }
            };
            this.addWindowListener(this.WL);
            this.nav.add((Component)this.searchButton, "East");
            this.nav.add((Component)this.searchText, "Center");
            this.searchAll = new JCheckBox();
            this.searchAll.setSelected(true);
            this.searchAll.setText(Messages.getMessage("PdfViewerSearch.CheckBox"));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.searchAll, "North");
            this.label = new JLabel("<html><center> Show Advanced");
            this.label.setForeground(Color.blue);
            this.label.setName("advSearch");
            this.label.addMouseListener(new MouseListener(){
                boolean isVisible = false;
                String text = "Show Advanced";

                public void mouseEntered(MouseEvent mouseEvent) {
                    SwingSearchWindow.this.nav.setCursor(new Cursor(12));
                    SwingSearchWindow.this.label.setText("<html><center><a href=" + this.text + ">" + this.text + "</a></center>");
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    SwingSearchWindow.this.nav.setCursor(new Cursor(0));
                    SwingSearchWindow.this.label.setText("<html><center>" + this.text);
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (this.isVisible) {
                        this.text = "Show Advanced";
                        SwingSearchWindow.this.label.setText("<html><center><a href=" + this.text + ">" + this.text + "</a></center>");
                        SwingSearchWindow.this.advancedPanel.setVisible(false);
                    } else {
                        this.text = "Hide Advanced";
                        SwingSearchWindow.this.label.setText("<html><center><a href=" + this.text + ">" + this.text + "</a></center>");
                        SwingSearchWindow.this.advancedPanel.setVisible(true);
                    }
                    this.isVisible = !this.isVisible;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }
            });
            this.label.setBorder(BorderFactory.createEmptyBorder(3, 4, 4, 4));
            jPanel.add((Component)this.label, "South");
            this.nav.add((Component)jPanel, "North");
            this.itemFoundCount = 0;
            this.textPages.clear();
            this.textRectangles.clear();
            this.listModel = null;
            this.searchCount = new JTextField(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.searchCount.setEditable(false);
            this.nav.add((Component)this.searchCount, "South");
            this.listModel = new DefaultListModel();
            this.results = new SearchList(this.listModel, this.textPages);
            this.results.setSelectionMode(1);
            this.results.setName("results");
            this.ML = new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (!SwingSearchWindow.this.commonValues.isProcessing()) {
                        Integer n;
                        Object v;
                        float f = SwingSearchWindow.this.currentGUI.getScaling();
                        int n2 = SwingSearchWindow.this.currentGUI.getPDFDisplayInset();
                        int n3 = SwingSearchWindow.this.results.getSelectedIndex();
                        SwingSearchWindow.this.decode_pdf.setFoundTextAreas(null);
                        if (n3 != -1 && (v = SwingSearchWindow.this.textPages.get(n = new Integer(n3))) != null) {
                            int n4 = (Integer)v;
                            Rectangle rectangle = (Rectangle)SwingSearchWindow.this.textRectangles.get(n);
                            if (SwingSearchWindow.this.commonValues.getCurrentPage() != n4) {
                                SwingSearchWindow.this.commonValues.setCurrentPage(n4);
                                SwingSearchWindow.this.currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + SwingSearchWindow.this.commonValues.getCurrentPage());
                                SwingSearchWindow.this.decode_pdf.setPageParameters(f, SwingSearchWindow.this.commonValues.getCurrentPage());
                                SwingSearchWindow.this.currentGUI.decodePage(false);
                                SwingSearchWindow.this.decode_pdf.invalidate();
                            }
                            SwingSearchWindow.this.decode_pdf.scrollRectToHighlight(rectangle);
                            SwingSearchWindow.this.decode_pdf.setFoundTextArea(rectangle);
                            SwingSearchWindow.this.decode_pdf.invalidate();
                            SwingSearchWindow.this.decode_pdf.repaint();
                        }
                    }
                    if (SwingSearchWindow.this.commonValues.getCurrentPage() == 1) {
                        SwingSearchWindow.this.currentGUI.setBackNavigationButtonsEnabled(false);
                    } else {
                        SwingSearchWindow.this.currentGUI.setBackNavigationButtonsEnabled(true);
                    }
                    if (SwingSearchWindow.this.commonValues.getCurrentPage() == SwingSearchWindow.this.decode_pdf.getPageCount()) {
                        SwingSearchWindow.this.currentGUI.setForwardNavigationButtonsEnabled(false);
                    } else {
                        SwingSearchWindow.this.currentGUI.setForwardNavigationButtonsEnabled(true);
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            };
            this.results.addMouseListener(this.ML);
            this.AL = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!SwingSearchWindow.this.isSearch) {
                        try {
                            SwingSearchWindow.this.searchText();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        SwingSearchWindow.this.searcher.interrupt();
                        SwingSearchWindow.this.isSearch = false;
                        SwingSearchWindow.this.searchButton.setText(Messages.getMessage("PdfViewerSearch.Button"));
                    }
                }
            };
            this.searchButton.addActionListener(this.AL);
            this.searchText.selectAll();
            this.deleteOnClick = true;
            this.KL = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    char c;
                    int n;
                    if (SwingSearchWindow.this.searchText.getText().length() == 0) {
                        SwingSearchWindow.this.currentGUI.nextSearch.setVisible(false);
                        SwingSearchWindow.this.currentGUI.previousSearch.setVisible(false);
                    }
                    if (SwingSearchWindow.this.deleteOnClick) {
                        SwingSearchWindow.this.deleteOnClick = false;
                        SwingSearchWindow.this.searchText.setText("");
                    }
                    if ((n = keyEvent.getID()) == 400 && (c = keyEvent.getKeyChar()) == '\n') {
                        if (SwingSearchWindow.this.decode_pdf.isDecoding()) {
                            JOptionPane.showMessageDialog(null, "File must be open before you can search.");
                        } else {
                            try {
                                SwingSearchWindow.this.currentGUI.nextSearch.setVisible(true);
                                SwingSearchWindow.this.currentGUI.previousSearch.setVisible(true);
                                SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(false);
                                SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(false);
                                SwingSearchWindow.this.isSearch = false;
                                SwingSearchWindow.this.searchText();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyReleased(KeyEvent keyEvent) {
                }
            };
            this.searchText.addKeyListener(this.KL);
            if (this.style == SEARCH_EXTERNAL_WINDOW || this.style == SEARCH_TABBED_PANE) {
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.getViewport().add(this.results);
                jScrollPane.setVerticalScrollBarPolicy(20);
                jScrollPane.setHorizontalScrollBarPolicy(30);
                jScrollPane.getVerticalScrollBar().setUnitIncrement(80);
                jScrollPane.getHorizontalScrollBar().setUnitIncrement(80);
                this.getContentPane().setLayout(new BorderLayout());
                this.getContentPane().add((Component)jScrollPane, "Center");
                this.getContentPane().add((Component)this.nav, "North");
                this.getContentPane().add((Component)this.advancedPanel, "South");
                Container container = this.commonValues.getModeOfOperation() == 1 ? this.currentGUI.getFrame().getContentPane() : this.currentGUI.getFrame();
                int n = 230;
                int n2 = container.getHeight();
                int n3 = container.getLocationOnScreen().x;
                int n4 = container.getWidth() + n3;
                int n5 = container.getLocationOnScreen().y;
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                int n6 = dimension.width;
                if (n4 + n > n6 && this.style == SEARCH_EXTERNAL_WINDOW) {
                    n4 = n6 - n;
                    container.setSize(n4 - n3, container.getHeight());
                }
                this.setSize(n, n2);
                this.setLocation(n4, n5);
                this.searchAll.setFocusable(false);
                this.searchText.grabFocus();
            } else {
                this.currentGUI.setSearchText(this.searchText);
            }
        }
        if (this.style == SEARCH_EXTERNAL_WINDOW) {
            this.setVisible(true);
        }
    }

    public void removeSearchWindow(boolean bl) {
        this.setVisible(false);
        this.setVisible(false);
        if (this.searcher != null) {
            this.searcher.interrupt();
        }
        if (this.isSetup && !bl) {
            if (this.listModel != null) {
                this.listModel.clear();
            }
            this.itemFoundCount = 0;
            this.isSearch = false;
        }
        if (this.decode_pdf != null) {
            this.decode_pdf.setFoundTextArea(null);
            this.decode_pdf.repaint();
        }
    }

    private void searchText() throws Exception {
        if (this.searcher != null) {
            this.searcher.interrupt();
        }
        this.searchButton.setText(Messages.getMessage("PdfViewerSearchButton.Stop"));
        this.searchButton.invalidate();
        this.searchButton.repaint();
        this.isSearch = true;
        this.searchCount.setText(Messages.getMessage("PdfViewerSearch.Scanning1"));
        this.searchCount.repaint();
        this.searcher = new SwingWorker(){

            public Object construct() {
                try {
                    String[] stringArray;
                    SwingSearchWindow.this.listModel.removeAllElements();
                    SwingSearchWindow.this.results.repaint();
                    int n = 0;
                    SwingSearchWindow.this.textPages.clear();
                    SwingSearchWindow.this.textRectangles.clear();
                    SwingSearchWindow.this.itemFoundCount = 0;
                    SwingSearchWindow.this.decode_pdf.setFoundTextAreas(null);
                    String string = SwingSearchWindow.this.searchText.getText().trim();
                    if (SwingSearchWindow.this.searchType.getSelectedIndex() == 0) {
                        stringArray = new String[]{string};
                    } else {
                        stringArray = string.split(" ");
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = stringArray[i].trim();
                        }
                    }
                    PdfPageData pdfPageData = SwingSearchWindow.this.decode_pdf.getPdfPageData();
                    int n2 = 1;
                    int n3 = SwingSearchWindow.this.commonValues.getPageCount() + 1;
                    if (!SwingSearchWindow.this.searchAll.isSelected()) {
                        n2 = SwingSearchWindow.this.commonValues.getCurrentPage();
                        n3 = n2 + 1;
                    }
                    for (int i = n2; i < n3; ++i) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        try {
                            PdfGroupingAlgorithms pdfGroupingAlgorithms;
                            if (i == SwingSearchWindow.this.commonValues.getCurrentPage()) {
                                pdfGroupingAlgorithms = SwingSearchWindow.this.decode_pdf.getGroupingObject();
                            } else {
                                SwingSearchWindow.this.decode_pdf.decodePageInBackground(i);
                                pdfGroupingAlgorithms = SwingSearchWindow.this.decode_pdf.getBackgroundGroupingObject();
                            }
                            pdfGroupingAlgorithms.generateTeasers();
                            int n4 = pdfPageData.getMediaBoxX(i);
                            int n5 = pdfPageData.getMediaBoxWidth(i);
                            int n6 = pdfPageData.getMediaBoxY(i);
                            int n7 = pdfPageData.getMediaBoxHeight(i);
                            DefaultSearchListener defaultSearchListener = new DefaultSearchListener();
                            int n8 = 0;
                            if (SwingSearchWindow.this.wholeWordsOnlyBox.isSelected()) {
                                n8 |= 1;
                            }
                            if (SwingSearchWindow.this.caseSensitiveBox.isSelected()) {
                                n8 |= 2;
                            }
                            SortedMap sortedMap = pdfGroupingAlgorithms.findMultipleTermsInRectangleWithMatchingTeasers(n4, n6, n5, n7, pdfPageData.getRotation(i), i, stringArray, n8, defaultSearchListener);
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            if (!sortedMap.isEmpty()) {
                                SwingSearchWindow.this.itemFoundCount = SwingSearchWindow.this.itemFoundCount + sortedMap.size();
                                Iterator iterator = sortedMap.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    Map.Entry entry = iterator.next();
                                    Rectangle rectangle = (Rectangle)entry.getKey();
                                    final String string2 = (String)entry.getValue();
                                    Runnable runnable = new Runnable(){

                                        public void run() {
                                            (this).SwingSearchWindow.this.listModel.addElement(string2);
                                        }
                                    };
                                    SwingUtilities.invokeAndWait(runnable);
                                    Integer n9 = new Integer(n);
                                    ++n;
                                    SwingSearchWindow.this.textRectangles.put(n9, rectangle);
                                    SwingSearchWindow.this.textPages.put(n9, new Integer(i));
                                }
                            }
                            if (!(!sortedMap.isEmpty() | i % 16 == 0)) continue;
                            SwingSearchWindow.this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + SwingSearchWindow.this.itemFoundCount + ' ' + Messages.getMessage("PdfViewerSearch.Scanning") + i);
                            SwingSearchWindow.this.searchCount.invalidate();
                            SwingSearchWindow.this.searchCount.repaint();
                            continue;
                        }
                        catch (PdfException pdfException) {
                            // empty catch block
                        }
                    }
                    SwingSearchWindow.this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + SwingSearchWindow.this.itemFoundCount + "  " + Messages.getMessage("PdfViewerSearch.Done"));
                    SwingSearchWindow.this.results.invalidate();
                    SwingSearchWindow.this.results.repaint();
                    SwingSearchWindow.this.results.setSelectedIndex(0);
                    SwingSearchWindow.this.results.setLength(SwingSearchWindow.this.listModel.capacity());
                    SwingSearchWindow.this.currentGUI.setResults(SwingSearchWindow.this.results);
                    SwingSearchWindow.this.isSearch = false;
                    SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(true);
                    SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(true);
                    SwingSearchWindow.this.searchButton.setText(Messages.getMessage("PdfViewerSearch.Button"));
                }
                catch (InterruptedException interruptedException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(null, "Search stopped by user.");
                            (this).SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(true);
                            (this).SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(true);
                        }
                    });
                }
                catch (Exception exception) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(null, "An error occured during search. Some results may be missing.\n\nPlease send the file to IDRSolutions for investigation.");
                            (this).SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(true);
                            (this).SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(true);
                        }
                    });
                }
                return null;
            }
        };
        this.searcher.start();
    }

    public int getListLength() {
        return this.listModel.capacity();
    }

    public void grabFocusInInput() {
        this.searchText.grabFocus();
    }

    public boolean isSearchVisible() {
        return this.isVisible();
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public int getStyle() {
        return this.style;
    }

    public JTextField getSearchText() {
        return this.searchText;
    }

    public Map getTextRectangles() {
        return this.textRectangles;
    }

    public SearchList getResults() {
        return this.results;
    }
}

