/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.FileList;
import com.pt.io.InputUni;
import com.pt.io.InputUniByteArray;
import com.pt.io.InputUniFile;
import com.pt.io.OutputUni;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import multivalent.std.adaptor.pdf.SecurityHandler;
import multivalent.std.adaptor.pdf.SecurityHandlerStandard;
import phelps.io.InputStreams;
import phelps.io.PrintStreams;
import phelps.lang.Integers;
import phelps.lang.StringBuffers;
import phelps.lang.Strings;
import phelps.util.Units;

public class Impose {
    static final boolean DEBUG = false;
    public static final String VERSION = "1.2 of $Date: 2005/07/26 21:17:51 $";
    public static final String COPYRIGHT = "Copyright (c) 2002 - 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Impose [<options>] <PDF-file...>\n\t[-dimensions <columns>x<rows>] [-layout <layout>] [-nup 2|4|6|9|16]\n\t[-page <range>] [-cropbox]\n\t[-separator <width>] [-margin <length>] [-paper <size>]\n\t[-password <password>] [-verbose] [-quiet]";
    private int cols_ = 2;
    private int rows_ = 2;
    private String layout_ = "lt";
    private String range_ = null;
    private boolean fverbose_ = false;
    private boolean fquiet_ = false;
    private boolean fmonitor_ = false;
    private double paperwidth_ = -1.0;
    private double paperheight_ = -1.0;
    private boolean fcropbox_ = false;
    private int margin_ = 0;
    private double separator_ = 0.0;
    private PrintStream out_ = PrintStreams.DEVNULL;
    private String password_ = null;
    private PDFReader pdfr_;
    private int[][][] sequence_;
    private char[][][] orientation_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Impose(File file) throws IOException, ParseException {
        this(new InputUniFile(file));
    }

    public Impose(byte[] byArray) throws IOException, ParseException {
        this(new InputUniByteArray(byArray));
    }

    public Impose(InputUni inputUni) throws IOException, ParseException {
        this(new PDFReader(inputUni));
    }

    public Impose(PDFReader pDFReader) {
    }

    public void setDimensions(int n, int n2) {
        if (!($assertionsDisabled || n >= 1 && n2 >= 1)) {
            throw new AssertionError();
        }
        this.cols_ = n;
        this.rows_ = n2;
        this.sequence_ = null;
    }

    public void setLayout(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.layout_ = Strings.removeWhitespace(string);
        this.sequence_ = null;
    }

    public void setRange(String string) {
        this.range_ = string;
    }

    public void setCropbox(boolean bl) {
        this.fcropbox_ = bl;
    }

    public void setNup(int n) throws UnsupportedOperationException {
        if (n == 2) {
            this.setDimensions(1, 2);
            this.setLayout("1r,2r");
        } else if (n == 4) {
            this.setDimensions(2, 2);
        } else if (n == 6) {
            this.setDimensions(2, 3);
        } else if (n == 9) {
            this.setDimensions(3, 3);
        } else if (n == 16) {
            this.setDimensions(4, 4);
        } else {
            throw new UnsupportedOperationException("built-in: 2|4|6|9|16, not " + n);
        }
    }

    public void setPaperSize(int n, int n2) {
        this.paperwidth_ = n;
        this.paperheight_ = n2;
    }

    public void setMargin(int n) {
        this.margin_ = Math.max(0, n);
    }

    public void setSeparator(double d) {
        this.separator_ = Math.max(0.0, d);
    }

    public boolean setPassword(String string) throws IOException {
        boolean bl = this.pdfr_.setPassword(string);
        return bl && this.allow();
    }

    private boolean allow() {
        boolean bl = false;
        SecurityHandler securityHandler = this.pdfr_.getEncrypt().getSecurityHandler();
        if (securityHandler.isAuthorized()) {
            if (securityHandler instanceof SecurityHandlerStandard) {
                SecurityHandlerStandard securityHandlerStandard = (SecurityHandlerStandard)securityHandler;
                int n = securityHandlerStandard.getR();
                int n2 = securityHandlerStandard.getPerm();
                if (n == 2 && (n2 & 8) == 0 || n >= 3 && (n2 & 0x400) == 0) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return true;
    }

    public void writeFile(File file) throws IOException, ParseException {
        this.writeUni(OutputUni.getInstance(file, null));
    }

    public byte[] writeBytes() throws IOException, ParseException {
        OutputUni outputUni = OutputUni.getInstance(new byte[this.pdfr_.getObjCnt() * 100], null);
        this.writeUni(outputUni);
        return outputUni.toByteArray();
    }

    public void writeUni(OutputUni outputUni) throws IOException, ParseException {
        this.impose(new PDFWriter(outputUni, this.pdfr_));
    }

    public PDFReader writePipe() throws IOException, ParseException {
        return null;
    }

    private Object impose(PDFWriter pDFWriter) throws IOException, ParseException {
        this.computeLayout();
        if (!this.allow()) {
            throw new ParseException("Don't have permission to 'assemble' -- try OWNER password");
        }
        pDFWriter.setPassword(this.password_);
        this.impose2(pDFWriter);
        Object object = pDFWriter.writePDF();
        this.pdfr_.close();
        this.pdfr_ = null;
        pDFWriter.close();
        return object;
    }

    private void impose2(PDFWriter pDFWriter) throws IOException, ParseException {
        PDFReader pDFReader = this.pdfr_;
        int n = pDFReader.getPageCnt();
        ArrayList<IRef> arrayList = new ArrayList<IRef>(10);
        int n2 = this.cols_;
        int n3 = this.rows_;
        double d = this.paperwidth_;
        double d2 = this.paperheight_;
        if (d < 0.0) {
            Dict dict = pDFReader.getPage(1);
            Object object = dict.get("CropBox");
            if (object == null || !this.fcropbox_) {
                object = dict.get("MediaBox");
            }
            Object[] objectArray = (Object[])pDFReader.getObject(object);
            d = ((Number)objectArray[2]).doubleValue();
            d2 = ((Number)objectArray[3]).doubleValue();
        }
        double d3 = d / (double)n2;
        double d4 = d2 / (double)n3;
        double d5 = d3 - (double)(2 * this.margin_);
        double d6 = d4 - (double)(2 * this.margin_);
        Object[] objectArray = new Object[]{Integers.ZERO, Integers.ZERO, Integers.getInteger((int)d), Integers.getInteger((int)d2)};
        NumberFormat numberFormat = PDFWriter.NF;
        String string = this.range_ != null ? this.range_ : "1-" + n;
        int[] nArray = Units.parseRange(string, 1, n);
        int n4 = 0;
        int n5 = nArray.length;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.sequence_.length;
        while (n4 < n5) {
            int n9;
            Dict dict = new Dict();
            dict.put("Type", "Page");
            dict.put("MediaBox", objectArray);
            Dict dict2 = new Dict();
            dict.put("Resources", dict2);
            Dict dict3 = new Dict();
            dict2.put("XObject", dict3);
            StringBuffer stringBuffer = new StringBuffer(2048);
            arrayList.add(pDFWriter.addObject(dict));
            for (n9 = 0; n9 < n3; ++n9) {
                for (int i = 0; i < n2; ++i) {
                    double d7;
                    int n10;
                    int n11 = this.sequence_[n7][n9][i];
                    if (n11 <= 0) continue;
                    ++n6;
                    int n12 = n4 + n11 - 1;
                    if (n12 < 0 || n12 >= nArray.length || (n10 = nArray[n12]) <= 0 || n10 > n) continue;
                    String string2 = "p" + n11;
                    Dict dict4 = pDFReader.getPage(n10);
                    Rectangle rectangle = COS.array2Rectangle((Object[])pDFReader.getObject(dict4.get("MediaBox")), null);
                    double d8 = rectangle.width;
                    double d9 = rectangle.height;
                    double d10 = (double)i * d3 + (double)this.margin_;
                    double d11 = (double)(n3 - n9 - 1) * d4 + (double)this.margin_;
                    char c = this.orientation_[n7][n9][i];
                    int n13 = c == 'l' ? -90 : (c == 'r' ? 90 : (c == 'u' ? 180 : 0));
                    Object object = dict4.get("Rotate");
                    if (object != null) {
                        n13 += pDFReader.getObjInt(object);
                    }
                    if ((n13 %= 360) < 0) {
                        n13 += 360;
                    }
                    if (n13 == 90) {
                        d11 += d6;
                        d7 = d8;
                        d8 = d9;
                        d9 = d7;
                    } else if (n13 == 180) {
                        d10 += d5;
                        d11 += d6;
                    } else if (n13 == 270) {
                        d10 += d5;
                        d7 = d8;
                        d8 = d9;
                        d9 = d7;
                    } else if (!$assertionsDisabled && n13 != 0) {
                        throw new AssertionError();
                    }
                    d7 = Math.min(d5 / d8, d6 / d9);
                    AffineTransform affineTransform = new AffineTransform(d7, 0.0, 0.0, d7, d10, d11);
                    affineTransform.rotate(Math.toRadians(-n13));
                    stringBuffer.append("q");
                    stringBuffer.append(" " + numberFormat.format(affineTransform.getScaleX()) + " " + numberFormat.format(affineTransform.getShearY()));
                    stringBuffer.append(" " + numberFormat.format(affineTransform.getShearX()) + " " + numberFormat.format(affineTransform.getScaleY()));
                    stringBuffer.append(" " + numberFormat.format(affineTransform.getTranslateX()) + " " + numberFormat.format(affineTransform.getTranslateY()) + " cm");
                    stringBuffer.append(" /" + string2 + " Do");
                    dict3.put(string2, pDFReader.getPageRef(n10));
                    stringBuffer.append(" Q\n");
                }
            }
            if (this.separator_ > 0.0) {
                stringBuffer.append("\n" + this.separator_ + " w  0 0 0 RG \n");
                for (n9 = 1; n9 < n3; ++n9) {
                    double d12 = (double)(n3 - n9) * d4;
                    stringBuffer.append("0 " + numberFormat.format(d12) + " m " + d + " " + numberFormat.format(d12) + " l s\n");
                }
                for (n9 = 1; n9 < n2; ++n9) {
                    double d13 = (double)n9 * d3;
                    stringBuffer.append(numberFormat.format(d13) + " 0 m " + numberFormat.format(d13) + " " + d2 + " l s\n");
                }
            }
            Dict dict5 = new Dict();
            dict5.put("DATA", StringBuffers.getBytes8(stringBuffer));
            dict.put("Contents", pDFWriter.addObject(dict5));
            if (++n7 != n8) continue;
            n7 = 0;
            n4 += n6;
            n6 = 0;
        }
        for (n4 = 1; n4 <= n; ++n4) {
            this.page2form(n4, pDFReader, pDFWriter);
        }
        pDFWriter.resetPageTree(arrayList);
        pDFWriter.liftPageTree();
        Dict dict = pDFReader.getCatalog();
        dict.remove("Outlines");
        dict.remove("PageMode");
        dict.remove("OpenAction");
        dict.remove("Names");
        dict.remove("PageLayout");
    }

    private void computeLayout() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object object;
        if (this.sequence_ != null) {
            return;
        }
        int n9 = this.cols_;
        int n10 = this.rows_;
        String string = this.layout_.trim();
        char c = string.charAt(0);
        if ('0' <= c && c <= '9' || c == 'x' || c == 'X') {
            object = string.trim().split(",");
            if (((String[])object).length != n10 * n9 && !this.fquiet_) {
                this.out_.print("WARNING: -layout sequence ");
                if (((String[])object).length < n10 * n9) {
                    this.out_.println("shorter than -dimension; leaving remaining cells empty.");
                } else {
                    this.out_.println("longer than -dimension; spilling over into multipage pattern.");
                }
                this.out_.println("Use -verbose to see layout matrix.");
            }
            n8 = (int)Math.ceil((float)((String[])object).length / (float)(n10 * n9));
            this.sequence_ = new int[n8][n10][n9];
            this.orientation_ = new char[n8][n10][n9];
            n7 = 0;
            for (n6 = 0; n6 < n8; ++n6) {
                for (n5 = 0; n5 < n10; ++n5) {
                    for (n4 = 0; n4 < n9 && n7 < ((String[])object).length; ++n4) {
                        String string2;
                        if ((n3 = (int)(string2 = object[n7++].trim()).charAt(string2.length() - 1)) == 114 || n3 == 108 || n3 == 117) {
                            this.orientation_[n6][n5][n4] = n3;
                            string2 = string2.substring(0, string2.length() - 1).trim();
                        }
                        int n11 = n2 = string2.startsWith("x") || string2.startsWith("X") || string2.equals("0") || string2.startsWith("b") ? 0 : Integer.parseInt(string2);
                        if (!($assertionsDisabled || n2 >= 0 && n2 <= ((String[])object).length)) {
                            throw new AssertionError();
                        }
                        this.sequence_[n6][n5][n4] = n2;
                    }
                }
            }
        } else {
            this.sequence_ = new int[1][n10][n9];
            this.orientation_ = new char[1][n10][n9];
            int n12 = 0;
            n8 = n9;
            n6 = 1;
            n7 = 0;
            n5 = n10;
            n4 = 1;
            boolean bl = true;
            n2 = string.length();
            for (n3 = 0; n3 < n2; ++n3) {
                c = string.charAt(n3);
                if (c == 'l') {
                    n12 = 0;
                    n6 = 1;
                    if (n3 != 0) continue;
                    bl = true;
                    continue;
                }
                if (c == 'r') {
                    n12 = n9 - 1;
                    n6 = -1;
                    if (n3 != 0) continue;
                    bl = true;
                    continue;
                }
                if (c == 't') {
                    n7 = 0;
                    n4 = 1;
                    if (n3 != 0) continue;
                    bl = false;
                    continue;
                }
                if (c != 'x' && c != '0' && c != 'b') continue;
                n7 = n10 - 1;
                n4 = -1;
                if (n3 != 0) continue;
                bl = false;
            }
            n3 = 1;
            if (bl) {
                for (n2 = n7; 0 <= n2 && n2 < n5; n2 += n4) {
                    for (n = n12; 0 <= n && n < n8; n += n6) {
                        this.sequence_[0][n2][n] = n3++;
                        this.orientation_[0][n2][n] = 32;
                    }
                }
            } else {
                for (n2 = n12; 0 <= n2 && n2 < n8; n2 += n6) {
                    for (n = n7; 0 <= n && n < n5; n += n4) {
                        this.sequence_[0][n][n2] = n3++;
                        this.orientation_[0][n][n2] = 32;
                    }
                }
            }
        }
        if (this.fverbose_) {
            object = this.sequence_;
            n8 = ((String[])object).length;
            for (n6 = 0; n6 < n8; ++n6) {
                String string3;
                String string4 = string3 = object[n6];
                n4 = ((String)string4).length;
                for (int i = 0; i < n4; ++i) {
                    String string5;
                    String string6 = string5 = string4[i];
                    n = ((String)string6).length;
                    for (int j = 0; j < n; ++j) {
                        String string7 = string6[j];
                        this.out_.print(" " + (int)string7);
                    }
                    this.out_.println();
                }
            }
        }
    }

    private void page2form(int n, PDFReader pDFReader, PDFWriter pDFWriter) throws IOException {
        Dict dict = pDFReader.getPage(n);
        Object object = dict.get("Contents");
        byte[] byArray = InputStreams.toByteArray(pDFReader.getInputStream(object, true), 10240L);
        Object object2 = pDFReader.getObject(object);
        if (COS.CLASS_DICTIONARY == object2.getClass()) {
            pDFWriter.setObject(((IRef)object).id, COS.OBJECT_NULL);
        } else {
            Object[] objectArray = (Object[])object2;
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                Object object3 = objectArray[i];
                pDFWriter.setObject(((IRef)object3).id, COS.OBJECT_NULL);
            }
        }
        dict.put("DATA", byArray);
        dict.remove("Parent");
        dict.remove("Contents");
        dict.remove("Rotate");
        object2 = dict.remove("CropBox");
        if (object2 == null) {
            object2 = dict.get("MediaBox");
        }
        dict.put("BBox", object2);
        dict.remove("MediaBox");
        dict.remove("Annot");
        dict.put("Type", "XObject");
        dict.put("Subtype", "Form");
        pDFWriter.setObject(pDFReader.getPageRef((int)n).id, dict);
    }

    private int commandLine(String[] stringArray) throws UnsupportedOperationException, NumberFormatException {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-dim")) {
                string = stringArray[++n];
                try {
                    int n3 = string.indexOf(120);
                    if (n3 == -1) {
                        throw new NumberFormatException();
                    }
                    int n4 = Integer.parseInt(string.substring(0, n3));
                    int n5 = Integer.parseInt(string.substring(n3 + 1));
                    this.setDimensions(n4, n5);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NumberFormatException("-dimensions can't parse " + string + " into <cols>x<rows>");
                }
            }
            if (string.startsWith("-lay")) {
                this.setLayout(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-page") || string.startsWith("-range")) {
                this.setRange(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-cropbox")) {
                this.setCropbox(true);
                continue;
            }
            if (string.startsWith("-nup")) {
                this.setNup(Integer.parseInt(stringArray[++n]));
                continue;
            }
            if (string.startsWith("-sep")) {
                this.setSeparator(Double.parseDouble(stringArray[++n]));
                continue;
            }
            if (string.startsWith("-mar")) {
                this.setMargin((int)Units.getLength(stringArray[++n], "bp"));
                continue;
            }
            if (string.startsWith("-paper")) {
                Dimension2D dimension2D = Units.getPaperSize(stringArray[++n], "bp");
                this.setPaperSize((int)dimension2D.getWidth(), (int)dimension2D.getHeight());
                continue;
            }
            if (string.startsWith("-pass")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                this.out_.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                this.out_.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Impose impose = new Impose((PDFReader)null);
        int n = 0;
        try {
            n = impose.commandLine(stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(1);
        }
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (System.getSecurityManager() != null) continue;
            try {
                impose.pdfr_ = new PDFReader(file);
                boolean bl = impose.setPassword(impose.password_);
                if (!bl) {
                    System.err.println(file + ": invalid password");
                    continue;
                }
                String string = file.getPath();
                if (file.getName().toLowerCase().endsWith(".pdf")) {
                    string = string.substring(0, string.length() - 4);
                }
                impose.writeFile(new File(string + "-up.pdf"));
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
            }
        }
        System.exit(0);
    }

    static {
        $assertionsDisabled = !Impose.class.desiredAssertionStatus();
    }
}

