/*
 * Decompiled with CFR 0.152.
 */
package phelps.lang;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Characters {
    private static String[] TYPE = new String[]{"Cn", "Other, not assigned", "Lu", "Letter, uppercase", "Ll", "Letter, lowercase", "Lt", "Letter, titlecase", "Lm", "Letter, modifier", "Lo", "Letter, other", "Mn", "Mark, nonspacing", "Me", "Mark, enclosing", "Mc", "Mark, spacing combining", "Nd", "Number, decimal digit", "Nl", "Number, letter", "No", "Number, other", "Zs", "Separator, space", "Zl", "Separator, line", "Zp", "Separator, paragraph", "Cc", "Other, control", "Cf", "Other, format", "", "", "Co", "Other, private use", "Cs", "Other, surrogate", "Pd", "Punctuation, dash", "Ps", "Punctuation, open", "Pe", "Punctuation, close", "Pc", "Punctuation, connector", "Po", "Punctuation, other", "Sm", "Symbol, math", "Sc", "Symbol, currency", "Sk", "Symbol, modifier", "So", "Symbol, other", "Pi", "Punctuation, initial quote", "Pf", "Punctuation, final quote"};
    private static String[] CHARNAME = null;
    private static Character[] SHARED = null;

    private Characters() {
    }

    public static boolean isHexDigit(int n) {
        return 48 <= n && n <= 57 || 97 <= n && n <= 102 || 65 <= n && n <= 70;
    }

    public static Character valueOf(char c) {
        if (SHARED == null) {
            SHARED = new Character[256];
            int n = SHARED.length;
            for (int i = 0; i < n; ++i) {
                Characters.SHARED[i] = new Character((char)i);
            }
        }
        return c < SHARED.length ? SHARED[c] : new Character(c);
    }

    public static String strType(int n) {
        return TYPE[n * 2];
    }

    public static String strTypeFull(int n) {
        return TYPE[n * 2 + 1];
    }

    public static String getName(int n) {
        if (CHARNAME == null) {
            try {
                String string;
                int n2 = 65536;
                CHARNAME = new String[n2];
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Characters.class.getResourceAsStream("/org/unicode/UnicodeData.txt")));
                String string2 = "";
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split(";");
                    String string3 = stringArray[1];
                    if (string3.equals(string2)) {
                        string3 = string2;
                    }
                    int n3 = -1;
                    try {
                        n3 = Integer.parseInt(stringArray[0], 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n3 < n2) {
                        Characters.CHARNAME[n3] = string3;
                    }
                    string2 = string3;
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 0 < n && n < CHARNAME.length ? CHARNAME[n] : null;
    }

    public static String toUTF8(int n) {
        StringBuffer stringBuffer = new StringBuffer(3);
        if (n <= 127) {
            stringBuffer.append((char)n);
        } else if (n <= 2047) {
            stringBuffer.append((char)(0xC0 | n >> 6)).append((char)(0x80 | n & 0x3F));
        } else if (n <= 65535) {
            stringBuffer.append((char)(0xE0 | n >> 12)).append((char)(0x80 | n >> 6 & 0x3F)).append((char)(0x80 | n & 0x3F));
        } else {
            stringBuffer.append((char)(0xF0 | n >> 18)).append((char)(0x80 | n >> 12 & 0x3F)).append((char)(0x80 | n >> 6 & 0x3F)).append((char)(0x80 | n & 0x3F));
        }
        return stringBuffer.toString();
    }
}

