/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.lens;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Context;
import multivalent.ContextListener;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.gui.VFrame;
import multivalent.node.LeafZero;
import multivalent.std.lens.LensMan;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Lens
extends Behavior
implements ContextListener {
    public static final String ATTR_X = "x";
    public static final String ATTR_Y = "y";
    public static final String ATTR_WIDTH = "width";
    public static final String ATTR_HEIGHT = "height";
    public static final String ATTR_TITLE = "title";
    public static final String VAR_SHARED_LAYER = "<lens>";
    protected VFrame win_ = null;

    public Rectangle getContentBounds() {
        return this.win_.getContentBounds();
    }

    protected LensMan getLensMan() {
        return (LensMan)this.getBrowser().getRoot().getLayer(VAR_SHARED_LAYER).getBehavior("LensMan", "multivalent.std.lens.LensMan");
    }

    @Override
    public final int getPriority() {
        return 1000000;
    }

    @Override
    public boolean appearance(Context context, boolean bl) {
        return false;
    }

    @Override
    public boolean paintBefore(Context context, Node node) {
        return super.paintBefore(context, node);
    }

    @Override
    public boolean paintAfter(Context context, Node node) {
        Graphics2D graphics2D = context.g;
        Rectangle rectangle = this.getContentBounds();
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        return super.paintAfter(context, node);
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (this.win_ != null && semanticEvent.getArg() == this.win_) {
            if ("frameRaised" == string) {
                this.getLensMan().raiseLens(this);
            } else if ("frameClosed" == string) {
                this.close();
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public ESISNode save() {
        Rectangle rectangle = this.win_.bbox;
        this.putAttr(ATTR_X, Integer.toString(rectangle.x));
        this.putAttr(ATTR_Y, Integer.toString(rectangle.y));
        this.putAttr(ATTR_WIDTH, Integer.toString(rectangle.width));
        this.putAttr(ATTR_HEIGHT, Integer.toString(rectangle.height));
        return super.save();
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        String string = this.getClass().getName();
        this.win_ = new VFrame(string, null, null);
        this.win_.setPinned(false);
        new LeafZero("OVERWRITTEN", null, this.win_);
        this.win_.setBounds(Integers.parseInt(this.getAttr(ATTR_X), 100), Integers.parseInt(this.getAttr(ATTR_Y), 100), Integers.parseInt(this.getAttr(ATTR_WIDTH), 300), Integers.parseInt(this.getAttr(ATTR_HEIGHT), 200));
        String string2 = this.getAttr(ATTR_TITLE, null);
        if (string2 == null) {
            string2 = string;
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            if (string2.endsWith("Lens") && string2.length() > 4) {
                string2 = string2.substring(0, string2.length() - "Lens".length());
            }
        }
        this.win_.setTitle(string2);
        this.show();
    }

    @Override
    public void destroy() {
        this.getLensMan().deleteLens(this);
        super.destroy();
    }

    public void close() {
        this.win_.remove();
        this.win_ = null;
        this.getBrowser().repaint(100L);
        this.destroy();
    }

    public void show() {
        Document document = this.getDocument();
        this.win_.setLocation(Math.min(this.win_.bbox.x, document.bbox.width - 10), Math.min(this.win_.bbox.y, document.bbox.height - 10));
        LensMan lensMan = this.getLensMan();
        lensMan.getVisualLayer().appendChild(this.win_);
        lensMan.addLens(this);
        this.getBrowser().repaint(100L);
    }
}

