/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import multivalent.Context;
import multivalent.node.FixedIClip;
import multivalent.std.adaptor.pdf.Dict;

public class GraphicsState {
    public AffineTransform ctm;
    public ColorSpace fCS;
    public ColorSpace sCS;
    public Color fillcolor;
    public Color strokecolor;
    public Dict fontdict;
    public double pointsize;
    public double Tw;
    public double Tc;
    public double Tz;
    public double Ts;
    public double TL;
    public int Tr;
    public float linewidth;
    public int linecap;
    public int linejoin;
    public float miterlimit;
    public float[] dasharray;
    public float dashphase;
    public String renderingintent;
    public int flatness;
    public double smoothness;
    public float alphastroke;
    public float alphanonstroke;
    public FixedIClip clip;

    public GraphicsState() {
        this.ctm = new AffineTransform();
        this.strokecolor = Color.BLACK;
        this.fillcolor = Color.BLACK;
        this.sCS = this.fCS = ColorSpace.getInstance(1003);
        this.fontdict = null;
        this.pointsize = 1.0;
        this.Tc = 0.0;
        this.Tw = 0.0;
        this.Tz = 100.0;
        this.TL = 0.0;
        this.Ts = 0.0;
        this.Tr = 0;
        this.linewidth = Context.STROKE_DEFAULT.getLineWidth();
        this.linecap = Context.STROKE_DEFAULT.getEndCap();
        this.linejoin = Context.STROKE_DEFAULT.getLineJoin();
        this.miterlimit = Context.STROKE_DEFAULT.getMiterLimit();
        this.dasharray = Context.STROKE_DEFAULT.getDashArray();
        this.dashphase = Context.STROKE_DEFAULT.getDashPhase();
    }

    public GraphicsState(GraphicsState graphicsState) {
        this.ctm = new AffineTransform(graphicsState.ctm);
        this.linewidth = graphicsState.linewidth;
        this.linecap = graphicsState.linecap;
        this.linejoin = graphicsState.linejoin;
        this.miterlimit = graphicsState.miterlimit;
        this.dasharray = graphicsState.dasharray;
        this.dashphase = graphicsState.dashphase;
        this.renderingintent = graphicsState.renderingintent;
        this.flatness = graphicsState.flatness;
        this.smoothness = graphicsState.smoothness;
        this.fCS = graphicsState.fCS;
        this.sCS = graphicsState.sCS;
        this.fillcolor = graphicsState.fillcolor;
        this.strokecolor = graphicsState.strokecolor;
        this.fontdict = graphicsState.fontdict;
        this.pointsize = graphicsState.pointsize;
        this.Tr = graphicsState.Tr;
        this.Tc = graphicsState.Tc;
        this.Tw = graphicsState.Tw;
        this.Tz = graphicsState.Tz;
        this.TL = graphicsState.TL;
        this.Ts = graphicsState.Ts;
        this.alphastroke = graphicsState.alphastroke;
        this.alphanonstroke = graphicsState.alphanonstroke;
        this.clip = graphicsState.clip;
    }

    public String toString() {
        return this.ctm.toString();
    }
}

