/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.Cache;
import com.pt.io.InputUni;
import com.pt.io.InputUniFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import phelps.io.Files;
import phelps.net.URIs;

public class CacheFile
extends Cache {
    private static final boolean DEBUG = true;
    String root_;
    String home_;

    public CacheFile() throws IOException {
        this(new File(System.getProperty("java.io.tmpdir") + "/v"), new File(System.getProperty("user.home")));
    }

    public CacheFile(File file, File file2) throws IOException {
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.canRead()) {
            throw new IOException("can't write to " + file);
        }
        this.root_ = file.getCanonicalPath();
        this.home_ = file2 != null && file2.exists() ? file2.getCanonicalPath() : "--NO HOME--";
    }

    public InputUni getInputUni(URI uRI, String string, String string2) {
        File file = this.mapTo(uRI, string, string2);
        return file != null && file.exists() ? new InputUniFile(file) : null;
    }

    public OutputStream getOutputStream(URI uRI, String string, String string2) {
        BufferedOutputStream bufferedOutputStream = null;
        File file = this.mapTo(uRI, string, string2);
        if (file != null) {
            try {
                file.getParentFile().mkdirs();
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return bufferedOutputStream;
    }

    private File mapTo(URI uRI, String string, String string2) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.root_);
        if (string2 == null || string2.length() == 0) {
            string2 = "general";
        }
        stringBuffer.append('/').append(string2);
        uRI = URIs.canonicalize(uRI);
        String string4 = uRI != null ? uRI.getScheme().toLowerCase() : null;
        String string5 = string3 = uRI != null ? uRI.getSchemeSpecificPart() : null;
        if (uRI != null) {
            if ("file".equals(string4) || "jar".equals(string4) || "systemresource".equals(string4)) {
                String string6 = uRI.getPath();
                if (string6.startsWith(this.home_)) {
                    string6 = "/~" + string6.substring(this.home_.length());
                }
                if (new File(string6).isDirectory()) {
                    string6 = string6 + "/";
                }
                if (Files.isCompressed(string6)) {
                    string6 = string6.substring(0, string6.lastIndexOf(46));
                }
                if (string == null || string6.startsWith(this.root_)) {
                    return null;
                }
                stringBuffer.append("/local").append(string6);
            } else if ("http".equals(string4) || "https".equals(string4) || "ftp".equals(string4)) {
                String string7;
                String string8 = uRI.getHost();
                String string9 = uRI.getPath();
                int n = uRI.getPort();
                if (string8 == null || string8.equals("")) {
                    string8 = "localhost";
                }
                int n2 = string8.indexOf(46);
                if (string8.lastIndexOf(46) > n2 && ("http".equals(string7 = string8.substring(0, n2)) || "www".equals(string7) || string7.startsWith("www") && n2 >= 4 && Character.isDigit(string7.charAt(4)))) {
                    string8 = string8.substring(n2 + 1);
                }
                if (string4.startsWith("http") && string9.endsWith("/")) {
                    string9 = string9 + "index.html";
                }
                if (Files.isCompressed(string9)) {
                    string9 = string9.substring(0, string9.lastIndexOf(46));
                }
                if (string3.indexOf(63) != -1) {
                    return null;
                }
                stringBuffer.append("/network");
                while (string8.length() > 0) {
                    n2 = string8.lastIndexOf(46);
                    stringBuffer.append('/').append(string8.substring(n2 + 1));
                    string8 = n2 <= 0 ? "" : string8.substring(0, n2);
                }
                if (n != 80 && n != -1) {
                    stringBuffer.append(':').append(n);
                }
                stringBuffer.append(string9);
            } else {
                if (string == null) {
                    return null;
                }
                stringBuffer.append("/").append(string4).append("/").append(string3);
            }
        }
        stringBuffer.append('/').append(string == null ? "data.bin" : string);
        return new File(stringBuffer.toString());
    }

    public void delete(URI uRI, String string, String string2) {
        File file = this.mapTo(uRI, string, string2);
        if (file != null && file.exists()) {
            Object object;
            System.out.println("expire " + uRI + " => delete " + file);
            if (string == null) {
                object = file.getParentFile().listFiles();
                int n = ((File[])object).length;
                for (int i = 0; i < n; ++i) {
                    Object object2 = object[i];
                    ((File)object2).delete();
                }
            } else {
                file.delete();
            }
            object = file.getParentFile();
            while (((File)object).list().length == 0) {
                ((File)object).delete();
                object = ((File)object).getParentFile();
            }
        }
    }

    public void clear() {
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        int n;
        String[] stringArray2;
        CacheFile cacheFile = new CacheFile();
        String[] stringArray3 = stringArray2 = new String[]{"http://www.nytimes.com", "http://www.cs.berkeley.edu/~phelps/tcltk/index.html", "manualpage:ls(1)", "http://dlp.CS.Berkeley.EDU/cgi-bin/pl_displaypage?page=&format=gif&id=2&collection=NLP", "jar:file:/Users/phelps/Multivalent.jar!/sys/Preferences.txt", "jar:file:/C:/Program%20Files/Multivalent20011205.jar!/multivalent/std/span/InsertSpan-edit.html"};
        int n2 = stringArray3.length;
        for (n = 0; n < n2; ++n) {
            String string = stringArray3[n];
            object = URI.create(string);
            System.out.println(object);
            System.out.println("\t" + cacheFile.mapTo((URI)object, null, "general"));
        }
        String[] stringArray4 = stringArray3 = new String[]{"/C:\\WINDOWS\\Fonts\\Arial.ttf", "/Applications/Palm/Tutorial/Bakery", "/Users/phelps/.cache/somefile.txt", cacheFile.root_ + "/withincache.txt"};
        n = stringArray4.length;
        for (int i = 0; i < n; ++i) {
            object = stringArray4[i];
            URI uRI = new File((String)object).toURI();
            System.out.println(uRI);
            System.out.println("\t" + cacheFile.mapTo(uRI, null, "general"));
        }
    }
}

