/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt.font;

import com.pt.awt.NFont;
import com.pt.awt.font.BitmapRec;
import com.pt.awt.font.GlyphRec;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import phelps.lang.Integers;

public class CacheBitmap {
    public static final CacheBitmap NONE;
    static final boolean osx_;
    private static final int RGB_MASK = 0xFFFFFF;
    private static final int ALPHA_MASK = -16777216;
    private static final byte[] DARKER;
    private static float pixelsmax_;
    private BitmapRec[][] segs_;
    private String name_;
    int[] widths;
    private float size_;
    private AffineTransform u_;
    private int[] buf_ = Integers.ARRAY0;
    private Color color_ = Color.BLACK;
    private int statNew_ = 0;
    private int statUse_ = 0;
    private int statRecolor_ = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void setPixelsMax(float f) {
        pixelsmax_ = f;
    }

    static float getPixelsMax() {
        return pixelsmax_;
    }

    private CacheBitmap() {
    }

    CacheBitmap(NFont nFont, AffineTransform affineTransform, int[] nArray) {
        this.name_ = nFont.getName();
        this.widths = nArray;
        this.size_ = nFont.getSize();
        this.u_ = new AffineTransform(affineTransform);
        if (!$assertionsDisabled && nFont.isTransformed()) {
            throw new AssertionError((Object)nFont.getName());
        }
        this.u_.scale(this.size_, this.size_);
        this.segs_ = new BitmapRec[nFont.getMaxGlyphNum() / 256 + 1][];
    }

    public String getName() {
        return this.name_;
    }

    public float getSize() {
        return this.size_;
    }

    public int getCount() {
        return this.statNew_;
    }

    Color getColor() {
        return this.color_;
    }

    public void setColor(Color color) {
        this.color_ = color;
    }

    public BitmapRec getBitmap(int n, GlyphRec glyphRec, double d) {
        BufferedImage bufferedImage;
        int n2;
        BitmapRec bitmapRec;
        BitmapRec[] bitmapRecArray = this.segs_[n >> 8];
        if (bitmapRecArray == null) {
            BitmapRec[] bitmapRecArray2 = new BitmapRec[256];
            this.segs_[n >> 8] = bitmapRecArray2;
            bitmapRecArray = bitmapRecArray2;
        }
        if ((bitmapRec = bitmapRecArray[n & 0xFF]) == null) {
            float f = glyphRec.xmin * this.size_;
            float f2 = glyphRec.xmax * this.size_;
            float f3 = glyphRec.ymin * this.size_;
            float f4 = glyphRec.ymax * this.size_;
            float f5 = (f2 - f) * (float)d;
            int n3 = (int)Math.floor(f) - 1;
            int n4 = (int)Math.ceil(f4) + 1;
            int n5 = (int)Math.ceil(f + f5 - (float)n3) + 1;
            int n6 = (int)Math.ceil((float)n4 - f3) + 1;
            BufferedImage bufferedImage2 = new BufferedImage(n5, n6, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.translate(-n3, n4);
            graphics2D.transform(this.u_);
            graphics2D.scale(d, 1.0);
            graphics2D.setColor(this.color_);
            graphics2D.fill(glyphRec.shape);
            graphics2D.dispose();
            if (!osx_ && bufferedImage2.getRGB(0, 0) == 0) {
                bufferedImage2.setRGB(0, 0, this.color_.getRGB() & 0xFFFFFF);
            }
            BitmapRec bitmapRec2 = new BitmapRec(bufferedImage2, n3, -n4);
            bitmapRecArray[n & 0xFF] = bitmapRec2;
            bitmapRec = bitmapRec2;
            ++this.statNew_;
        } else if (!osx_ && (n2 = this.color_.getRGB() & 0xFFFFFF) != ((bufferedImage = bitmapRec.img).getRGB(0, 0) & 0xFFFFFF)) {
            int n7;
            if (!$assertionsDisabled && osx_) {
                throw new AssertionError();
            }
            int[] nArray = this.buf_;
            int n8 = bufferedImage.getWidth();
            int n9 = n8 * (n7 = bufferedImage.getHeight());
            if (nArray.length < n9) {
                nArray = this.buf_ = new int[Math.max(n9, 100)];
            }
            bufferedImage.getRGB(0, 0, n8, n7, nArray, 0, n8);
            for (int i = 0; i < n9; ++i) {
                if (nArray[i] == 0) continue;
                nArray[i] = nArray[i] & 0xFF000000 | n2;
            }
            bufferedImage.setRGB(0, 0, n8, n7, nArray, 0, n8);
            if (bufferedImage.getRGB(0, 0) == 0) {
                bufferedImage.setRGB(0, 0, n2);
            }
            ++this.statRecolor_;
        }
        ++this.statUse_;
        return bitmapRec;
    }

    static {
        int n;
        $assertionsDisabled = !CacheBitmap.class.desiredAssertionStatus();
        NONE = new CacheBitmap();
        osx_ = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        DARKER = new byte[256];
        CacheBitmap.DARKER[0] = 0;
        int n2 = 231;
        for (n = 1; n < n2; ++n) {
            CacheBitmap.DARKER[n] = (byte)(n + 25);
        }
        for (n = 231; n < 256; ++n) {
            CacheBitmap.DARKER[n] = (byte)n;
        }
        pixelsmax_ = 33.333332f;
    }
}

