/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import org.jpedal.color.PdfPaint;
import org.jpedal.render.DynamicVectorRenderer;

public class RotatedTexturePaint
implements Paint,
PdfPaint {
    BufferedImage img;
    DynamicVectorRenderer glyphDisplay = null;
    TexturePaint rotatedPaint;
    private float[][] matrix;
    private float yStep;
    private float dx;
    private float dy;
    private AffineTransform imageScale;
    private float xStep;
    private float xx;
    private float yy;

    public RotatedTexturePaint(DynamicVectorRenderer dynamicVectorRenderer, float[][] fArray, float f, float f2, float f3, float f4, AffineTransform affineTransform) {
        this.glyphDisplay = dynamicVectorRenderer;
        this.matrix = fArray;
        this.xStep = f;
        this.yStep = f2;
        this.dx = f3;
        this.dy = f4;
        this.imageScale = affineTransform;
        if (this.matrix[0][0] != 0.0f && this.matrix[1][1] != 0.0f) {
            this.xx = this.xStep * this.matrix[0][1];
            this.yy = this.yStep * this.matrix[1][0];
        }
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = (int)rectangle2D.getWidth();
        int n2 = (int)rectangle2D.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        AffineTransform affineTransform2 = graphics2D.getTransform();
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = this.xStep * this.matrix[0][0] - this.yStep * this.matrix[1][0];
        float f6 = -(this.yStep * this.matrix[1][1]) - this.xStep * this.matrix[0][1];
        float f7 = rectangle2D.getBounds().width;
        float f8 = rectangle2D.getBounds().height;
        int n3 = (int)(f8 / f6);
        if (n3 > 1) {
            f3 = f7 - f6 * (float)n3;
            f4 = 5.0f - (f8 - f5 * (float)n3);
        } else if (f6 > f7) {
            f3 = f6 - f7;
            f4 = f8 - f5;
        } else {
            f3 = f8 - f6;
            f4 = f7 - f5;
        }
        float f9 = 0.0f;
        for (f9 = 0.0f; f9 < (float)n2 + this.yStep + this.dy; f9 += this.dy) {
            f2 = -this.yy - this.yy;
            for (float f10 = -this.dx; f10 < (float)n + this.xStep + this.dx; f10 += this.dx) {
                graphics2D.translate(f3 + f10 + f, f4 + f9 + f2);
                this.glyphDisplay.paint(graphics2D, null, this.imageScale, null, false, false);
                graphics2D.setTransform(affineTransform2);
                f2 += this.yy;
            }
            f -= this.xx;
        }
        Rectangle rectangle2 = rectangle2D.getBounds();
        this.rotatedPaint = new TexturePaint(bufferedImage, new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height));
        return this.rotatedPaint.createContext(colorModel, rectangle, rectangle2D, affineTransform, new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
    }

    public void setScaling(double d, double d2, float f) {
    }

    public boolean isPattern() {
        return false;
    }

    public void setPattern(int n) {
    }

    public int getRGB() {
        return 0;
    }

    public int getTransparency() {
        return 0;
    }
}

