/*
 * Decompiled with CFR 0.152.
 */
package edu.hope.cs.mcfall.ComponentFactory;

import edu.hope.cs.mcfall.ComponentFactory.BaseComponentFactory;
import edu.hope.cs.mcfall.ComponentFactory.ComponentFactory;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentFactory
extends BaseComponentFactory {
    public static final String FACTORY_CLASS_PROPERTY_KEY = "etext.ComponentFactoryClass";
    protected static ComponentFactory instance;
    protected List<ActionListener> actionListeners = new LinkedList<ActionListener>();
    protected List<ItemListener> itemListeners = new LinkedList<ItemListener>();
    protected List<ListSelectionListener> listSelectionListeners = new LinkedList<ListSelectionListener>();
    protected List<ChangeListener> changeListeners = new LinkedList<ChangeListener>();

    protected DefaultComponentFactory() {
    }

    public static ComponentFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        String componentFactoryClassName = System.getProperty(FACTORY_CLASS_PROPERTY_KEY);
        Class<?> componentFactoryClass = null;
        if (componentFactoryClassName == null) {
            componentFactoryClassName = "eTextReader.componentFactory.DefaultComponentFactory";
        }
        try {
            componentFactoryClass = Class.forName(componentFactoryClassName);
            instance = (DefaultComponentFactory)componentFactoryClass.newInstance();
            return instance;
        }
        catch (ClassNotFoundException e) {
            return new DefaultComponentFactory();
        }
        catch (InstantiationException e) {
            return new DefaultComponentFactory();
        }
        catch (IllegalAccessException e) {
            return new DefaultComponentFactory();
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addItemListener(ItemListener listener) {
        this.itemListeners.add(listener);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.itemListeners.remove(listener);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listSelectionListeners.add(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listSelectionListeners.remove(listener);
    }

    @Override
    public JButton createJButton(Object name) {
        JButton button = super.createJButton(name);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JButton createJButton(Object name, Action action) {
        JButton button = super.createJButton(name, action);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JButton createJButton(Object name, Icon icon) {
        JButton button = super.createJButton(name, icon);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JButton createJButton(Object name, String text) {
        JButton button = super.createJButton(name, text);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JButton createJButton(Object name, String text, Icon icon) {
        JButton button = super.createJButton(name, text, icon);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JCheckBox createJCheckBox(Object name) {
        JCheckBox checkBox = super.createJCheckBox(name);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBox createJCheckBox(Object name, Action action) {
        JCheckBox checkBox = super.createJCheckBox(name, action);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBox createJCheckBox(Object name, Icon icon) {
        JCheckBox checkBox = super.createJCheckBox(name, icon);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBox createJCheckBox(Object name, Icon icon, boolean selected) {
        JCheckBox checkBox = super.createJCheckBox(name, icon, selected);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBox createJCheckBox(Object name, String text) {
        JCheckBox checkBox = super.createJCheckBox(name, text);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBox createJCheckBox(Object name, String text, boolean selected) {
        JCheckBox checkBox = super.createJCheckBox(name, text, selected);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBox createJCheckBox(Object name, String text, Icon icon) {
        JCheckBox checkBox = super.createJCheckBox(name, text, icon);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBox createJCheckBox(Object name, String text, Icon icon, boolean selected) {
        JCheckBox checkBox = super.createJCheckBox(name, text, icon, selected);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBoxMenuItem createJCheckBoxMenuItem(Object name) {
        JCheckBoxMenuItem checkBox = super.createJCheckBoxMenuItem(name);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBoxMenuItem createJCheckBoxMenuItem(Object name, Action action) {
        JCheckBoxMenuItem checkBox = super.createJCheckBoxMenuItem(name, action);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBoxMenuItem createJCheckBoxMenuItem(Object name, Icon icon) {
        JCheckBoxMenuItem checkBox = super.createJCheckBoxMenuItem(name, icon);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBoxMenuItem createJCheckBoxMenuItem(Object name, Icon icon, boolean selected) {
        JCheckBoxMenuItem checkBox = super.createJCheckBoxMenuItem(name, icon, selected);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBoxMenuItem createJCheckBoxMenuItem(Object name, String text) {
        JCheckBoxMenuItem checkBox = super.createJCheckBoxMenuItem(name, text);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBoxMenuItem createJCheckBoxMenuItem(Object name, String text, boolean selected) {
        JCheckBoxMenuItem checkBox = super.createJCheckBoxMenuItem(name, text, selected);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBoxMenuItem createJCheckBoxMenuItem(Object name, String text, Icon icon) {
        JCheckBoxMenuItem checkBox = super.createJCheckBoxMenuItem(name, text, icon);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JCheckBoxMenuItem createJCheckBoxMenuItem(Object name, String text, Icon icon, boolean selected) {
        JCheckBoxMenuItem checkBox = super.createJCheckBoxMenuItem(name, text, icon, selected);
        this.setupListeners(checkBox);
        return checkBox;
    }

    @Override
    public JComboBox createJComboBox(Object name) {
        JComboBox comboBox = super.createJComboBox(name);
        this.setupListeners(comboBox);
        return comboBox;
    }

    @Override
    public JComboBox createJComboBox(Object name, ComboBoxModel model) {
        JComboBox comboBox = super.createJComboBox(name, model);
        this.setupListeners(comboBox);
        return comboBox;
    }

    @Override
    public JComboBox createJComboBox(Object name, Object[] items) {
        JComboBox comboBox = super.createJComboBox(name, items);
        this.setupListeners(comboBox);
        return comboBox;
    }

    @Override
    public JComboBox createJComboBox(Object name, Vector<?> items) {
        JComboBox comboBox = super.createJComboBox(name, items);
        this.setupListeners(comboBox);
        return comboBox;
    }

    @Override
    public JComboBox createJComboBox(Object name, Collection<?> items) {
        JComboBox comboBox = super.createJComboBox(name, items);
        this.setupListeners(comboBox);
        return comboBox;
    }

    @Override
    public JList createJList(Object name) {
        JList list = super.createJList(name);
        this.setupListeners(list);
        return list;
    }

    @Override
    public JTextField createJTextField(Object name, Document document, String text, int columns) {
        JTextField field = super.createJTextField(name, document, text, columns);
        this.setupListeners(field);
        return field;
    }

    @Override
    public JTextField createJTextField(Object name, int columns) {
        JTextField field = super.createJTextField(name, columns);
        this.setupListeners(field);
        return field;
    }

    @Override
    public JTextField createJTextField(Object name, String text, int columns) {
        JTextField field = super.createJTextField(name, text, columns);
        this.setupListeners(field);
        return field;
    }

    @Override
    public JTextField createJTextField(Object name, String text) {
        JTextField field = super.createJTextField(name, text);
        this.setupListeners(field);
        return field;
    }

    @Override
    public JTextField createJTextField(Object name) {
        JTextField field = super.createJTextField(name);
        this.setupListeners(field);
        return field;
    }

    @Override
    public JPanel createJPanel(Object name, boolean isDoubleBuffered) {
        JPanel panel = super.createJPanel(name, isDoubleBuffered);
        this.setupListeners(panel);
        return panel;
    }

    @Override
    public JPanel createJPanel(Object name, LayoutManager layout, boolean isDoubleBuffered) {
        JPanel panel = super.createJPanel(name, layout, isDoubleBuffered);
        this.setupListeners(panel);
        return panel;
    }

    @Override
    public JPanel createJPanel(Object name, LayoutManager layout) {
        JPanel panel = super.createJPanel(name, layout);
        this.setupListeners(panel);
        return panel;
    }

    @Override
    public JPanel createJPanel(Object name) {
        JPanel panel = super.createJPanel(name);
        this.setupListeners(panel);
        return panel;
    }

    @Override
    public JPasswordField createJPasswordField(Object name) {
        JPasswordField field = super.createJPasswordField(name);
        this.setupListeners(field);
        return field;
    }

    @Override
    public JPasswordField createJPasswordField(Object name, String text) {
        JPasswordField field = super.createJPasswordField(name, text);
        this.setupListeners(field);
        return field;
    }

    @Override
    public JScrollPane createJScrollPane(Object name, Component view, int vsbPolicy, int hsbPolicy) {
        JScrollPane pane = super.createJScrollPane(name, view, vsbPolicy, hsbPolicy);
        this.setupListeners(pane);
        return pane;
    }

    @Override
    public JScrollPane createJScrollPane(Object name, Component view) {
        JScrollPane pane = super.createJScrollPane(name, view);
        this.setupListeners(pane);
        return pane;
    }

    @Override
    public JScrollPane createJScrollPane(Object name, int vsbPolicy, int hsbPolicy) {
        JScrollPane pane = super.createJScrollPane(name, vsbPolicy, hsbPolicy);
        this.setupListeners(pane);
        return pane;
    }

    @Override
    public JScrollPane createJScrollPane(Object name) {
        JScrollPane pane = super.createJScrollPane(name);
        this.setupListeners(pane);
        return pane;
    }

    @Override
    public JList createJList(Object name, ListModel model) {
        JList list = super.createJList(name, model);
        this.setupListeners(list);
        return list;
    }

    @Override
    public JList createJList(Object name, Object[] items) {
        JList list = super.createJList(name, items);
        this.setupListeners(list);
        return list;
    }

    @Override
    public JList createJList(Object name, Vector<?> items) {
        JList list = super.createJList(name, items);
        this.setupListeners(list);
        return list;
    }

    @Override
    public JList createJList(Object name, Collection<?> items) {
        JList list = super.createJList(name, items);
        this.setupListeners(list);
        return list;
    }

    @Override
    public JMenuItem createJMenuItem(Object name) {
        JMenuItem item = super.createJMenuItem(name);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JMenuItem createJMenuItem(Object name, Action action) {
        JMenuItem item = super.createJMenuItem(name, action);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JMenuItem createJMenuItem(Object name, Icon icon) {
        JMenuItem item = super.createJMenuItem(name, icon);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JMenuItem createJMenuItem(Object name, String text) {
        JMenuItem item = super.createJMenuItem(name, text);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JMenuItem createJMenuItem(Object name, String text, Icon icon) {
        JMenuItem item = super.createJMenuItem(name, text, icon);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JMenuItem createJMenuItem(Object name, String text, int mnemonic) {
        JMenuItem item = super.createJMenuItem(name, text, mnemonic);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JProgressBar createJProgressBar() {
        JProgressBar progressBar = super.createJProgressBar();
        this.setupListeners(progressBar);
        return progressBar;
    }

    @Override
    public JProgressBar createJProgressBar(BoundedRangeModel model) {
        JProgressBar progressBar = super.createJProgressBar(model);
        this.setupListeners(progressBar);
        return progressBar;
    }

    @Override
    public JProgressBar createJProgressBar(int orientation) {
        JProgressBar progressBar = super.createJProgressBar(orientation);
        this.setupListeners(progressBar);
        return progressBar;
    }

    @Override
    public JProgressBar createJProgressBar(int min, int max) {
        JProgressBar progressBar = super.createJProgressBar(min, max);
        this.setupListeners(progressBar);
        return progressBar;
    }

    @Override
    public JProgressBar createJProgressBar(int orientation, int min, int max) {
        JProgressBar progressBar = super.createJProgressBar(orientation, min, max);
        this.setupListeners(progressBar);
        return progressBar;
    }

    @Override
    public JRadioButton createJRadioButton(Object name) {
        JRadioButton button = super.createJRadioButton(name);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JRadioButton createJRadioButton(Object name, Action action) {
        JRadioButton button = super.createJRadioButton(name, action);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JRadioButton createJRadioButton(Object name, Icon icon) {
        JRadioButton button = super.createJRadioButton(name, icon);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JRadioButton createJRadioButton(Object name, Icon icon, boolean selected) {
        JRadioButton button = super.createJRadioButton(name, icon, selected);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JRadioButton createJRadioButton(Object name, String text) {
        JRadioButton button = super.createJRadioButton(name, text);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JRadioButton createJRadioButton(Object name, String text, boolean selected) {
        JRadioButton button = super.createJRadioButton(name, text, selected);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JRadioButton createJRadioButton(Object name, String text, Icon icon) {
        JRadioButton button = super.createJRadioButton(name, text, icon);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JRadioButton createJRadioButton(Object name, String text, Icon icon, boolean selected) {
        JRadioButton button = super.createJRadioButton(name, text, icon, selected);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JRadioButtonMenuItem createJRadioButtonMenuItem() {
        JRadioButtonMenuItem item = super.createJRadioButtonMenuItem();
        this.setupListeners(item);
        return item;
    }

    @Override
    public JRadioButtonMenuItem createJRadioButtonMenuItem(Action action) {
        JRadioButtonMenuItem item = super.createJRadioButtonMenuItem(action);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JRadioButtonMenuItem createJRadioButtonMenuItem(Icon icon) {
        JRadioButtonMenuItem item = super.createJRadioButtonMenuItem(icon);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JRadioButtonMenuItem createJRadioButtonMenuItem(Icon icon, boolean selected) {
        JRadioButtonMenuItem item = super.createJRadioButtonMenuItem(icon, selected);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JRadioButtonMenuItem createJRadioButtonMenuItem(String text) {
        JRadioButtonMenuItem item = super.createJRadioButtonMenuItem(text);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JRadioButtonMenuItem createJRadioButtonMenuItem(String text, boolean selected) {
        JRadioButtonMenuItem item = super.createJRadioButtonMenuItem(text, selected);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JRadioButtonMenuItem createJRadioButtonMenuItem(String text, Icon icon) {
        JRadioButtonMenuItem item = super.createJRadioButtonMenuItem(text, icon);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JRadioButtonMenuItem createJRadioButtonMenuItem(String text, Icon icon, boolean selected) {
        JRadioButtonMenuItem item = super.createJRadioButtonMenuItem(text, icon, selected);
        this.setupListeners(item);
        return item;
    }

    @Override
    public JToggleButton createJToggleButton() {
        JToggleButton button = super.createJToggleButton();
        this.setupListeners(button);
        return button;
    }

    @Override
    public JToggleButton createJToggleButton(Action action) {
        JToggleButton button = super.createJToggleButton(action);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JToggleButton createJToggleButton(Icon icon) {
        JToggleButton button = super.createJToggleButton(icon);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JToggleButton createJToggleButton(Icon icon, boolean selected) {
        JToggleButton button = super.createJToggleButton(icon, selected);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JToggleButton createJToggleButton(String text) {
        JToggleButton button = super.createJToggleButton(text);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JToggleButton createJToggleButton(String text, boolean selected) {
        JToggleButton button = super.createJToggleButton(text, selected);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JToggleButton createJToggleButton(String text, Icon icon) {
        JToggleButton button = super.createJToggleButton(text, icon);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JToggleButton createJToggleButton(String text, Icon icon, boolean selected) {
        JToggleButton button = super.createJToggleButton(text, icon, selected);
        this.setupListeners(button);
        return button;
    }

    @Override
    public JFrame createJFrame(Object name, String title) {
        JFrame frame = super.createJFrame(name, title);
        return frame;
    }

    @Override
    public JTabbedPane createJTabbedPane(Object name, int tabPlacement, int tabLayoutPolicy) {
        JTabbedPane pane = super.createJTabbedPane(name, tabPlacement, tabLayoutPolicy);
        this.setupListeners(pane);
        return pane;
    }

    @Override
    public JTabbedPane createJTabbedPane(Object name, int tabPlacement) {
        JTabbedPane pane = super.createJTabbedPane(name, tabPlacement);
        this.setupListeners(pane);
        return pane;
    }

    @Override
    public JTabbedPane createJTabbedPane(Object name) {
        JTabbedPane pane = super.createJTabbedPane(name);
        this.setupListeners(pane);
        return pane;
    }

    private void setupListeners(JComponent component) {
        for (ActionListener actionListener : this.actionListeners) {
            this.setupListener(actionListener, component, "addActionListener", ActionListener.class);
        }
        for (ItemListener itemListener : this.itemListeners) {
            this.setupListener(itemListener, component, "addItemListener", ItemListener.class);
        }
        for (ChangeListener changeListener : this.changeListeners) {
            this.setupListener(changeListener, component, "addChangeListener", ChangeListener.class);
        }
    }

    private void setupListener(Object listener, JComponent component, String methodName, Class parameterClass) {
        Class<?> componentClass = component.getClass();
        try {
            Method listenerMethod = componentClass.getMethod(methodName, parameterClass);
            listenerMethod.invoke((Object)component, listener);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

