/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;

public class FindTextInRectangle {
    private String user_dir = System.getProperty("user.dir");
    String separator = System.getProperty("file.separator");
    PdfDecoder decodePdf = null;
    private String outputDir = "";
    private static String textToFind = "INVOICE";
    private static String testFile = "/home/markee/workspace/jpedalDEV/TestInvoice.pdf";

    public FindTextInRectangle() {
    }

    public FindTextInRectangle(String string) {
        File file;
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (!(file = new File(this.outputDir)).exists()) {
            file.mkdirs();
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(string);
        } else {
            String[] stringArray = null;
            File file2 = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file2 = new File(string);
                if (!file2.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file2.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                System.out.println(n + "/ " + l + ' ' + stringArray[n]);
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    System.out.println(string + stringArray[n]);
                    this.decodeFile(string + stringArray[n]);
                }
                ++n;
            }
        }
    }

    private void decodeFile(String string) {
        String string2 = "demo";
        int n = string.lastIndexOf(this.separator);
        if (n != -1) {
            string2 = string.substring(n + 1, string.length() - 4);
        }
        this.outputDir = this.user_dir + "text" + this.separator + string2 + this.separator;
        File file = new File(this.outputDir + this.separator);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            this.decodePdf = new PdfDecoder(false);
            this.decodePdf.setExtractionMode(1);
            this.decodePdf.init(true);
            System.out.println("Opening file :" + string);
            this.decodePdf.openPdfFile(string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code");
        }
        if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied() && !this.decodePdf.isExtractionAllowed()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at SimpleViewer for code sample to handle such files");
            System.out.println("Or get support/consultancy");
        } else {
            int n2 = 1;
            int n3 = this.decodePdf.getPageCount();
            System.out.println("3.51b12");
            System.out.println("Looking for word =" + textToFind + '<');
            try {
                for (int i = n2; i < n3 + 1; ++i) {
                    System.out.println("=========================");
                    System.out.println("Page " + i);
                    System.out.println("=========================");
                    this.decodePdf.decodePage(i);
                    PdfGroupingAlgorithms pdfGroupingAlgorithms = this.decodePdf.getGroupingObject();
                    if (pdfGroupingAlgorithms != null) {
                        PdfPageData pdfPageData = this.decodePdf.getPdfPageData();
                        int n4 = pdfPageData.getMediaBoxX(i);
                        int n5 = pdfPageData.getMediaBoxWidth(i) + n4;
                        int n6 = pdfPageData.getMediaBoxY(i);
                        int n7 = pdfPageData.getMediaBoxHeight(i) + n6;
                        System.out.println("Scanning for text (" + textToFind + ") rectangle (" + n4 + ',' + n7 + ' ' + n5 + ',' + n6 + ')');
                        float[] fArray = null;
                        try {
                            fArray = pdfGroupingAlgorithms.findTextInRectangle(n4, n7, n5, n6, i, textToFind, 2);
                        }
                        catch (PdfException pdfException) {
                            this.decodePdf.closePdfFile();
                            System.err.println("Exception " + pdfException.getMessage());
                            pdfException.printStackTrace();
                        }
                        if (fArray == null) {
                            System.out.println("Text not found");
                        } else {
                            System.out.println("Text found at " + fArray[0] + " , " + fArray[1]);
                        }
                    }
                    this.decodePdf.flushObjectValues(false);
                }
            }
            catch (Exception exception) {
                this.decodePdf.closePdfFile();
                System.err.println("Exception " + exception.getMessage());
            }
            this.decodePdf.flushObjectValues(true);
            System.out.println("Text read");
        }
        this.decodePdf.closePdfFile();
    }

    public static void main(String[] stringArray) {
        System.out.println("Simple demo to find  text in page");
        String string = testFile;
        if (stringArray.length != 2) {
            System.out.println("Please pass \"fileName\" \"text\" as 2 paramters on command line");
            System.out.println("You will need to use quotes if they contain spaces");
        } else {
            string = stringArray[0];
            textToFind = stringArray[1];
            System.out.println("File :" + string + " looking for " + textToFind);
        }
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + string + " not found");
        }
        FindTextInRectangle findTextInRectangle = new FindTextInRectangle(string);
    }
}

