/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.printing;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Hashtable;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import org.jpedal.PdfDecoder;
import org.jpedal.utils.LogWriter;

public class SilentPrint {
    private static boolean debugCode = false;
    private final String separator = System.getProperty("file.separator");
    private PdfDecoder decode_pdf = null;
    private int maxCopies = 5;
    private int copiesToPrint = 1;
    private int pageCount;
    private static String printer = "FinePrint";
    private String tray = null;
    public static boolean customSetting = false;
    public static int pageMark = 1;

    public SilentPrint() {
    }

    public SilentPrint(String string) {
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeAndPrintFile(string);
        } else {
            String[] stringArray = null;
            File file = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file = new File(string);
                if (!file.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    SilentPrint.logMessage(string + stringArray[n]);
                    this.decodeAndPrintFile(string + stringArray[n]);
                }
                ++n;
            }
        }
    }

    private void decodeAndPrintFile(String string) {
        try {
            SilentPrint.logMessage("Opening file :" + string + " to print.");
            this.decode_pdf = new PdfDecoder(true);
            this.decode_pdf.openPdfFile(string);
            this.pageCount = this.decode_pdf.getPageCount();
        }
        catch (Exception exception) {
            SilentPrint.reportError("Exception " + exception + " in pdf code");
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isExtractionAllowed()) {
            SilentPrint.logMessage("Encrypted settings");
        } else {
            this.printAllCopies();
        }
        this.decode_pdf.closePdfFile();
    }

    private final void printAllCopies() {
        for (int i = 0; i < this.copiesToPrint; ++i) {
            SilentPrint.logMessage("========================");
            SilentPrint.logMessage("\nPrinting copy " + (i + 1));
            SilentPrint.logMessage("========================");
            this.printPages();
        }
    }

    private void printPages() {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = printerJob.defaultPage();
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
            boolean bl = SilentPrint.validatePrinter(printer);
            if (bl) {
                if (this.tray != null) {
                    Class<?>[] classArray;
                    boolean bl2 = printerJob.getPrintService().isAttributeCategorySupported(Media.class);
                    if (bl2) {
                        classArray = new Hashtable();
                        Class clazz = Media.class;
                        Object object = printerJob.getPrintService().getSupportedAttributeValues(clazz, null, null);
                        if (object == null) {
                            SilentPrint.logMessage("Attribute " + clazz + " not supported");
                        } else if (object.getClass().isArray()) {
                            for (int i = 0; i < Array.getLength(object); ++i) {
                                Object object2 = Array.get(object, i);
                                classArray.put(object2.toString(), object2);
                                SilentPrint.logMessage("Atribute values " + object2.toString());
                            }
                        }
                        Object v = classArray.get(this.tray);
                        if (v != null) {
                            hashPrintRequestAttributeSet.add((Attribute)v);
                        }
                    } else {
                        SilentPrint.logMessage("Tray " + this.tray + " not implemented");
                        SilentPrint.logMessage("Atributes implemented are ");
                        classArray = printerJob.getPrintService().getSupportedAttributeCategories();
                        for (int i = 0; i < classArray.length; ++i) {
                            SilentPrint.logMessage(">>" + classArray[i].getName());
                        }
                    }
                }
                if (debugCode) {
                    Attribute[] attributeArray = hashPrintRequestAttributeSet.toArray();
                    int n = attributeArray.length;
                    for (int i = 0; i < n; ++i) {
                        SilentPrint.logMessage(i + " " + attributeArray[i].getName() + ' ' + attributeArray[i].toString());
                    }
                }
                Paper paper = new Paper();
                paper.setSize(595.0, 842.0);
                paper.setImageableArea(0.0, 0.0, 595.0, 842.0);
                pageFormat.setPaper(paper);
                printerJob.setCopies(1);
                this.decode_pdf.setCenterOnScaling(true);
                this.decode_pdf.setPrintAutoRotateAndCenter(true);
                this.decode_pdf.setPageFormat(pageFormat);
                if (customSetting) {
                    this.decode_pdf.setPagePrintRange(pageMark, pageMark);
                    System.out.println("Pagemark set to: " + pageMark);
                } else {
                    this.decode_pdf.setPagePrintRange(1, this.decode_pdf.getPageCount());
                }
                printerJob.setPageable(this.decode_pdf);
                printerJob.print();
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " printing");
        }
        catch (Error error) {
            LogWriter.writeLog("Error " + error + " printing");
        }
    }

    private static boolean validatePrinter(String string) throws PrinterException {
        boolean bl = false;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        int n = printServiceArray.length;
        for (int i = 0; i < n; ++i) {
            if (printServiceArray[i].getName().indexOf(string) == -1) continue;
            printerJob.setPrintService(printServiceArray[i]);
            i = n;
            bl = true;
            printer = string;
        }
        if (!bl) {
            String string2 = "";
            for (int i = 0; i < n; ++i) {
                string2 = string2 + '\"' + printServiceArray[i].getName() + "\",";
            }
            SilentPrint.reportError("Printer " + string + " not supported. Options=" + string2);
        }
        return bl;
    }

    private static void logMessage(String string) {
        if (debugCode) {
            System.out.println(string);
            LogWriter.writeLog(string);
        }
    }

    private static void reportError(String string) {
        System.err.println(string);
        LogWriter.writeLog(string);
    }

    public static void main(String[] stringArray) {
        SilentPrint.logMessage("Simple demo to print pages");
        if (stringArray.length != 2) {
            SilentPrint.logMessage("Printing needs 2 paramters");
            SilentPrint.logMessage("Parameter 1 - File name or directory (put in quotes if it contains spaces");
            SilentPrint.logMessage("Parameter 2- a printer name");
            SilentPrint.logMessage("If the printer name is not valid a list will be supplied of valid printers");
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        SilentPrint.logMessage("File :" + string);
        SilentPrint.logMessage("Printer :" + string2);
        boolean bl = false;
        try {
            bl = SilentPrint.validatePrinter(string2);
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
        }
        File file = new File(string);
        if (!file.exists()) {
            SilentPrint.logMessage("File " + string + " not found");
        } else if (!bl) {
            SilentPrint.logMessage("Printer " + string2 + " not found");
        } else {
            SilentPrint silentPrint = new SilentPrint(string);
        }
    }
}

