/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.media.jai.ImageLayout;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.AbsoluteDescriptor;
import javax.media.jai.operator.CropDescriptor;
import org.jpedal.color.ColorSpaces;
import org.jpedal.external.ImageHandler;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class ExampleImageDrawOnScreenHandler
implements ImageHandler {
    public boolean alwaysIgnoreGenericHandler() {
        return false;
    }

    public BufferedImage processImageData(GraphicsState graphicsState, PdfObject pdfObject, PdfObject pdfObject2) {
        return null;
    }

    public boolean imageHasBeenScaled() {
        return false;
    }

    public boolean drawImageOnscreen(BufferedImage bufferedImage, int n, AffineTransform affineTransform, String string, Graphics2D graphics2D, boolean bl, ObjectStore objectStore, boolean bl2) {
        boolean bl3;
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        boolean bl4 = bl3 = dArray[0] * dArray[1] != 0.0 || dArray[2] * dArray[3] != 0.0;
        if (bl3 || bufferedImage.getWidth() < 800 || bl) {
            graphics2D.drawImage(bufferedImage, affineTransform, null);
        } else {
            Object object;
            double d = 0.0;
            double d2 = 0.0;
            if (n != 0) {
                double d3;
                double d4;
                if ((n & 2) == 2) {
                    if (dArray[0] > 0.0 && dArray[3] < 0.0 && (n & 1) == 1) {
                        d4 = dArray[0] * (double)bufferedImage.getWidth();
                        d3 = -(dArray[3] * (double)bufferedImage.getHeight());
                        d = dArray[5] - d3;
                        dArray[5] = d3;
                        if (d4 - (double)((int)d4) > 0.5) {
                            d2 -= 1.0;
                        }
                    } else if (dArray[0] < 0.0 && dArray[3] > 0.0) {
                        d4 = dArray[0];
                        d3 = dArray[2];
                        dArray[0] = dArray[3];
                        dArray[3] = d4;
                        dArray[4] = 0.0;
                        dArray[5] = (int)(dArray[4] * (double)bufferedImage.getHeight() / (double)bufferedImage.getWidth());
                    }
                } else if (dArray[0] > 0.0 && dArray[3] > 0.0 && (n & 1) == 1) {
                    d = dArray[5];
                    d4 = dArray[0];
                    d3 = dArray[2];
                    dArray[0] = dArray[3];
                    dArray[3] = d4;
                    dArray[4] = 0.0;
                    dArray[5] = (int)(dArray[4] * (double)bufferedImage.getHeight() / (double)bufferedImage.getWidth());
                }
                affineTransform = new AffineTransform(dArray);
            }
            boolean bl5 = false;
            if (JAIHelper.isJAIused()) {
                if (!bl5 && string != null) {
                    bl5 = true;
                    try {
                        object = new Dimension(512, 512);
                        float f = 1.0f;
                        FileSeekableStream fileSeekableStream = new FileSeekableStream(new File(objectStore.getFileForCachedImage(string)));
                        ImageDecodeParam imageDecodeParam = null;
                        ImageDecoder imageDecoder = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)fileSeekableStream, imageDecodeParam);
                        int n2 = 0;
                        NullOpImage nullOpImage = new NullOpImage(imageDecoder.decodeAsRenderedImage(n2), null, 2, null);
                        ColorModel colorModel = nullOpImage.getColorModel();
                        ColorSpace colorSpace = colorModel.getColorSpace();
                        RenderingHints renderingHints = null;
                        if (nullOpImage.getTileWidth() * nullOpImage.getTileHeight() > ((Dimension)object).width * ((Dimension)object).height) {
                            colorModel = nullOpImage.getColorModel();
                            SampleModel sampleModel = nullOpImage.getSampleModel().createCompatibleSampleModel(((Dimension)object).width, ((Dimension)object).height);
                            ImageLayout imageLayout = new ImageLayout(0, 0, ((Dimension)object).width, ((Dimension)object).height, sampleModel, colorModel);
                            renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
                            nullOpImage = AbsoluteDescriptor.create((RenderedImage)nullOpImage, (RenderingHints)renderingHints);
                        }
                        bufferedImage = JAI.create((String)"affine", (RenderedImage)nullOpImage, (Object)affineTransform, (Object)new InterpolationBicubic(1)).getAsBufferedImage();
                        nullOpImage = null;
                        imageDecoder = null;
                    }
                    catch (Exception exception) {
                        bl5 = false;
                        exception.printStackTrace();
                    }
                    catch (Error error) {
                        bl5 = false;
                    }
                    string = null;
                }
                if (!bl5) {
                    LogWriter.writeLog("Unable to use JAI for image inversion");
                }
            } else {
                bl5 = true;
            }
            if (!bl5) {
                bl5 = true;
                try {
                    object = new AffineTransformOp(affineTransform, ColorSpaces.hints);
                    bufferedImage = ((AffineTransformOp)object).filter(bufferedImage, null);
                }
                catch (Exception exception) {
                    bl5 = false;
                    exception.printStackTrace();
                }
                catch (Error error) {
                    bl5 = false;
                }
            }
            if (bl5) {
                object = null;
                if (bl2 && d == 0.0) {
                    double[] dArray2 = new double[6];
                    graphics2D.getTransform().getMatrix(dArray2);
                    d2 = dArray2[4] / dArray2[0];
                    if (d2 > 0.0) {
                        d2 = -d2;
                    }
                    if ((d = dArray2[5] / dArray2[3]) > 0.0) {
                        d = -d;
                    }
                    d = -(d + (double)bufferedImage.getHeight());
                }
                if (d != 0.0) {
                    object = graphics2D.getClip();
                    int n3 = 1;
                    double d5 = graphics2D.getTransform().getScaleX();
                    n3 = d5 < 1.0 ? (int)(1.0 / d5) : (int)(d5 + 0.5);
                    int n4 = 1;
                    double d6 = graphics2D.getTransform().getScaleY();
                    n4 = d6 < 1.0 ? (int)(1.0 / d6) : (int)(d6 + 0.5);
                    graphics2D.clipRect((int)d2, (int)(d + 1.5), bufferedImage.getWidth() - n3, bufferedImage.getHeight() - n4);
                }
                graphics2D.drawImage((Image)bufferedImage, (int)d2, (int)d, null);
                if (object != null) {
                    graphics2D.setClip((Shape)object);
                }
            } else {
                graphics2D.drawImage(bufferedImage, affineTransform, null);
            }
        }
        return true;
    }

    public static synchronized BufferedImage getAffineTransform(RenderedImage renderedImage, AffineTransform affineTransform, RenderingHints renderingHints, float f) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        Dimension dimension = new Dimension((int)(dArray[0] * (double)renderedImage.getWidth()), (int)(dArray[3] * (double)renderedImage.getHeight()));
        Point2D point2D = new Point2D.Double(renderedImage.getTileGridXOffset(), renderedImage.getTileGridYOffset());
        point2D = affineTransform.transform(point2D, null);
        Rectangle rectangle = new Rectangle((int)point2D.getX(), (int)point2D.getY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle rectangle2 = affineTransform.createTransformedShape(rectangle).getBounds();
        System.out.println(">>" + renderedImage);
        System.out.println(">>" + rectangle2);
        ColorModel colorModel = renderedImage.getColorModel();
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(renderedImage.getTileWidth(), renderedImage.getTileHeight());
        TiledImage tiledImage = new TiledImage((int)rectangle2.getMinX(), (int)rectangle2.getMinY(), (int)rectangle2.getWidth(), (int)rectangle2.getHeight(), (int)point2D.getX(), (int)point2D.getY(), sampleModel, colorModel);
        KernelJAI kernelJAI = ExampleImageDrawOnScreenHandler.createBlurKernel((float)affineTransform.getScaleX(), (float)affineTransform.getScaleY(), f);
        int n = kernelJAI.getWidth();
        int n2 = kernelJAI.getHeight();
        AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
        affineTransform2.translate(point2D.getX(), point2D.getY());
        double d = (double)renderedImage.getWidth() / dimension.getWidth();
        double d2 = (double)renderedImage.getHeight() / dimension.getHeight();
        if (d % 2.0 > 0.0) {
            d += 1.0;
        }
        if (d2 % 2.0 > 0.0) {
            d2 += 1.0;
        }
        int n3 = (int)d;
        int n4 = (int)d2;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                BufferedImage bufferedImage;
                int n5 = (int)((double)i * dimension.getWidth());
                int n6 = (int)((double)j * dimension.getWidth());
                int n7 = (int)dimension.getWidth();
                int n8 = (int)dimension.getHeight();
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n5 + n7 > renderedImage.getWidth()) {
                    n7 = renderedImage.getWidth() - n5;
                }
                if (n6 + n8 > renderedImage.getHeight()) {
                    n8 = renderedImage.getHeight() - n6;
                }
                Rectangle rectangle3 = new Rectangle(n5, n6, n7, n8);
                n5 = rectangle3.x - n;
                n6 = rectangle3.y - n2;
                n7 = rectangle3.width + n * 2;
                n8 = rectangle3.height + n2 * 2;
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n5 + n7 > renderedImage.getWidth()) {
                    n7 = renderedImage.getWidth() - n5;
                }
                if (n6 + n8 > renderedImage.getHeight()) {
                    n8 = renderedImage.getHeight() - n6;
                }
                Rectangle rectangle4 = new Rectangle(n5, n6, n7, n8);
                WritableRaster writableRaster = null;
                try {
                    writableRaster = (WritableRaster)renderedImage.getData(rectangle4);
                }
                catch (Exception exception) {
                    writableRaster = null;
                }
                if (writableRaster == null) {
                    System.out.println(">>>");
                    continue;
                }
                writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
                BufferedImage bufferedImage2 = bufferedImage = new BufferedImage(renderedImage.getColorModel(), writableRaster, renderedImage.getColorModel().isAlphaPremultiplied(), null);
                if (f > 0.0f) {
                    bufferedImage2 = JAI.create((String)"convolve", (RenderedImage)bufferedImage, (Object)kernelJAI);
                    if (writableRaster.getWidth() - n * 2 > 0 && writableRaster.getHeight() - n2 * 2 > 0) {
                        bufferedImage2 = CropDescriptor.create((RenderedImage)bufferedImage2, (Float)new Float(n), (Float)new Float(n2), (Float)new Float(writableRaster.getWidth() - n * 2), (Float)new Float((float)writableRaster.getHeight() - (float)(n2 * 2)), (RenderingHints)renderingHints);
                    }
                }
                AffineTransform affineTransform3 = (AffineTransform)affineTransform2.clone();
                affineTransform3.translate(rectangle3.getX(), rectangle3.getY());
                Graphics2D graphics2D = tiledImage.createGraphics();
                graphics2D.drawRenderedImage(bufferedImage2, affineTransform3);
                graphics2D.dispose();
            }
        }
        return tiledImage.getAsBufferedImage();
    }

    public static KernelJAI createBlurKernel(float f, float f2, float f3) {
        f = Math.abs(f);
        f2 = Math.abs(f2);
        int n = 1 + Math.round(f3 / f);
        int n2 = 1 + Math.round(f3 / f2);
        if (n == 4 && n2 == 4) {
            n = 3;
            n2 = 3;
        }
        if (n == 5 && n2 == 5) {
            n = 3;
            n2 = 3;
        }
        if (n == 6 && n2 == 6) {
            n = 7;
            n2 = 7;
        }
        float[] fArray = new float[n * n2];
        float f4 = 1.0f / (float)fArray.length;
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f4;
        }
        return new KernelJAI(n, n2, fArray);
    }
}

