/*
 * Decompiled with CFR 0.152.
 */
package com.arashpayan.filetree;

import com.arashpayan.filetree.Constants;
import com.arashpayan.filetree.FileTree;
import com.arashpayan.filetree.FileTreeNode;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class FileTreeListener
extends MouseAdapter {
    private FileTree fileTree;

    public FileTreeListener(FileTree fileTree) {
        if (fileTree == null) {
            throw new IllegalArgumentException("Null argument not allowed");
        }
        this.fileTree = fileTree;
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.rightClick(e.getX(), e.getY());
        }
    }

    private void rightClick(int x, int y) {
        TreePath treePath = this.fileTree.getPathForLocation(x, y);
        if (treePath == null) {
            return;
        }
        if (!this.fileTree.isDeleteEnabled()) {
            return;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        File file = ((FileTreeNode)treeNode.getUserObject()).file;
        JPopupMenu popup = new JPopupMenu();
        popup.add(new DeleteFileAction(treePath));
        popup.show(this.fileTree, x, y);
    }

    private class DeleteFileAction
    extends AbstractAction {
        private TreePath treePath;
        private FileTreeNode fileTreeNode;

        public DeleteFileAction(TreePath treePath) {
            this.treePath = treePath;
            if (Constants.isOSX) {
                this.putValue("Name", "Move to Trash");
            } else {
                this.putValue("Name", "Delete");
                this.putValue("MnemonicKey", 68);
            }
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            this.fileTreeNode = (FileTreeNode)treeNode.getUserObject();
            if (!this.fileTreeNode.file.canWrite()) {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            int choice = JOptionPane.showConfirmDialog(FileTreeListener.this.fileTree.getRootPane(), "Are you sure you want to delete '" + this.fileTreeNode.file.getName() + "'?", "Confirm delete", 0, 3);
            if (choice == 1) {
                return;
            }
            boolean success = false;
            success = this.fileTreeNode.file.isDirectory() ? this.deleteDirectory(this.fileTreeNode.file) : this.fileTreeNode.file.delete();
            if (success) {
                FileTreeListener.this.fileTree.getFileTreeModel().removeNodeFromParent((DefaultMutableTreeNode)this.treePath.getLastPathComponent());
            }
        }

        private boolean deleteDirectory(File dir) {
            File[] list;
            if (dir == null || !dir.exists() || !dir.isDirectory()) {
                return false;
            }
            boolean success = true;
            File[] fileArray = list = dir.listFiles();
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    if (!this.deleteDirectory(file)) {
                        success = false;
                    }
                } else if (!file.delete()) {
                    success = false;
                }
                ++n2;
            }
            if (!dir.delete()) {
                success = false;
            }
            return success;
        }
    }

    private class RenameAction
    extends AbstractAction {
        private TreePath treePath;
        private FileTreeNode fileTreeNode;

        public RenameAction(TreePath treePath) {
            this.treePath = treePath;
            this.putValue("Name", "Rename");
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            this.fileTreeNode = (FileTreeNode)treeNode.getUserObject();
            if (!this.fileTreeNode.file.canWrite()) {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            FileTreeListener.this.fileTree.startEditingAtPath(this.treePath);
        }
    }
}

