/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.query.Query;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.query.RunSavedQueryCommand;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class SaveQueryCommand
implements Command {
    private Morpho morpho = null;
    private static Hashtable savedQueriesList = null;
    private MorphoFrame morphoFrame = null;
    private static final int STARTINDEXFORSAVEDQUERY = 6;

    public SaveQueryCommand(Morpho morpho) {
        this.morpho = morpho;
    }

    public void execute(ActionEvent event) {
        this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (this.morphoFrame == null) {
            Log.debug(5, "Morpho frame was null so I could refresh it!");
        }
        Component comp = this.morphoFrame.getContentComponent();
        Query query = null;
        if (comp != null && comp instanceof ResultPanel) {
            this.morphoFrame.setBusy(true);
            ResultPanel resultPane = (ResultPanel)comp;
            query = resultPane.getResultSet().getQuery();
            String identifier = query.getIdentifier();
            if (identifier == null) {
                DataPackageInterface dataPackage = null;
                try {
                    ServiceController services = ServiceController.getInstance();
                    ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                    dataPackage = (DataPackageInterface)((Object)provider);
                }
                catch (ServiceNotHandledException snhe) {
                    Log.debug(6, "Error in save query: " + snhe);
                }
                identifier = dataPackage.getNextId(this.morpho);
                query.setIdentifier(identifier);
            }
            try {
                Log.debug(10, "Saving query to disk...");
                query.save();
                Log.debug(10, "Adding query to menu...");
                SaveQueryCommand.addQueryToMenu(query);
                this.morphoFrame.setBusy(false);
            }
            catch (IOException ioe) {
                Log.debug(6, "Failed to save query: I/O error.");
            }
        }
    }

    private static void addQueryToMenu(Query query) {
        int index = 6;
        if (savedQueriesList == null) {
            savedQueriesList = new Hashtable();
        }
        if (!savedQueriesList.containsKey(query.getIdentifier())) {
            RunSavedQueryCommand command = new RunSavedQueryCommand(query);
            GUIAction savedSearchItemAction = new GUIAction(query.getQueryTitle(), null, command);
            savedSearchItemAction.setMenu("Search", 2);
            savedSearchItemAction.setMenuItemPosition(index);
            savedSearchItemAction.setToolTipText("Execute saved search");
            UIController.getInstance().addGuiAction(savedSearchItemAction);
            savedQueriesList.put(query.getIdentifier(), savedSearchItemAction);
            ++index;
        } else {
            GUIAction savedQueryAction = (GUIAction)savedQueriesList.get(query.getIdentifier());
            if (savedQueryAction.getCommand() instanceof RunSavedQueryCommand) {
                RunSavedQueryCommand queryCommand = (RunSavedQueryCommand)savedQueryAction.getCommand();
                queryCommand.setQuery(query);
                savedQueryAction.setCommand(queryCommand);
                savedQueryAction.putValue("Name", query.getQueryTitle());
            }
        }
    }

    public void loadSavedQueries() {
        SaveQueryCommand.loadSavedQueries(this.morpho);
    }

    public static void loadSavedQueries(Morpho myMorpho) {
        Log.debug(20, "Loading saved queries...");
        if (savedQueriesList == null) {
            savedQueriesList = new Hashtable();
        }
        if (!savedQueriesList.isEmpty()) {
            UIController controller = UIController.getInstance();
            Enumeration queryActions = savedQueriesList.elements();
            while (queryActions.hasMoreElements()) {
                GUIAction action = (GUIAction)queryActions.nextElement();
                controller.removeGuiAction(action);
            }
            savedQueriesList = new Hashtable();
        }
        ConfigXML config = myMorpho.getConfiguration();
        ConfigXML profile = myMorpho.getProfile();
        String queriesDirName = config.getConfigDirectory() + File.separator + config.get("profile_directory", 0) + File.separator + profile.get("profilename", 0) + File.separator + profile.get("queriesdir", 0);
        File queriesDir = new File(queriesDirName);
        if (queriesDir.exists()) {
            File[] queriesList = SaveQueryCommand.listFiles(queriesDir);
            for (int n = 0; n < queriesList.length; ++n) {
                File queryFile = queriesList[n];
                if (!queryFile.isFile()) continue;
                try {
                    FileReader xml = new FileReader(queryFile);
                    Query newQuery = new Query(xml, myMorpho);
                    SaveQueryCommand.addQueryToMenu(newQuery);
                    continue;
                }
                catch (FileNotFoundException fnf) {
                    Log.debug(9, "Poof. The query disappeared.");
                }
            }
        }
        Log.debug(20, "Finished loading saved queries.");
    }

    private static File[] listFiles(File dir) {
        String[] fileStrings = dir.list();
        int len = fileStrings.length;
        File[] list = new File[len];
        for (int i = 0; i < len; ++i) {
            list[i] = new File(dir, fileStrings[i]);
        }
        return list;
    }
}

