/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.TextImportListener;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageLibrary;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.AttributePage;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.ImportWizard;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.XMLUtil;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TextImportWizardEml2
extends JFrame {
    private JTable table;
    private JTable linesTable = null;
    private boolean hasReturnedFromScreen2;
    private boolean ignoreConsequtiveDelimiters = false;
    private int nlines_actual;
    private int nlines;
    private int nlines_max = 5000;
    private String[] lines;
    private File dataFile;
    private String shortFilename;
    private boolean parseOn = true;
    private int stepNumber = 1;
    private int startingLine = 1;
    private boolean labelsInStartingLine = false;
    private Vector colTitles;
    private Vector columnAttributes;
    private Vector columnMaps;
    private boolean[] needToSetPageData;
    private Vector vec;
    private TextImportListener listener = null;
    private TableColumnModel fullColumnModel = null;
    private String[] numberTypesArray = new String[]{"NATURAL (non-zero counting numbers: 1, 2, 3..)", "WHOLE  (counting numbers & zero: 0, 1, 2, 3..)", "INTEGER (+/- counting nums & zero: -2, -1, 0, 1..)", "REAL  (+/- fractions & non-fractions: -1/2, 3.14..)"};
    private short distribution = (short)10;
    private WizardContainerFrame mainWizFrame;
    private SymAction lSymAction;
    String[] screen1Settings = new String[2];
    private final int IMPORT_START_ROW = 0;
    private final int LABELS_IN_START_ROW = 1;
    String labelsInStartLine_Status = null;
    private FileDialog saveFileDialog = new FileDialog(this);
    private FileDialog openFileDialog = new FileDialog(this);
    private JPanel MainDisplayPanel = new JPanel();
    private JPanel ControlsPlusDataPanel = new JPanel();
    private JPanel ControlsPanel = new JPanel();
    private JPanel Step1FullControlsPanel = new JPanel();
    private JPanel Step1ControlsPanel = new JPanel();
    private JPanel Step1_TopTitlePanel = new JPanel();
    private JLabel Step1_TopTitleLabel = new JLabel();
    private JPanel Step1_TableNamePanel = new JPanel();
    private JLabel Step1_NameLabel = new JLabel();
    private JTextField TableNameTextField = new JTextField();
    private JPanel Step1_TableDescriptionPanel = new JPanel();
    private JLabel Step1_TableDescriptionLabel = new JLabel();
    private JTextField TableDescriptionTextField = new JTextField();
    private JPanel StartingLinePanel = new JPanel();
    private JLabel StartingLineLabel = new JLabel();
    private JTextField StartingLineTextField = new JTextField();
    private JLabel ColumnLabelsLabel = new JLabel();
    private JCheckBox ColumnLabelsCheckBox = new JCheckBox();
    private JPanel Step2FullControlsPanel = new JPanel();
    private JPanel Step2ControlsPanel = new JPanel();
    private JPanel Step2_TopLabelPanel = new JPanel();
    private JLabel Step2_TopLabel = new JLabel();
    private JPanel Step2_DelimiterChoicePanel = new JPanel();
    private JLabel Step2_DelimterChoiceLabel = new JLabel();
    private JCheckBox TabCheckBox = new JCheckBox();
    private JCheckBox CommaCheckBox = new JCheckBox();
    private JCheckBox SpaceCheckBox = new JCheckBox();
    private JCheckBox SemicolonCheckBox = new JCheckBox();
    private JCheckBox OtherCheckBox = new JCheckBox();
    private JTextField OtherTextField = new JTextField();
    private JPanel JPanel10 = new JPanel();
    private JPanel JPanel11 = new JPanel();
    private JPanel Step2_ConsequtivePanel = new JPanel();
    private JCheckBox ConsecutiveCheckBox = new JCheckBox();
    private JPanel DataPanel = new JPanel();
    private JScrollPane DataScrollPanel = new JScrollPane();
    private JScrollPane ColumnDataScrollPanel = new JScrollPane();
    private JPanel ColumnDataPanel = new JPanel();
    private JPanel ButtonsPanel = new JPanel();
    private JPanel JPanelLeft = new JPanel();
    private JPanel JPanelCenter = new JPanel();
    private JLabel StepNumberLabel = new JLabel();
    private JButton CancelButton;
    private JButton BackButton;
    private JButton NextButton;
    private JButton FinishButton;

    public TextImportWizardEml2(File file, TextImportListener listener, WizardContainerFrame container) {
        this.listener = listener;
        this.dataFile = file;
        this.shortFilename = this.dataFile.getName();
        this.mainWizFrame = container;
        this.setDistribution(this.distribution);
        this.initControls();
        this.registerListeners();
    }

    public boolean startImport() {
        this.TableNameTextField.setText(this.shortFilename);
        if (this.parsefile(this.dataFile)) {
            this.createLinesTable();
            this.stepNumber = 1;
            this.hasReturnedFromScreen2 = false;
            this.StepNumberLabel.setText("Step #" + this.stepNumber);
            CardLayout cl = (CardLayout)this.ControlsPanel.getLayout();
            cl.show(this.ControlsPanel, "card" + this.stepNumber);
            this.BackButton.setEnabled(false);
            this.FinishButton.setEnabled(false);
            this.NextButton.setEnabled(true);
            this.setVisible(true);
            return true;
        }
        return false;
    }

    private void initControls() {
        this.lSymAction = new SymAction();
        this.setTitle("New Data Table Wizard");
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(695, 500);
        this.setVisible(false);
        this.saveFileDialog.setMode(1);
        this.saveFileDialog.setTitle("Save");
        this.openFileDialog.setMode(0);
        this.openFileDialog.setTitle("Open");
        this.MainDisplayPanel.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)this.MainDisplayPanel, "Center");
        this.ControlsPlusDataPanel.setLayout(new GridLayout(2, 1, 0, 4));
        this.MainDisplayPanel.add((Component)this.ColumnDataScrollPanel, "West");
        this.MainDisplayPanel.add((Component)this.ControlsPlusDataPanel, "Center");
        this.ColumnDataScrollPanel.setPreferredSize(new Dimension(80, 4000));
        this.ColumnDataScrollPanel.setVisible(false);
        this.ControlsPanel.setLayout(new CardLayout(0, 0));
        this.ControlsPlusDataPanel.add(this.ControlsPanel);
        this.Step1FullControlsPanel.setAlignmentY(0.0f);
        this.Step1FullControlsPanel.setAlignmentX(0.0f);
        this.Step1FullControlsPanel.setLayout(new BorderLayout());
        this.ControlsPanel.add("card1", this.Step1FullControlsPanel);
        JLabel Step1_titleLabel = new JLabel("Text Import Wizard");
        Step1_titleLabel.setFont(WizardSettings.TITLE_FONT);
        Step1_titleLabel.setForeground(WizardSettings.TITLE_TEXT_COLOR);
        Step1_titleLabel.setBorder(new EmptyBorder(5, 0, 5, 0));
        JPanel Step1_topPanel = new JPanel();
        Step1_topPanel.setLayout(new BorderLayout());
        Step1_topPanel.setPreferredSize(WizardSettings.TOP_PANEL_DIMS);
        Step1_topPanel.setMaximumSize(WizardSettings.TOP_PANEL_DIMS);
        Step1_topPanel.setBorder(new EmptyBorder(0, 15, 0, 15));
        Step1_topPanel.setBackground(WizardSettings.TOP_PANEL_BG_COLOR);
        Step1_topPanel.setOpaque(true);
        Step1_topPanel.add((Component)Step1_titleLabel, "Center");
        this.Step1FullControlsPanel.add((Component)Step1_topPanel, "North");
        this.Step1ControlsPanel.setLayout(new BoxLayout(this.Step1ControlsPanel, 1));
        this.Step1_TopTitlePanel.setLayout(new FlowLayout(1, 5, 5));
        this.Step1ControlsPanel.add(this.Step1_TopTitlePanel);
        this.Step1_TopTitleLabel.setText("This set of screens will create metadata based on the content of the specified data file");
        this.Step1_TopTitlePanel.add(this.Step1_TopTitleLabel);
        this.Step1_TopTitleLabel.setForeground(Color.black);
        this.Step1_TopTitleLabel.setFont(new Font("Dialog", 1, 12));
        this.Step1_TableNamePanel.setLayout(new BoxLayout(this.Step1_TableNamePanel, 0));
        this.Step1ControlsPanel.add(this.Step1_TableNamePanel);
        this.Step1ControlsPanel.add(Box.createGlue());
        this.Step1_NameLabel.setText(" Table Name: ");
        this.Step1_NameLabel.setPreferredSize(WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.Step1_NameLabel.setMinimumSize(WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.Step1_NameLabel.setMaximumSize(WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.Step1_TableNamePanel.add(this.Step1_NameLabel);
        this.Step1_NameLabel.setForeground(Color.black);
        this.Step1_NameLabel.setFont(new Font("Dialog", 0, 12));
        this.Step1_TableDescriptionLabel.setMaximumSize(WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.Step1_TableDescriptionLabel.setMinimumSize(WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.Step1_TableDescriptionLabel.setPreferredSize(WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.TableNameTextField.setPreferredSize(WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS);
        this.TableNameTextField.setMaximumSize(WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS);
        this.Step1_TableNamePanel.add(this.TableNameTextField);
        this.Step1_TableDescriptionPanel.setLayout(new BoxLayout(this.Step1_TableDescriptionPanel, 0));
        this.Step1ControlsPanel.add(this.Step1_TableDescriptionPanel);
        this.Step1_TableDescriptionLabel.setText(" Description: ");
        this.Step1ControlsPanel.add(Box.createGlue());
        this.Step1_TableDescriptionPanel.add(this.Step1_TableDescriptionLabel);
        this.Step1_TableDescriptionLabel.setForeground(Color.black);
        this.Step1_TableDescriptionLabel.setFont(new Font("Dialog", 0, 12));
        this.TableDescriptionTextField.setPreferredSize(WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS);
        this.TableDescriptionTextField.setMaximumSize(WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS);
        this.Step1_TableDescriptionPanel.add(this.TableDescriptionTextField);
        this.StartingLinePanel.setLayout(new FlowLayout(0, 5, 5));
        this.Step1ControlsPanel.add(this.StartingLinePanel);
        this.StartingLineLabel.setText("Start import at row: ");
        this.StartingLinePanel.add(this.StartingLineLabel);
        this.StartingLineLabel.setForeground(Color.black);
        this.StartingLineLabel.setFont(new Font("Dialog", 0, 12));
        this.StartingLineTextField.setText("1");
        this.StartingLineTextField.setColumns(4);
        this.StartingLinePanel.add(this.StartingLineTextField);
        this.ColumnLabelsLabel.setText("     ");
        this.StartingLinePanel.add(this.ColumnLabelsLabel);
        this.ColumnLabelsCheckBox.setText("Column Labels are in starting row");
        this.ColumnLabelsCheckBox.setActionCommand("Column Labels are in starting row");
        this.ColumnLabelsCheckBox.setSelected(false);
        this.StartingLinePanel.add(this.ColumnLabelsCheckBox);
        this.ColumnLabelsCheckBox.setFont(new Font("Dialog", 0, 12));
        this.Step1FullControlsPanel.add((Component)this.Step1ControlsPanel, "Center");
        JLabel Step2_titleLabel = new JLabel("Text Import Wizard");
        Step2_titleLabel.setFont(WizardSettings.TITLE_FONT);
        Step2_titleLabel.setForeground(WizardSettings.TITLE_TEXT_COLOR);
        Step2_titleLabel.setBorder(new EmptyBorder(5, 0, 5, 0));
        JPanel Step2_topPanel = new JPanel();
        Step2_topPanel.setLayout(new BorderLayout());
        Step2_topPanel.setPreferredSize(WizardSettings.TOP_PANEL_DIMS);
        Step2_topPanel.setMaximumSize(WizardSettings.TOP_PANEL_DIMS);
        Step2_topPanel.setBorder(new EmptyBorder(0, 15, 0, 15));
        Step2_topPanel.setBackground(WizardSettings.TOP_PANEL_BG_COLOR);
        Step2_topPanel.setOpaque(true);
        Step2_topPanel.add((Component)Step2_titleLabel, "Center");
        this.Step2FullControlsPanel.setLayout(new BorderLayout());
        this.Step2FullControlsPanel.add((Component)Step2_topPanel, "North");
        this.Step2ControlsPanel.setLayout(new BoxLayout(this.Step2ControlsPanel, 1));
        this.ControlsPanel.add("card2", this.Step2FullControlsPanel);
        this.Step2FullControlsPanel.setVisible(false);
        this.Step2_TopLabelPanel.setLayout(new FlowLayout(1, 5, 5));
        this.Step2ControlsPanel.add(this.Step2_TopLabelPanel);
        this.Step2_TopLabel.setText("If the columns indicated in the table are incorrect, try changing the assumed delimiter(s)");
        this.Step2_TopLabelPanel.add(this.Step2_TopLabel);
        this.Step2_TopLabel.setForeground(Color.black);
        this.Step2_DelimiterChoicePanel.setLayout(new FlowLayout(0, 5, 5));
        this.Step2ControlsPanel.add(this.Step2_DelimiterChoicePanel);
        this.Step2_DelimterChoiceLabel.setText("  Delimiters: ");
        this.Step2_DelimiterChoicePanel.add(this.Step2_DelimterChoiceLabel);
        this.Step2_DelimterChoiceLabel.setForeground(Color.black);
        this.Step2_DelimterChoiceLabel.setFont(new Font("Dialog", 0, 12));
        this.TabCheckBox.setText("tab");
        this.TabCheckBox.setActionCommand("tab");
        this.TabCheckBox.setSelected(true);
        this.Step2_DelimiterChoicePanel.add(this.TabCheckBox);
        this.TabCheckBox.setFont(new Font("Dialog", 0, 12));
        this.CommaCheckBox.setText("comma");
        this.CommaCheckBox.setActionCommand("comma");
        this.Step2_DelimiterChoicePanel.add(this.CommaCheckBox);
        this.CommaCheckBox.setFont(new Font("Dialog", 0, 12));
        this.SpaceCheckBox.setText("space");
        this.SpaceCheckBox.setActionCommand("space");
        this.Step2_DelimiterChoicePanel.add(this.SpaceCheckBox);
        this.SpaceCheckBox.setFont(new Font("Dialog", 0, 12));
        this.SemicolonCheckBox.setText("semicolon");
        this.SemicolonCheckBox.setActionCommand("semicolon");
        this.Step2_DelimiterChoicePanel.add(this.SemicolonCheckBox);
        this.SemicolonCheckBox.setFont(new Font("Dialog", 0, 12));
        this.OtherCheckBox.setText("other");
        this.OtherCheckBox.setActionCommand("other");
        this.Step2_DelimiterChoicePanel.add(this.OtherCheckBox);
        this.OtherCheckBox.setFont(new Font("Dialog", 0, 12));
        this.OtherTextField.setColumns(2);
        this.Step2_DelimiterChoicePanel.add(this.OtherTextField);
        this.JPanel10.setLayout(new FlowLayout(1, 5, 5));
        this.JPanel11.setLayout(new FlowLayout(1, 5, 5));
        this.Step2_ConsequtivePanel.setLayout(new FlowLayout(0, 5, 5));
        this.Step2ControlsPanel.add(Box.createGlue());
        this.Step2ControlsPanel.add(this.Step2_ConsequtivePanel);
        this.ConsecutiveCheckBox.setText("Treat consecutive delimiters as one");
        this.ConsecutiveCheckBox.setActionCommand("Treat consecutive delimiters as one");
        this.Step2_ConsequtivePanel.add(this.ConsecutiveCheckBox);
        this.ConsecutiveCheckBox.setFont(new Font("Dialog", 0, 12));
        this.Step2FullControlsPanel.add((Component)this.Step2ControlsPanel, "Center");
        this.ControlsPanel.add("card3", this.ColumnDataPanel);
        this.ColumnDataPanel.setLayout(new BorderLayout(0, 0));
        this.ColumnDataPanel.setVisible(false);
        this.DataPanel.setLayout(new BorderLayout(0, 0));
        this.ControlsPlusDataPanel.add(this.DataPanel);
        this.DataPanel.add("Center", this.DataScrollPanel);
        ((CardLayout)this.ControlsPanel.getLayout()).show(this.ControlsPanel, "card1");
        this.ButtonsPanel.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("South", this.ButtonsPanel);
        this.JPanelLeft.setLayout(new FlowLayout(0, 5, 5));
        this.ButtonsPanel.add("West", this.JPanelLeft);
        this.JPanelCenter.setLayout(new FlowLayout(2, 5, 5));
        this.ButtonsPanel.add("Center", this.JPanelCenter);
        this.StepNumberLabel.setText("Step #1");
        this.JPanelCenter.add(this.StepNumberLabel);
        this.StepNumberLabel.setForeground(Color.black);
        this.CancelButton = WidgetFactory.makeJButton("Cancel", this.lSymAction, WizardSettings.NAV_BUTTON_DIMS);
        this.JPanelCenter.add(this.CancelButton);
        this.BackButton = WidgetFactory.makeJButton("< Back", this.lSymAction, WizardSettings.NAV_BUTTON_DIMS);
        this.BackButton.setEnabled(true);
        this.JPanelCenter.add(this.BackButton);
        this.NextButton = WidgetFactory.makeJButton("Next >", this.lSymAction, WizardSettings.NAV_BUTTON_DIMS);
        this.JPanelCenter.add(this.NextButton);
        this.FinishButton = WidgetFactory.makeJButton("Import", this.lSymAction, WizardSettings.NAV_BUTTON_DIMS);
        this.FinishButton.setEnabled(false);
        this.JPanelCenter.add(this.FinishButton);
    }

    private void registerListeners() {
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymListSelection lSymListSelection = new SymListSelection();
        this.StartingLineTextField.addActionListener(this.lSymAction);
        SymFocus aSymFocus = new SymFocus();
        this.StartingLineTextField.addFocusListener(aSymFocus);
        SymItem lSymItem = new SymItem();
        this.ColumnLabelsCheckBox.addItemListener(lSymItem);
        this.TabCheckBox.addItemListener(lSymItem);
        this.CommaCheckBox.addItemListener(lSymItem);
        this.SpaceCheckBox.addItemListener(lSymItem);
        this.SemicolonCheckBox.addItemListener(lSymItem);
        this.OtherCheckBox.addItemListener(lSymItem);
        this.ConsecutiveCheckBox.addItemListener(lSymItem);
    }

    private void setDistribution(short distribution) {
        if (distribution != 10 && distribution != 0 && distribution != 20 && distribution != 30) {
            throw new IllegalArgumentException("distribution must be WizardSettings.[ONLINE | INLINE | OFFLINE | NODATA]");
        }
        this.distribution = distribution;
    }

    void exitApplication() {
        this.setVisible(false);
        this.dispose();
    }

    void TextImportWizard_windowClosing(WindowEvent event) {
        try {
            this.CancelButton_actionPerformed(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetColumnHeader(String newColHeader) {
        int selectedCol = this.table.getSelectedColumn();
        if (selectedCol > -1 && this.colTitles.size() > 0) {
            this.colTitles.removeElementAt(selectedCol);
            this.colTitles.insertElementAt(newColHeader, selectedCol);
            this.buildTable();
            this.table.setColumnSelectionInterval(selectedCol, selectedCol);
        }
    }

    public static void main(String[] args) {
        File f = new File(args[0]);
        new TextImportWizardEml2(f, null, null);
    }

    void createLinesTable() {
        if (this.linesTable == null) {
            Vector listOfRows = new Vector();
            for (int i = 0; i < this.nlines; ++i) {
                Vector<String> row = new Vector<String>();
                new String();
                row.add(String.valueOf(i + 1));
                row.add(this.lines[i]);
                listOfRows.add(row);
            }
            Vector<String> title = new Vector<String>();
            title.add("#");
            title.add("Lines in " + this.dataFile.getName());
            UneditableTableModel linesTM = new UneditableTableModel(listOfRows, title);
            this.linesTable = new JTable(linesTM);
            this.linesTable.setFont(new Font("MonoSpaced", 0, 14));
            this.linesTable.getTableHeader().setReorderingAllowed(false);
            TableColumn column = null;
            column = this.linesTable.getColumnModel().getColumn(0);
            column.setPreferredWidth(40);
            column.setMaxWidth(40);
        }
        this.DataScrollPanel.getViewport().removeAll();
        this.DataScrollPanel.getViewport().add(this.linesTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parsefile(File f) {
        String temp = null;
        if (this.isTextFile(f)) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(f));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.nlines = 0;
            this.nlines_actual = 0;
            ArrayList<String> linesList = new ArrayList<String>();
            try {
                while ((temp = in.readLine()) != null) {
                    if (temp.length() <= 0) continue;
                    ++this.nlines_actual;
                    if (this.nlines >= this.nlines_max) continue;
                    ++this.nlines;
                    temp = temp + "\n";
                    linesList.add(temp);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (this.nlines_actual > this.nlines_max) {
                JOptionPane.showMessageDialog(this, "Data File parsing has been truncated due to large size! (Note: NO data has been lost!)", "Message", 1, null);
            }
            this.lines = linesList.toArray(new String[this.nlines]);
            this.guessDelimiter();
            return true;
        }
        JOptionPane.showMessageDialog(this, "Selected File is NOT a text file!", "Message", 1, null);
        this.CancelButton_actionPerformed(null);
        return false;
    }

    private void parseDelimited() {
        if (this.lines != null) {
            int start = this.startingLine;
            int numcols = 0;
            if (this.hasReturnedFromScreen2 && this.isScreen1Unchanged() && this.colTitles != null) {
                numcols = this.colTitles.size();
            } else {
                if (this.labelsInStartingLine) {
                    this.colTitles = this.getColumnValues(this.lines[this.startingLine - 1]);
                } else {
                    this.colTitles = this.getColumnValues(this.lines[this.startingLine - 1]);
                    int temp = this.colTitles.size();
                    this.colTitles = new Vector();
                    for (int l = 0; l < temp; ++l) {
                        this.colTitles.addElement("Column " + (l + 1));
                    }
                    --start;
                }
                this.vec = new Vector();
                numcols = this.colTitles.size();
                for (int i = start; i < this.nlines; ++i) {
                    Vector vec1 = this.getColumnValues(this.lines[i]);
                    boolean missing = false;
                    for (int currSize = vec1.size(); currSize < numcols; ++currSize) {
                        vec1.addElement("");
                        missing = true;
                    }
                    this.vec.addElement(vec1);
                }
                this.buildTable();
            }
            if (!this.hasReturnedFromScreen2) {
                this.columnAttributes = new Vector();
                this.needToSetPageData = new boolean[numcols];
                Arrays.fill(this.needToSetPageData, true);
            }
        }
        this.DataScrollPanel.getViewport().removeAll();
        this.DataScrollPanel.getViewport().add(this.table);
        this.hasReturnedFromScreen2 = false;
    }

    private void buildTable() {
        UneditableTableModel myTM = new UneditableTableModel(this.vec, this.colTitles);
        this.table = new JTable(myTM);
        this.table.setColumnSelectionAllowed(true);
        this.table.setRowSelectionAllowed(false);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(0);
        this.fullColumnModel = this.table.getColumnModel();
    }

    private Vector getColumnValues(String str) {
        String sDelim = this.getDelimiterString();
        String oldToken = "";
        String token = "";
        Vector<String> res = new Vector<String>();
        this.ignoreConsequtiveDelimiters = this.ConsecutiveCheckBox.isSelected();
        if (this.ignoreConsequtiveDelimiters) {
            StringTokenizer st = new StringTokenizer(str, sDelim, false);
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                res.addElement(token);
            }
        } else {
            StringTokenizer st = new StringTokenizer(str, sDelim, true);
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                if (!this.inDelimiterList(token, sDelim)) {
                    res.addElement(token);
                } else if (this.inDelimiterList(oldToken, sDelim)) {
                    res.addElement("");
                }
                oldToken = token;
            }
        }
        return res;
    }

    private String getDelimiterString() {
        String temp;
        String str = "";
        if (this.TabCheckBox.isSelected()) {
            str = str + "\t";
        }
        if (this.CommaCheckBox.isSelected()) {
            str = str + ",";
        }
        if (this.SpaceCheckBox.isSelected()) {
            str = str + " ";
        }
        if (this.SemicolonCheckBox.isSelected()) {
            str = str + ";";
        }
        if (this.OtherCheckBox.isSelected() && (temp = this.OtherTextField.getText()).length() > 0) {
            temp = temp.substring(0, 1);
            str = str + temp;
        }
        return str;
    }

    private String getDelimiterStringAsText() {
        String temp;
        String str = "";
        if (this.TabCheckBox.isSelected()) {
            str = str + "#x09";
        }
        if (this.CommaCheckBox.isSelected()) {
            str = str + ",";
        }
        if (this.SpaceCheckBox.isSelected()) {
            str = str + "#x20";
        }
        if (this.SemicolonCheckBox.isSelected()) {
            str = str + ";";
        }
        if (this.OtherCheckBox.isSelected() && (temp = this.OtherTextField.getText()).length() > 0) {
            temp = temp.substring(0, 1);
            str = str + temp;
        }
        return str;
    }

    private boolean inDelimiterList(String token, String delim) {
        boolean result = false;
        int test = delim.indexOf(token);
        if (test > -1) {
            result = true;
        }
        return result;
    }

    void NextButton_actionPerformed(ActionEvent event) {
        AttributePage attrd;
        if (this.stepNumber >= 3 && !(attrd = (AttributePage)this.columnAttributes.elementAt(this.stepNumber - 3)).onAdvanceAction()) {
            return;
        }
        ++this.stepNumber;
        if (this.fullColumnModel != null && this.stepNumber == this.fullColumnModel.getColumnCount() + 2) {
            this.FinishButton.setEnabled(true);
        }
        if (this.stepNumber < 3) {
            this.BackButton.setEnabled(true);
        }
        if (this.fullColumnModel != null) {
            this.StepNumberLabel.setText("Step #" + this.stepNumber + " of " + (this.fullColumnModel.getColumnCount() + 2));
        } else {
            this.StepNumberLabel.setText("Step #" + this.stepNumber);
        }
        CardLayout cl = (CardLayout)this.ControlsPanel.getLayout();
        cl.show(this.ControlsPanel, "card" + this.stepNumber);
        if (this.stepNumber == 2) {
            this.parseDelimited();
            this.table.setAutoResizeMode(0);
        }
        if (this.stepNumber >= 3) {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(this.fullColumnModel.getColumn(this.stepNumber - 3));
            DefaultListSelectionModel dlsm = new DefaultListSelectionModel();
            dlsm.setSelectionInterval(0, 0);
            model.setColumnSelectionAllowed(true);
            model.setSelectionModel(dlsm);
            this.table.setColumnModel(model);
            this.table.setAutoResizeMode(0);
            this.table.sizeColumnsToFit(-1);
            this.ColumnDataScrollPanel.getViewport().removeAll();
            this.ColumnDataScrollPanel.getViewport().add(this.table);
            this.ColumnDataScrollPanel.setVisible(true);
            this.DataPanel.setVisible(false);
            this.StepNumberLabel.setText("Step #" + this.stepNumber + " of " + (this.fullColumnModel.getColumnCount() + 2));
            int attrNum = this.stepNumber - 3;
            if (attrNum >= this.columnAttributes.size()) {
                AttributePage ad = (AttributePage)WizardPageLibrary.getPage("ATTRIBUTE_PAGE");
                ad.setBorder(BorderFactory.createLineBorder(Color.black));
                this.columnAttributes.add(ad);
            }
            if (this.needToSetPageData[attrNum]) {
                this.fillAttributePageData(attrNum);
                this.needToSetPageData[attrNum] = false;
            }
            AttributePage attrd2 = (AttributePage)this.columnAttributes.elementAt(attrNum);
            this.MainDisplayPanel.remove(this.MainDisplayPanel.getComponent(1));
            this.MainDisplayPanel.add((Component)attrd2, "Center");
            attrd2.refreshUI();
            this.MainDisplayPanel.validate();
            this.MainDisplayPanel.repaint();
            this.repaint();
        } else {
            this.ColumnDataPanel.setVisible(false);
        }
        if (this.stepNumber >= this.fullColumnModel.getColumnCount() + 2) {
            this.NextButton.setEnabled(false);
        } else {
            this.NextButton.setEnabled(true);
        }
    }

    private void fillAttributePageData(int attrNum) {
        AttributePage ad = (AttributePage)this.columnAttributes.elementAt(attrNum);
        String type = this.guessColFormat(attrNum);
        OrderedMap map = ad.getPageData("/eml:eml/dataset/dataTable/attributeList/attribute");
        map.put((Object)"/eml:eml/dataset/dataTable/attributeList/attribute/attributeName", this.colTitles.elementAt(attrNum));
        if (type.equals("text")) {
            Vector unique = this.getUniqueColValues(attrNum);
            Enumeration en = unique.elements();
            int pos = 1;
            while (en.hasMoreElements()) {
                String elem = (String)en.nextElement();
                String path = "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/nominal/nonNumericDomain/enumeratedDomain[1]/codeDefinition[" + pos + "]/code";
                map.put((Object)path, (Object)elem);
                path = "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/ordinal/nonNumericDomain/enumeratedDomain[1]/codeDefinition[" + pos + "]/code";
                map.put((Object)path, (Object)elem);
                ++pos;
            }
            ad.setPageData(map, null);
        } else if (type.equals("float")) {
            String numberTypePath = "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/interval/numericDomain/numberType";
            map.put((Object)numberTypePath, (Object)this.numberTypesArray[3]);
            numberTypePath = "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/ratio/numericDomain/numberType";
            map.put((Object)numberTypePath, (Object)this.numberTypesArray[3]);
            ad.setPageData(map, null);
        } else if (type.equals("integer")) {
            String numType = this.guessNumberType(attrNum);
            if (numType.equals("Natural")) {
                String numberTypePath = "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/interval/numericDomain/numberType";
                map.put((Object)numberTypePath, (Object)this.numberTypesArray[0]);
                numberTypePath = "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/ratio/numericDomain/numberType";
                map.put((Object)numberTypePath, (Object)this.numberTypesArray[0]);
            } else if (numType.equals("Whole")) {
                String numberTypePath = "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/interval/numericDomain/numberType";
                map.put((Object)numberTypePath, (Object)this.numberTypesArray[1]);
                numberTypePath = "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/ratio/numericDomain/numberType";
                map.put((Object)numberTypePath, (Object)this.numberTypesArray[1]);
            } else if (numType.equals("Integer")) {
                String numberTypePath = "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/interval/numericDomain/numberType";
                map.put((Object)numberTypePath, (Object)this.numberTypesArray[2]);
                numberTypePath = "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/ratio/numericDomain/numberType";
                map.put((Object)numberTypePath, (Object)this.numberTypesArray[2]);
            }
            ad.setPageData(map, null);
        } else if (type.equals("date")) {
            map.put((Object)"/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/datetime/dateTimePrecision", (Object)new String("0"));
            ad.setPageData(map, null);
        }
    }

    void BackButton_actionPerformed(ActionEvent event) {
        --this.stepNumber;
        if (this.stepNumber == 2) {
            this.ColumnDataScrollPanel.setVisible(false);
            this.table.setColumnModel(this.fullColumnModel);
            this.table.setColumnSelectionAllowed(true);
            this.table.setRowSelectionAllowed(false);
            this.table.setSelectionMode(0);
            this.table.setAutoResizeMode(0);
            this.DataScrollPanel.getViewport().removeAll();
            this.DataScrollPanel.getViewport().add(this.table);
            this.DataPanel.setVisible(true);
            this.MainDisplayPanel.remove(this.MainDisplayPanel.getComponent(1));
            this.MainDisplayPanel.add((Component)this.ControlsPlusDataPanel, "Center");
            this.MainDisplayPanel.validate();
            this.MainDisplayPanel.repaint();
        }
        if (this.stepNumber < 2) {
            this.table.setAutoResizeMode(0);
            this.saveScreen1Settings();
            this.hasReturnedFromScreen2 = true;
        }
        if (this.stepNumber >= 3) {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(this.fullColumnModel.getColumn(this.stepNumber - 3));
            DefaultListSelectionModel dlsm = new DefaultListSelectionModel();
            dlsm.setSelectionInterval(0, 0);
            model.setColumnSelectionAllowed(true);
            model.setSelectionModel(dlsm);
            this.table.setColumnModel(model);
            this.ColumnDataScrollPanel.getViewport().removeAll();
            this.ColumnDataScrollPanel.getViewport().add(this.table);
            this.ColumnDataScrollPanel.setVisible(true);
            this.DataPanel.setVisible(false);
            AttributePage attrd = (AttributePage)this.columnAttributes.elementAt(this.stepNumber - 3);
            this.MainDisplayPanel.remove(this.MainDisplayPanel.getComponent(1));
            this.MainDisplayPanel.add((Component)attrd, "Center");
            attrd.refreshUI();
            this.MainDisplayPanel.validate();
            this.MainDisplayPanel.repaint();
            this.repaint();
        } else {
            this.ColumnDataPanel.setVisible(false);
        }
        if (this.fullColumnModel != null && this.stepNumber < this.fullColumnModel.getColumnCount() + 2) {
            this.FinishButton.setEnabled(false);
        }
        if (this.stepNumber > 1) {
            this.NextButton.setEnabled(true);
        } else {
            this.BackButton.setEnabled(false);
        }
        this.StepNumberLabel.setText("Step #" + this.stepNumber + " of " + (this.fullColumnModel.getColumnCount() + 2));
        CardLayout cl = (CardLayout)this.ControlsPanel.getLayout();
        cl.show(this.ControlsPanel, "card" + this.stepNumber);
        if (this.stepNumber == 1 && this.lines != null) {
            this.createLinesTable();
        }
    }

    void FinishButton_actionPerformed(ActionEvent event) {
        AttributePage ad = (AttributePage)this.columnAttributes.elementAt(this.columnAttributes.size() - 1);
        if (!ad.onAdvanceAction()) {
            return;
        }
        Iterator it = this.columnAttributes.iterator();
        int index = 1;
        boolean importNeeded = false;
        String entityName = this.TableNameTextField.getText();
        ArrayList<String> colNames = new ArrayList<String>();
        this.columnMaps = new Vector();
        String prefix = "/eml:eml/dataset/dataTable/attributeList/attribute";
        int attrsToBeImported = 0;
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp == null) {
            Log.debug(10, "Error! Unable to obtain the ADP in TextImportWizard!");
        } else {
            attrsToBeImported = adp.getAttributeImportCount();
        }
        while (it.hasNext()) {
            ad = (AttributePage)it.next();
            OrderedMap map1 = ad.getPageData(prefix + "[" + index + "]");
            this.columnMaps.add(map1);
            String colName = this.getColumnName(map1, prefix + "[" + index + "]");
            if (adp != null && ad.isImportNeeded()) {
                String mScale = this.getMeasurementScale(map1, prefix + "[" + index + "]");
                adp.addAttributeForImport(entityName, colName, mScale, map1, prefix + "[" + index + "]", true);
                importNeeded = true;
            }
            ++index;
            colNames.add(colName);
        }
        if (adp != null) {
            adp.setLastImportedEntity(entityName);
            adp.setLastImportedAttributes(colNames);
            if (this.vec != null) {
                adp.setLastImportedDataSet(this.vec);
            } else {
                adp.setLastImportedDataSet(((UneditableTableModel)this.table.getModel()).getDataVector());
            }
        }
        String prevPageID = this.mainWizFrame.getPreviousPageID();
        if (attrsToBeImported > 0) {
            if (this.listener != null) {
                ((ImportWizard)this.listener).nextPageID = "CODE_DEFINITION";
            }
        } else if (importNeeded) {
            if (this.listener != null) {
                ((ImportWizard)this.listener).nextPageID = "CODE_IMPORT_SUMMARY";
            }
        } else if (this.listener != null) {
            ((ImportWizard)this.listener).nextPageID = "SUMMARY";
        }
        if (this.listener != null) {
            this.listener.importComplete(this.createEml2NVPairs());
        }
        this.dispose();
    }

    private String getColumnName(OrderedMap map, String xPath) {
        Object o1 = map.get((Object)(xPath + "/attributeName"));
        if (o1 == null) {
            return "";
        }
        return (String)o1;
    }

    private String getMeasurementScale(OrderedMap map, String xPath) {
        Object o1 = map.get((Object)(xPath + "/measurementScale/nominal/nonNumericDomain/enumeratedDomain[1]/codeDefinition[1]/code"));
        if (o1 != null) {
            return "Nominal";
        }
        boolean b1 = map.containsKey((Object)(xPath + "/measurementScale/nominal/nonNumericDomain/enumeratedDomain[1]/entityCodeList/entityReference"));
        if (b1) {
            return "Nominal";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/nominal/nonNumericDomain/textDomain[1]/definition"));
        if (o1 != null) {
            return "Nominal";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ordinal/nonNumericDomain/enumeratedDomain[1]/codeDefinition[1]/code"));
        if (o1 != null) {
            return "Ordinal";
        }
        b1 = map.containsKey((Object)(xPath + "/measurementScale/ordinal/nonNumericDomain/enumeratedDomain[1]/entityCodeList/entityReference"));
        if (b1) {
            return "Ordinal";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ordinal/nonNumericDomain/textDomain[1]/definition"));
        if (o1 != null) {
            return "Ordinal";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/interval/unit/standardUnit"));
        if (o1 != null) {
            return "Interval";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/interval/unit/customUnit"));
        if (o1 != null) {
            return "Interval";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ratio/unit/standardUnit"));
        if (o1 != null) {
            return "Ratio";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ratio/unit/customUnit"));
        if (o1 != null) {
            return "Ratio";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/datetime/formatString"));
        if (o1 != null) {
            return "Datetime";
        }
        return "";
    }

    private void saveScreen1Settings() {
        this.screen1Settings[0] = this.StartingLineTextField.getText();
        this.screen1Settings[1] = this.ColumnLabelsCheckBox.isSelected() ? "true" : "false";
    }

    private boolean isScreen1Unchanged() {
        this.labelsInStartLine_Status = this.ColumnLabelsCheckBox.isSelected() ? "true" : "false";
        return this.screen1Settings[0].equals(this.StartingLineTextField.getText()) && this.screen1Settings[1].equals(this.labelsInStartLine_Status);
    }

    private int charCount(String inS, String subS) {
        int cnt = -1;
        int pos = 0;
        int pos1 = 0;
        while (pos > -1) {
            pos = pos1 = inS.indexOf(subS, pos + 1);
            ++cnt;
        }
        if (cnt < 0) {
            cnt = 0;
        }
        return cnt;
    }

    private int mostFrequent(String subS) {
        int maxcnt = 500;
        int[] freq = new int[maxcnt];
        int mostfreq = 0;
        int mostfreqindex = 0;
        for (int i = 0; i < this.nlines; ++i) {
            int cnt = this.charCount(this.lines[i], subS);
            if (cnt > maxcnt - 1) {
                cnt = maxcnt - 1;
            }
            int n = cnt;
            freq[n] = freq[n] + 1;
            if (freq[cnt] <= mostfreq) continue;
            mostfreq = freq[cnt];
            mostfreqindex = cnt;
        }
        int tot = this.nlines;
        if (100 * mostfreq / tot < 80) {
            mostfreqindex = 0;
        }
        return mostfreqindex;
    }

    private String guessDelimiter() {
        this.parseOn = false;
        this.TabCheckBox.setSelected(false);
        this.CommaCheckBox.setSelected(false);
        this.SpaceCheckBox.setSelected(false);
        this.SemicolonCheckBox.setSelected(false);
        this.OtherCheckBox.setSelected(false);
        if (this.mostFrequent("\t") > 0) {
            this.TabCheckBox.setSelected(true);
            this.parseOn = true;
            return "tab";
        }
        if (this.mostFrequent(",") > 0) {
            this.CommaCheckBox.setSelected(true);
            this.parseOn = true;
            return "comma";
        }
        if (this.mostFrequent(" ") > 0) {
            this.SpaceCheckBox.setSelected(true);
            this.parseOn = true;
            return "space";
        }
        if (this.mostFrequent(";") > 0) {
            this.SemicolonCheckBox.setSelected(true);
            this.parseOn = true;
            return "semicolon";
        }
        if (this.mostFrequent(":") > 0) {
            this.SpaceCheckBox.setSelected(true);
            this.OtherCheckBox.setSelected(true);
            this.OtherTextField.setText(":");
            this.parseOn = true;
            return "colon";
        }
        this.SpaceCheckBox.setSelected(true);
        this.parseOn = true;
        return "unknown";
    }

    boolean isInteger(String s) {
        boolean res = true;
        try {
            int III = Integer.parseInt(s);
        }
        catch (Exception w) {
            res = false;
        }
        return res;
    }

    boolean isDouble(String s) {
        boolean res = true;
        try {
            Double III = Double.valueOf(s);
        }
        catch (Exception w) {
            res = false;
        }
        return res;
    }

    boolean isDate(String s) {
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        boolean res = true;
        try {
            Date dt = dateFormat.parse(s);
        }
        catch (Exception w) {
            try {
                dateFormat = DateFormat.getDateInstance(2);
                Date dt = dateFormat.parse(s);
            }
            catch (Exception w1) {
                try {
                    dateFormat = DateFormat.getDateInstance(1);
                    Date dt = dateFormat.parse(s);
                }
                catch (Exception w2) {
                    res = false;
                }
            }
        }
        return res;
    }

    String guessColFormat(int colNum) {
        boolean minInt = false;
        boolean maxInt = false;
        double minDouble = Double.POSITIVE_INFINITY;
        double maxDouble = Double.NEGATIVE_INFINITY;
        int emptyCount = 0;
        int dateCount = 0;
        int numericCount = 0;
        double numericAverage = 0.0;
        double numericSum = 0.0;
        boolean doublePresent = false;
        for (int i = 0; i < this.vec.size(); ++i) {
            Vector v = (Vector)this.vec.elementAt(i);
            String str = (String)v.elementAt(colNum);
            if (str.trim().length() < 1) {
                ++emptyCount;
                continue;
            }
            boolean isInt = this.isInteger(str);
            boolean isDbl = this.isDouble(str);
            if (isInt || isDbl) {
                ++numericCount;
                if (isDbl) {
                    doublePresent = true;
                }
                double d = Double.parseDouble(str);
                minDouble = Math.min(minDouble, d);
                maxDouble = Math.max(maxDouble, d);
                numericSum += d;
            }
            if (!this.isDate(str)) continue;
            ++dateCount;
        }
        numericAverage = numericSum / (double)numericCount;
        if (numericCount > 0 && 100 * (numericCount + emptyCount) / this.vec.size() > 90) {
            if (doublePresent) {
                return "float";
            }
            return "integer";
        }
        if (dateCount > 0 && 100 * (dateCount + emptyCount) / this.vec.size() > 90) {
            return "date";
        }
        return "text";
    }

    private String guessNumberType(int k) {
        Vector v = this.getUniqueColValues(k);
        Enumeration e = v.elements();
        boolean zero = false;
        boolean neg = false;
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            try {
                int num = Integer.parseInt(s);
                if (num == 0) {
                    zero = true;
                }
                if (num >= 0) continue;
                neg = true;
            }
            catch (Exception ex) {
                return "";
            }
        }
        if (neg) {
            return "Integer";
        }
        if (zero) {
            return "Whole";
        }
        return "Natural";
    }

    Vector getUniqueColValues(int colNum) {
        Vector<String> res = new Vector<String>();
        for (int i = 0; i < this.vec.size(); ++i) {
            Vector v = (Vector)this.vec.elementAt(i);
            String str = (String)v.elementAt(colNum);
            if (str.equals("") || res.contains(str)) continue;
            res.addElement(str);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTextFile(File file) {
        boolean text = true;
        int maxcnt = 2000;
        FileInputStream in = null;
        try {
            int res;
            in = new FileInputStream(file);
            for (int cnt = 0; (res = in.read()) > -1 && cnt < maxcnt; ++cnt) {
                if (res != 0) continue;
                text = false;
                break;
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return text;
    }

    void StartingLineTextField_actionPerformed(ActionEvent event) {
        String str = this.StartingLineTextField.getText();
        if (this.isInteger(str)) {
            this.startingLine = Integer.valueOf(str);
            if (this.startingLine < 1) {
                this.startingLine = 1;
                this.StartingLineTextField.setText("1");
            }
        } else {
            this.StartingLineTextField.setText(String.valueOf(this.startingLine));
        }
    }

    void StartingLineTextField_focusLost(FocusEvent event) {
        String str = this.StartingLineTextField.getText();
        if (this.isInteger(str)) {
            this.startingLine = Integer.valueOf(str);
            if (this.startingLine < 1) {
                this.startingLine = 1;
                this.StartingLineTextField.setText("1");
            }
        } else {
            this.StartingLineTextField.setText(String.valueOf(this.startingLine));
        }
    }

    void ColumnLabelsCheckBox_itemStateChanged(ItemEvent event) {
        this.labelsInStartingLine = this.ColumnLabelsCheckBox.isSelected();
    }

    void TabCheckBox_itemStateChanged(ItemEvent event) {
        if (this.parseOn) {
            this.parseDelimited();
        }
    }

    void CommaCheckBox_itemStateChanged(ItemEvent event) {
        if (this.parseOn) {
            this.parseDelimited();
        }
    }

    void SpaceCheckBox_itemStateChanged(ItemEvent event) {
        if (this.parseOn) {
            this.parseDelimited();
        }
    }

    void SemicolonCheckBox_itemStateChanged(ItemEvent event) {
        if (this.parseOn) {
            this.parseDelimited();
        }
    }

    void OtherCheckBox_itemStateChanged(ItemEvent event) {
        if (this.parseOn) {
            this.parseDelimited();
        }
    }

    void ConsecutiveCheckBox_itemStateChanged(ItemEvent event) {
        if (this.parseOn) {
            this.parseDelimited();
        }
    }

    public OrderedMap createEml2NVPairs() {
        String header = "/eml:eml/dataset/dataTable/";
        OrderedMap om = new OrderedMap();
        om.put((Object)(header + "entityName"), (Object)XMLUtil.normalize(this.TableNameTextField.getText()));
        om.put((Object)(header + "entityDescription"), (Object)XMLUtil.normalize(this.TableDescriptionTextField.getText()));
        String physicalID = WizardSettings.getUniqueID();
        om.put((Object)(header + "physical/@id"), (Object)physicalID);
        om.put((Object)(header + "physical/objectName"), (Object)this.shortFilename);
        long filesize = this.dataFile.length();
        String filesizeString = new Long(filesize).toString();
        om.put((Object)(header + "physical/size"), (Object)filesizeString);
        om.put((Object)(header + "physical/size/@unit"), (Object)"byte");
        int numHeaderLines = this.startingLine;
        if (!this.labelsInStartingLine) {
            --numHeaderLines;
        }
        om.put((Object)(header + "physical/dataFormat/textFormat/numHeaderLines"), (Object)("" + numHeaderLines));
        om.put((Object)(header + "physical/dataFormat/textFormat/recordDelimiter"), (Object)"#x0A");
        om.put((Object)(header + "physical/dataFormat/textFormat/attributeOrientation"), (Object)"column");
        String delimit = this.getDelimiterStringAsText();
        om.put((Object)(header + "physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter"), (Object)delimit);
        Enumeration e = this.columnMaps.elements();
        boolean index = true;
        while (e.hasMoreElements()) {
            OrderedMap map = (OrderedMap)e.nextElement();
            om.putAll((Map)map);
        }
        int temp = 0;
        if (this.labelsInStartingLine) {
            temp = 1;
        }
        int numrecs = this.nlines_actual - this.startingLine + 1 + temp;
        String numRecords = new Integer(numrecs).toString();
        om.put((Object)(header + "numberOfRecords"), (Object)XMLUtil.normalize(numRecords));
        if (this.ignoreConsequtiveDelimiters) {
            String addtHeader = "/eml:eml/additionalMetadata";
            om.put((Object)(addtHeader + "/describes"), (Object)physicalID);
            om.put((Object)(addtHeader + "/consecutiveDelimiters"), (Object)"true");
        }
        return om;
    }

    void CancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.dispose();
        if (this.listener != null) {
            this.listener.importCanceled();
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == TextImportWizardEml2.this.ColumnLabelsCheckBox) {
                TextImportWizardEml2.this.ColumnLabelsCheckBox_itemStateChanged(event);
            } else if (object == TextImportWizardEml2.this.TabCheckBox) {
                TextImportWizardEml2.this.TabCheckBox_itemStateChanged(event);
            } else if (object == TextImportWizardEml2.this.CommaCheckBox) {
                TextImportWizardEml2.this.CommaCheckBox_itemStateChanged(event);
            } else if (object == TextImportWizardEml2.this.SpaceCheckBox) {
                TextImportWizardEml2.this.SpaceCheckBox_itemStateChanged(event);
            } else if (object == TextImportWizardEml2.this.SemicolonCheckBox) {
                TextImportWizardEml2.this.SemicolonCheckBox_itemStateChanged(event);
            } else if (object == TextImportWizardEml2.this.OtherCheckBox) {
                TextImportWizardEml2.this.OtherCheckBox_itemStateChanged(event);
            } else if (object == TextImportWizardEml2.this.ConsecutiveCheckBox) {
                TextImportWizardEml2.this.ConsecutiveCheckBox_itemStateChanged(event);
            }
        }
    }

    class SymFocus
    extends FocusAdapter {
        SymFocus() {
        }

        public void focusLost(FocusEvent event) {
            Object object = event.getSource();
            if (object == TextImportWizardEml2.this.StartingLineTextField) {
                TextImportWizardEml2.this.StartingLineTextField_focusLost(event);
            }
        }
    }

    class SymListSelection
    implements ListSelectionListener {
        SymListSelection() {
        }

        public void valueChanged(ListSelectionEvent event) {
            Object object = event.getSource();
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == TextImportWizardEml2.this.NextButton) {
                TextImportWizardEml2.this.NextButton_actionPerformed(event);
            } else if (object == TextImportWizardEml2.this.BackButton) {
                TextImportWizardEml2.this.BackButton_actionPerformed(event);
            } else if (object == TextImportWizardEml2.this.FinishButton) {
                TextImportWizardEml2.this.FinishButton_actionPerformed(event);
            } else if (object == TextImportWizardEml2.this.CancelButton) {
                TextImportWizardEml2.this.CancelButton_actionPerformed(event);
            } else if (object == TextImportWizardEml2.this.StartingLineTextField) {
                TextImportWizardEml2.this.StartingLineTextField_actionPerformed(event);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == TextImportWizardEml2.this) {
                TextImportWizardEml2.this.TextImportWizard_windowClosing(event);
            }
        }
    }

    class UneditableTableModel
    extends DefaultTableModel {
        public UneditableTableModel(Vector data, Vector columnNames) {
            super(data, columnNames);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

