/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class CustomHeaderRenderer
extends DefaultTableCellRenderer {
    private String tableName = "";
    private String columnName = "";
    private JCheckBox cb;
    private boolean displayTableName;
    private boolean displayColumnName;
    private String extraHeaderInformation = "";
    private boolean displayExtraHeaderInfo = false;
    private Vector headerValues;

    CustomHeaderRenderer(Vector headerValues) {
        this.headerValues = headerValues;
        this.cb = new JCheckBox("");
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        JPanel cbPanel = new JPanel(new FlowLayout(1));
        cbPanel.add(this.cb);
        panel.add(cbPanel);
        for (String val : this.headerValues) {
            JPanel tPanel = new JPanel(new BorderLayout());
            tPanel.add((Component)new JLabel(val, 0), "Center");
            tPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, WizardSettings.TOP_PANEL_BG_COLOR));
            panel.add(tPanel);
        }
        JPanel ePanel = new JPanel(new BorderLayout());
        ePanel.add(new JLabel("( " + this.extraHeaderInformation + " )", 0));
        ePanel.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, WizardSettings.TOP_PANEL_BG_COLOR));
        ePanel.setVisible(this.displayExtraHeaderInfo);
        panel.add(ePanel);
        return panel;
    }

    public void setCheckboxSelected(boolean sel) {
        this.cb.setSelected(sel);
    }

    public boolean invertSelection() {
        this.cb.setSelected(!this.cb.isSelected());
        return this.cb.isSelected();
    }

    public boolean isSelected() {
        return this.cb.isSelected();
    }

    public void setExtraHeaderString(String t) {
        this.extraHeaderInformation = t;
    }

    public void showExtraHeaderInfo(boolean b) {
        this.displayExtraHeaderInfo = b;
    }

    public Vector getColumnHeader() {
        Vector v = null;
        if (this.displayExtraHeaderInfo) {
            v = (Vector)this.headerValues.clone();
            v.add(this.extraHeaderInformation);
        } else {
            v = this.headerValues;
        }
        return v;
    }

    public void setColumnHeader(Vector colHeader) {
        int size = colHeader.size();
        this.headerValues = colHeader;
    }

    public void setExtraColumnHeaderInfo(String info) {
        this.extraHeaderInformation = info;
        this.displayExtraHeaderInfo = true;
    }
}

