/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.editor;

import com.arbortext.catalog.Catalog;
import com.arbortext.catalog.CatalogEntityResolver;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.EML200DataPackage;
import edu.ucsb.nceas.morpho.editor.AttributeEditDialog;
import edu.ucsb.nceas.morpho.editor.DOMTree;
import edu.ucsb.nceas.morpho.editor.DTDTree;
import edu.ucsb.nceas.morpho.editor.EditorPlugin;
import edu.ucsb.nceas.morpho.editor.NodeInfo;
import edu.ucsb.nceas.morpho.editor.XMLDisplayHandler;
import edu.ucsb.nceas.morpho.editor.XMLPanels;
import edu.ucsb.nceas.morpho.editor.XMLTreeCellRenderer;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.plugins.XSLTResolverInterface;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.SAXValidate;
import edu.ucsb.nceas.morpho.util.XMLUtil;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DocFrame
extends JFrame {
    public DefaultTreeModel treeModel;
    public DefaultMutableTreeNode rootNode;
    public DTDTree dtdtree;
    public JTree tree;
    static DocFrame currentDocFrameInstance = null;
    static DefaultMutableTreeNode frootNode = null;
    static String templateRootName = "";
    public static final String NAMESPACE_FOR_SCHEMA_LOCATION = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String ATTRIB_NAME_FOR_SCHEMA_LOCATION = "schemaLocation";
    Node docnode = null;
    File openfile = null;
    File file = null;
    public static int counter = 0;
    public boolean removeExtraInfoFlag = true;
    public boolean xmlAttributesInTreeFlag = true;
    int exp_level = 5;
    DefaultMutableTreeNode fullTree = null;
    boolean trimFlag = true;
    ConfigXML config;
    EditorPlugin controller = null;
    String XMLTextString;
    String doctype = null;
    String schemaId = null;
    String rootnodeName = null;
    String publicIDString = null;
    String systemIDString = null;
    DefaultMutableTreeNode selectedNode;
    StringBuffer sb;
    StringBuffer start;
    Stack tempStack;
    boolean textnode = false;
    Catalog myCatalog;
    String dtdfile;
    int numlevels = 20;
    boolean templateFlag = false;
    JSplitPane DocControlPanel;
    boolean treeValueFlag = true;
    boolean mergeMissingFlag = false;
    boolean emptyFlag = false;
    static DefaultMutableTreeNode nodeCopy = null;
    boolean trimNodesNotInDTDflag = true;
    boolean dtdMergeflag = false;
    String id = null;
    String location = null;
    boolean treeSelChangedFlag = false;
    JMenuItem menuItem;
    JMenuItem CardmenuItem;
    JMenuItem DeletemenuItem;
    JMenuItem DupmenuItem;
    JMenuItem AttrmenuItem;
    JMenuItem CopymenuItem;
    JMenuItem ReplacemenuItem;
    JMenuItem PastemenuItem;
    JMenuItem AddtextItem;
    JPanel OutputScrollPanelContainer = new JPanel();
    JScrollPane OutputScrollPanel = new JScrollPane();
    JPanel ControlsPanel = new JPanel();
    JPanel TreeChoicePanel = new JPanel();
    JPanel TreeControlPanel = new JPanel();
    JButton TrimTreeButton = new JButton();
    JButton UntrimTreeButton = new JButton();
    JButton ExpandTreeButton = new JButton();
    JButton ContractTreeButton = new JButton();
    JScrollPane NestedPanelScrollPanel = new JScrollPane();
    JPanel TopPanel = new JPanel();
    JPanel TopLabelPanel = new JPanel();
    JLabel headLabel = new JLabel();
    JLabel logoLabel = new JLabel();
    JPanel ControlPanel = new JPanel();
    JPanel ButtonPanel = new JPanel();
    JButton CancelButton = new JButton();
    JButton OpenButton = new JButton();
    JButton NewButton = new JButton();
    JButton EditingExit = new JButton();
    JPanel NotesPanel = new JPanel();
    JLabel JLabel1 = new JLabel();
    JLabel JLabel2 = new JLabel();
    JLabel JLabel3 = new JLabel();
    JLabel JLabel4 = new JLabel();
    JComboBox choiceCombo = new JComboBox();
    JPopupMenu popup = new JPopupMenu();
    static Hashtable icons = new Hashtable();
    private Morpho morpho = null;
    private static XSLTResolverInterface resolver;
    private boolean removeReferencesFlag = true;
    private int findNodeCount = 0;
    private String lastFoundString = "";
    private Hashtable duplicatePathHash = new Hashtable();
    private static final int BUTTONSIZE = 26;
    private static final int BUTTONLENGTH = 71;
    private String previousEvent = "";

    public DocFrame() {
        currentDocFrameInstance = this;
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(800, 600);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension ddd = tk.getScreenSize();
        if (ddd.width > 800) {
            int dh = 8 * ddd.height / 10;
            int dw = 8 * ddd.width / 10;
            this.setSize(dw, dh);
        }
        this.setVisible(false);
        final DocFrame df = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                Log.debug(50, "Processing window activated event");
                currentDocFrameInstance = df;
            }

            public void windowClosing(WindowEvent event) {
            }

            public void windowDeactivated(WindowEvent event) {
            }
        });
        this.ControlsPanel.setLayout(new BorderLayout(0, 0));
        this.OutputScrollPanelContainer.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add(this.OutputScrollPanelContainer);
        JLabel test = new JLabel("Find: ");
        String[] choices = new String[]{"eml", "dataset", "access", "creator", "contact", "keywordSet", "dataTable", "attributeList", "abstract", "geographicCoverage", "temporalCoverage", "taxonomicCoverage", "methods", "project", "entityName", "physical", "spatialRaster", "spatialVector"};
        Vector configuredChoices = Morpho.getConfiguration().get("editorChoice");
        if (configuredChoices != null && configuredChoices.size() > 0) {
            choices = configuredChoices.toArray(new String[0]);
        }
        this.choiceCombo = new JComboBox<String>(choices);
        this.choiceCombo.setVisible(false);
        this.choiceCombo.setEditable(true);
        this.TreeChoicePanel.add(test);
        this.TreeChoicePanel.add(this.choiceCombo);
        this.choiceCombo.setVisible(true);
        this.TreeControlPanel.setLayout(new FlowLayout(0, 1, 1));
        this.ControlsPanel.add("North", this.TreeControlPanel);
        this.ControlsPanel.add("South", this.TreeChoicePanel);
        this.OutputScrollPanelContainer.add("North", this.ControlsPanel);
        this.OutputScrollPanelContainer.add("Center", this.OutputScrollPanel);
        this.TrimTreeButton.setText("Trim");
        this.TrimTreeButton.setPreferredSize(new Dimension(71, 26));
        this.TrimTreeButton.setActionCommand("Trim");
        this.TrimTreeButton.setToolTipText("Remove all optional nodes that contain no text.");
        this.TrimTreeButton.setEnabled(false);
        this.UntrimTreeButton.setText("Show All");
        this.UntrimTreeButton.setPreferredSize(new Dimension(71, 26));
        this.UntrimTreeButton.setActionCommand("Show All");
        this.UntrimTreeButton.setToolTipText("Show all possible elements.");
        this.UntrimTreeButton.setEnabled(true);
        this.TreeControlPanel.add(this.UntrimTreeButton);
        this.TreeControlPanel.add(this.TrimTreeButton);
        this.ExpandTreeButton.setText("+");
        this.ExpandTreeButton.setPreferredSize(new Dimension(26, 26));
        this.ExpandTreeButton.setActionCommand("+");
        this.ExpandTreeButton.setToolTipText("Expand Tree levels displayed");
        this.TreeControlPanel.add(this.ExpandTreeButton);
        this.ContractTreeButton.setText("-");
        this.ContractTreeButton.setPreferredSize(new Dimension(26, 26));
        this.ContractTreeButton.setActionCommand("-");
        this.ContractTreeButton.setToolTipText("Contract Tree levels displayed");
        this.TreeControlPanel.add(this.ContractTreeButton);
        this.getContentPane().add("Center", this.NestedPanelScrollPanel);
        this.TopPanel.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("North", this.TopPanel);
        this.TopLabelPanel.setLayout(new FlowLayout(1, 5, 5));
        this.TopPanel.add("Center", this.TopLabelPanel);
        this.headLabel.setText("Working...");
        this.TopLabelPanel.add(this.headLabel);
        this.TopPanel.add("East", this.logoLabel);
        this.ControlPanel.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("South", this.ControlPanel);
        this.ButtonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.ControlPanel.add("East", this.ButtonPanel);
        this.NewButton.setText("New EML2");
        this.NewButton.setActionCommand("Open");
        this.NewButton.setVisible(false);
        this.ButtonPanel.add(this.NewButton);
        this.OpenButton.setText("Open");
        this.OpenButton.setActionCommand("Open");
        this.OpenButton.setVisible(false);
        this.ButtonPanel.add(this.OpenButton);
        this.EditingExit.setText("OK");
        this.EditingExit.setActionCommand("OK");
        this.ButtonPanel.add(this.EditingExit);
        this.CancelButton.setText("Cancel");
        this.CancelButton.setActionCommand("Cancel");
        this.ButtonPanel.add(this.CancelButton);
        this.NotesPanel.setLayout(new GridLayout(2, 2, 6, 0));
        this.ControlPanel.add("West", this.NotesPanel);
        this.JLabel1.setText("required; repeatable (ONE to MANY)");
        this.NotesPanel.add(this.JLabel1);
        this.JLabel1.setBackground(Color.black);
        this.JLabel1.setForeground(Color.black);
        this.JLabel1.setFont(new Font("Dialog", 0, 10));
        this.JLabel2.setText("required (ONE)");
        this.NotesPanel.add(this.JLabel2);
        this.JLabel2.setBackground(Color.black);
        this.JLabel2.setForeground(Color.black);
        this.JLabel2.setFont(new Font("Dialog", 0, 10));
        this.JLabel3.setText("optional; repeatable (ZERO to MANY)");
        this.NotesPanel.add(this.JLabel3);
        this.JLabel3.setBackground(Color.black);
        this.JLabel3.setForeground(Color.black);
        this.JLabel3.setFont(new Font("Dialog", 0, 10));
        this.JLabel4.setText("optional (ZERO to ONE)");
        this.NotesPanel.add(this.JLabel4);
        this.JLabel4.setBackground(Color.black);
        this.JLabel4.setForeground(Color.black);
        this.JLabel4.setFont(new Font("Dialog", 0, 10));
        if (!icons.containsKey("blue.gif")) {
            ImageIcon plus = new ImageIcon(this.getClass().getResource("blue.gif"));
            icons.put("blue.gif", plus);
        }
        this.JLabel1.setIcon((ImageIcon)icons.get("blue.gif"));
        if (!icons.containsKey("red.gif")) {
            ImageIcon square = new ImageIcon(this.getClass().getResource("red.gif"));
            icons.put("red.gif", square);
        }
        this.JLabel2.setIcon((ImageIcon)icons.get("red.gif"));
        if (!icons.containsKey("green.gif")) {
            ImageIcon astr = new ImageIcon(this.getClass().getResource("green.gif"));
            icons.put("green.gif", astr);
        }
        this.JLabel3.setIcon((ImageIcon)icons.get("green.gif"));
        if (!icons.containsKey("yellow.gif")) {
            ImageIcon qu = new ImageIcon(this.getClass().getResource("yellow.gif"));
            icons.put("yellow.gif", qu);
        }
        this.JLabel4.setIcon((ImageIcon)icons.get("yellow.gif"));
        if (!icons.containsKey("smallheader-bg.gif")) {
            ImageIcon head = new ImageIcon(this.getClass().getResource("smallheader-bg.gif"));
            icons.put("smallheader-bg.gif", head);
        }
        if (!icons.containsKey("logo-icon.gif")) {
            ImageIcon logoIcon = new ImageIcon(this.getClass().getResource("logo-icon.gif"));
            icons.put("logo-icon.gif", logoIcon);
        }
        if (!icons.containsKey("Btfly4.gif")) {
            ImageIcon flapping = new ImageIcon(this.getClass().getResource("Btfly4.gif"));
            icons.put("Btfly4.gif", flapping);
        }
        this.logoLabel.setIcon((ImageIcon)icons.get("Btfly4.gif"));
        this.headLabel.setIcon((ImageIcon)icons.get("smallheader-bg.gif"));
        this.headLabel.setHorizontalTextPosition(0);
        this.headLabel.setHorizontalAlignment(2);
        this.headLabel.setAlignmentY(0.0f);
        this.headLabel.setAlignmentX(0.0f);
        this.headLabel.setForeground(Color.black);
        this.headLabel.setFont(new Font("Dialog", 1, 14));
        this.headLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.DocControlPanel = new JSplitPane(1, this.OutputScrollPanelContainer, this.NestedPanelScrollPanel);
        this.DocControlPanel.setOneTouchExpandable(true);
        this.DocControlPanel.setDividerLocation(225);
        this.getContentPane().add("Center", this.DocControlPanel);
        this.CardmenuItem = new JMenuItem("One Element Allowed");
        this.popup.add(this.CardmenuItem);
        this.popup.add(new JSeparator());
        this.DupmenuItem = new JMenuItem("Duplicate");
        this.popup.add(this.DupmenuItem);
        this.DeletemenuItem = new JMenuItem("Delete");
        this.popup.add(this.DeletemenuItem);
        this.popup.add(new JSeparator());
        this.AttrmenuItem = new JMenuItem("Edit Attributes");
        this.popup.add(new JSeparator());
        this.AddtextItem = new JMenuItem("Add Text");
        this.AddtextItem.setEnabled(false);
        this.popup.add(this.AddtextItem);
        this.popup.add(new JSeparator());
        this.CopymenuItem = new JMenuItem("Copy Node & Children");
        this.popup.add(this.CopymenuItem);
        this.ReplacemenuItem = new JMenuItem("Replace Selected Node from Clipboard");
        this.ReplacemenuItem.setEnabled(false);
        this.popup.add(this.ReplacemenuItem);
        this.PastemenuItem = new JMenuItem("Paste as Sibling to Selected Node");
        this.popup.add(this.PastemenuItem);
        SymAction lSymAction = new SymAction();
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.choiceCombo.addActionListener(lSymAction);
        this.EditingExit.addActionListener(lSymAction);
        this.CancelButton.addActionListener(lSymAction);
        this.OpenButton.addActionListener(lSymAction);
        this.NewButton.addActionListener(lSymAction);
        this.TrimTreeButton.addActionListener(lSymAction);
        this.UntrimTreeButton.addActionListener(lSymAction);
        this.ExpandTreeButton.addActionListener(lSymAction);
        this.ContractTreeButton.addActionListener(lSymAction);
        SymComponent aSymComponent = new SymComponent();
        this.addComponentListener(aSymComponent);
        this.DeletemenuItem.addActionListener(lSymAction);
        this.DupmenuItem.addActionListener(lSymAction);
        this.AttrmenuItem.addActionListener(lSymAction);
        this.CopymenuItem.addActionListener(lSymAction);
        this.ReplacemenuItem.addActionListener(lSymAction);
        this.PastemenuItem.addActionListener(lSymAction);
        this.AddtextItem.addActionListener(lSymAction);
        JPopupMenu popup = new JPopupMenu();
        this.rootNode = this.newNode("Morpho Editor");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.OutputScrollPanel.getViewport().add(this.tree);
        this.tree.setCellRenderer(new XMLTreeCellRenderer());
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        SymTreeSelection lSymTreeSelection = new SymTreeSelection();
        this.tree.addTreeSelectionListener(lSymTreeSelection);
        PopupListener popupListener = new PopupListener();
        this.tree.addMouseListener(popupListener);
        this.validate();
        this.setLocation(50, 50);
        this.setVisible(true);
        Graphics g = this.getGraphics();
        this.paint(g);
        g.dispose();
    }

    public DocFrame(String sTitle) {
        this();
        this.setTitle(sTitle);
    }

    public DocFrame(String sTitle, String doctext) {
        this();
        this.setTitle(sTitle);
    }

    public DocFrame(File file) {
        this();
        this.file = file;
        try {
            int c;
            BufferedReader in = new BufferedReader(new FileReader(file));
            StringWriter out = new StringWriter();
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.flush();
            out.close();
            System.out.println("Finished reading input file!");
            String fileString = out.toString();
            this.initDoc(null, fileString);
        }
        catch (Exception e) {
            System.out.println("Problem reading input file!");
        }
    }

    public DocFrame(Morpho morpho, String sTitle, String doctext, boolean flag) {
        this();
        this.setTitle(sTitle);
        this.XMLTextString = doctext;
        this.templateFlag = flag;
    }

    public DocFrame(Morpho morpho, String sTitle, String doctext, String id, String location) {
        this(morpho, sTitle, doctext, false);
        if (id != null) {
            this.setTitle("Morpho Editor");
            this.setName("Morpho Editor" + counter + ":" + id);
        }
        this.id = id;
        this.location = location;
    }

    public DocFrame(Morpho morpho, String sTitle, String doctext, String id, String location, boolean templFlag) {
        this(morpho, sTitle, doctext, templFlag);
        if (id != null) {
            this.setTitle("Morpho Editor");
            this.setName("Morpho Editor" + counter + ":" + id);
        }
        this.id = id;
        this.location = location;
    }

    public DocFrame(Morpho morpho, String sTitle, String doctext, String id, String location, String nodeName, String nodeValue) {
        this(morpho, sTitle, doctext, id, location);
        if (nodeValue != null) {
            this.selectMatchingNode(this.rootNode, nodeName, nodeValue);
        } else {
            this.selectMatchingNode(this.rootNode, nodeName);
        }
    }

    public void setFile(File f) {
        this.file = f;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public void setVisible(boolean b) {
        if (b) {
            super.setVisible(b);
        }
    }

    public void setTreeValueFlag(boolean flg) {
        this.treeValueFlag = flg;
    }

    public void setController(EditorPlugin con) {
        this.controller = con;
    }

    public String getIdString() {
        return this.id;
    }

    public String getLocationString() {
        return this.location;
    }

    public void initDoc(Morpho finalMorpho, String doctext) {
        final Morpho fMorpho = finalMorpho;
        final String fdoctext = doctext;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                DocFrame.this.initDocInner(fMorpho, fdoctext);
                return null;
            }

            public void finished() {
                DocFrame.this.setLeafNodes((DefaultMutableTreeNode)DocFrame.this.treeModel.getRoot());
                DocFrame.this.setAttributeNames(DocFrame.this.rootNode);
                DocFrame.this.setChoiceNodes(DocFrame.this.rootNode);
                if (DocFrame.this.xmlAttributesInTreeFlag) {
                    DocFrame.this.addXMLAttributeNodes(DocFrame.this.rootNode);
                }
                DocFrame.this.treeModel.reload();
                DocFrame.this.tree.setModel(DocFrame.this.treeModel);
                DocFrame.this.tree.expandRow(1);
                DocFrame.this.tree.expandRow(5);
                DocFrame.this.tree.setSelectionRow(0);
                DocFrame.this.setTitle("Morpho Editor:" + DocFrame.this.id);
                DocFrame.this.headLabel.setText("Morpho Editor");
                DocFrame.this.logoLabel.setIcon((ImageIcon)icons.get("logo-icon.gif"));
                DocFrame.this.headLabel.setText("Morpho Editor");
            }
        };
        worker.start();
    }

    void initDocInner(Morpho morpho, String doctext) {
        DefaultMutableTreeNode frootNode = null;
        this.morpho = morpho;
        this.setName("Morpho Editor" + ++counter);
        this.XMLTextString = doctext;
        this.rootNode = this.newNode("Morpho Editor");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.putXMLintoTree(this.treeModel, this.XMLTextString);
        NodeInfo ni = (NodeInfo)((DefaultMutableTreeNode)this.treeModel.getRoot()).getUserObject();
        if (this.templateFlag) {
            this.templateFlag = false;
            this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
            this.setAttributeNames(this.rootNode);
            this.setChoiceNodes(this.rootNode);
            this.setAllNodesAsSelected(this.rootNode);
            this.setSelectedNodes(this.rootNode);
            return;
        }
        this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        this.setAllNodesAsSelected(this.rootNode);
        String rootname = ((NodeInfo)this.rootNode.getUserObject()).getName();
        String location = null;
        if (this.schemaId != null) {
            location = this.getXMLLocation(this.schemaId);
        }
        rootname = location != null ? location : rootname + ".xml";
        frootNode = new DefaultMutableTreeNode("froot");
        DefaultTreeModel ftreeModel = new DefaultTreeModel(frootNode);
        String fXMLString = "";
        boolean formatflag = true;
        try {
            int c;
            ClassLoader cl = this.getClass().getClassLoader();
            BufferedReader in = new BufferedReader(new FileReader("./lib/" + rootname));
            StringWriter out = new StringWriter();
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.flush();
            out.close();
            fXMLString = out.toString();
        }
        catch (Exception e) {
            formatflag = false;
        }
        if (formatflag) {
            this.putXMLintoTree(ftreeModel, fXMLString);
            frootNode = (DefaultMutableTreeNode)ftreeModel.getRoot();
            this.removeAllReferences(frootNode);
            this.removeNodesVisLevel(frootNode, 0);
            this.treeUnion(this.rootNode, frootNode);
        }
        if (this.dtdMergeflag && this.dtdfile != null) {
            this.dtdtree = new DTDTree(this.dtdfile);
            this.dtdtree.setRootElementName(this.rootnodeName);
            this.dtdtree.parseDTD();
            this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
            if (!this.templateFlag) {
                this.treeUnion(this.rootNode, this.dtdtree.rootNode);
                if (this.trimNodesNotInDTDflag) {
                    this.treeTrim(this.rootNode, this.dtdtree.rootNode);
                }
            }
        }
        this.setAttributeNames(this.rootNode);
        this.setChoiceNodes(this.rootNode);
        Enumeration<TreeNode> enumeration = this.rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeInfo nif = (NodeInfo)node.getUserObject();
            nif.setSelected(false);
        }
        this.setSelectedNodes(this.rootNode);
    }

    public void initDoc(Morpho morpho, Node docnode, String id, String loc, String schemaId) {
        this.id = id;
        this.location = loc;
        this.docnode = docnode;
        this.schemaId = schemaId;
        this.setName("Morpho Editor");
        this.treeModel = this.putDOMintoTree(docnode);
        this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        this.setAllNodesAsSelected(this.rootNode);
        if (this.templateFlag) {
            this.templateFlag = false;
            this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
            this.setAttributeNames(this.rootNode);
            this.setChoiceNodes(this.rootNode);
            this.setAllNodesAsSelected(this.rootNode);
            this.setSelectedNodes(this.rootNode);
            if (this.xmlAttributesInTreeFlag) {
                this.addXMLAttributeNodes(this.rootNode);
            }
            this.treeModel.reload();
            this.tree.setModel(this.treeModel);
            this.tree.expandRow(1);
            this.tree.expandRow(5);
            this.tree.setSelectionRow(0);
            return;
        }
        boolean formatflag = true;
        this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        String rname = ((NodeInfo)this.rootNode.getUserObject()).getName();
        if (frootNode == null || !rname.equals(templateRootName)) {
            String rootname;
            this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
            templateRootName = rootname = ((NodeInfo)this.rootNode.getUserObject()).getName();
            String location = null;
            if (schemaId != null) {
                location = this.getXMLLocation(schemaId);
            }
            rootname = location != null ? location : rootname + ".xml";
            frootNode = new DefaultMutableTreeNode("froot");
            String fXMLString = "";
            try {
                int c;
                ClassLoader cl = this.getClass().getClassLoader();
                BufferedReader in = new BufferedReader(new FileReader("./lib/" + rootname));
                StringWriter out = new StringWriter();
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                in.close();
                out.flush();
                out.close();
                fXMLString = out.toString();
                DefaultTreeModel ftreeModel = new DefaultTreeModel(frootNode);
                this.putXMLintoTree(ftreeModel, fXMLString);
                frootNode = (DefaultMutableTreeNode)ftreeModel.getRoot();
                this.removeNodesVisLevel(frootNode, 0);
                this.removeAllReferences(frootNode);
            }
            catch (Exception e) {
                formatflag = false;
                frootNode = null;
            }
        }
        if (formatflag) {
            this.treeUnion(this.rootNode, frootNode);
            this.setAttributeNames(this.rootNode);
            this.setChoiceNodes(this.rootNode);
            this.setSelectedNodes(this.rootNode);
            this.setLeafNodes(this.rootNode);
            if (this.xmlAttributesInTreeFlag) {
                this.addXMLAttributeNodes(this.rootNode);
            }
        }
        this.treeValueFlag = false;
        this.treeModel.reload();
        this.tree.setModel(this.treeModel);
        this.tree.expandRow(4);
        this.treeValueFlag = false;
        this.tree.setSelectionRow(0);
        this.headLabel.setText("Morpho Editor");
        this.logoLabel.setIcon((ImageIcon)icons.get("logo-icon.gif"));
    }

    public void initDoc(Morpho morpho, Document doc, String id, String loc, String initNodeName, int initNodeNumber) {
        Element docnode = doc.getDocumentElement();
        String identifier = null;
        if (doc.getDoctype() != null) {
            identifier = doc.getDoctype().getPublicId();
            Log.debug(50, "getPublicId() gives: " + identifier);
        }
        if ((identifier == null || identifier.trim().equals("")) && (identifier = docnode.getAttributeNS(NAMESPACE_FOR_SCHEMA_LOCATION, ATTRIB_NAME_FOR_SCHEMA_LOCATION)) != null && !identifier.trim().equals("")) {
            identifier = identifier.trim().substring(0, identifier.indexOf(" "));
            Log.debug(50, "getAttributeNS schemaLocation is: " + identifier);
        }
        if (identifier == null || identifier.trim().equals("")) {
            identifier = docnode.getNamespaceURI();
            Log.debug(50, "rootNode.getNamespaceURI() gives: " + identifier);
        }
        this.initDoc(morpho, docnode, id, loc, identifier);
        this.findNode(this.rootNode, initNodeName, initNodeNumber);
    }

    public void setTopOfTree(Node rootNode, String path) {
        Node nd = null;
        DOMTree.Model model = (DOMTree.Model)this.treeModel;
        try {
            nd = XMLUtilities.getNodeWithXPath((Node)rootNode, (String)path);
        }
        catch (Exception w) {
            Log.debug(1, "Exception evaluation path");
        }
        if (nd != null) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)model.getInvNode(nd);
            this.treeModel.setRoot(tn);
            this.treeModel.reload();
            this.tree.setModel(this.treeModel);
            this.tree.expandRow(1);
            this.tree.setSelectionRow(0);
        }
    }

    public void setTopOfTree(DefaultMutableTreeNode rootTreeNode, String name) {
        DefaultMutableTreeNode nd = null;
        DefaultMutableTreeNode tn = null;
        Enumeration<TreeNode> enumeration = rootTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            nd = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeInfo ni = (NodeInfo)nd.getUserObject();
            String nodeName = ni.getName().trim();
            if (!nodeName.equals(name)) continue;
            tn = nd;
            break;
        }
        if (tn != null) {
            this.treeModel.setRoot(tn);
            this.treeModel.reload();
            this.tree.setModel(this.treeModel);
            this.tree.expandRow(1);
            this.tree.setSelectionRow(0);
        }
    }

    protected void findNode(DefaultMutableTreeNode treeNode, String name, int n) {
        if (name == null) {
            name = "dataset";
        }
        DefaultMutableTreeNode startNode = treeNode;
        String newName = name;
        int k = name.indexOf("/");
        int j = 0;
        String numstart = "";
        if (k > -1) {
            String start = name.substring(0, k);
            String remainder = name.substring(k + 1, name.length());
            int kk = start.indexOf("[");
            if (kk > -1) {
                int kkk = start.indexOf("]");
                numstart = start.substring(kk + 1, kkk);
                start = start.substring(0, kk);
                try {
                    j = new Integer(numstart);
                }
                catch (Exception w) {
                    // empty catch block
                }
            }
            int cnt2 = -1;
            Enumeration<TreeNode> enum2 = startNode.preorderEnumeration();
            while (enum2.hasMoreElements()) {
                DefaultMutableTreeNode nd = (DefaultMutableTreeNode)enum2.nextElement();
                NodeInfo ni = (NodeInfo)nd.getUserObject();
                String nodeName = ni.getName().trim();
                if (nodeName.indexOf(start) <= -1 || ++cnt2 != j) continue;
                startNode = nd;
                newName = remainder;
            }
        }
        int cnt = -1;
        Enumeration<TreeNode> enumeration = startNode.preorderEnumeration();
        boolean foundNode = false;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode nd = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeInfo ni = (NodeInfo)nd.getUserObject();
            String nodeName = ni.getName().trim();
            if (nodeName.indexOf(newName) <= -1) continue;
            foundNode = true;
            if (++cnt != n) continue;
            Object[] path = nd.getPath();
            TreePath tp = new TreePath(path);
            this.tree.scrollPathToVisible(tp);
            this.tree.makeVisible(tp);
            this.tree.setSelectionPath(tp);
            return;
        }
        if (foundNode) {
            this.findNode(treeNode, name, 0);
        } else {
            String msg = "Sorry, could not locate a node containing '" + name + "'";
            JOptionPane.showMessageDialog(this, msg, "alert", 1);
        }
        this.findNodeCount = 0;
    }

    DefaultMutableTreeNode newNode(Object name) {
        NodeInfo ni = new NodeInfo(name.toString());
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(ni);
        return node;
    }

    DefaultMutableTreeNode deepNodeCopy(DefaultMutableTreeNode node) {
        if (node == null) {
            Log.debug(20, "Attempt to clone a null node!");
            return null;
        }
        DefaultMutableTreeNode newnode = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream s = new ObjectOutputStream(out);
            s.writeObject(node);
            s.flush();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            ObjectInputStream os = new ObjectInputStream(in);
            newnode = (DefaultMutableTreeNode)os.readObject();
        }
        catch (Exception e) {
            Log.debug(20, "Exception in creating copy of node!");
        }
        return newnode;
    }

    void deepNodeCopyFile(DefaultMutableTreeNode node) {
        if (node == null) {
            Log.debug(20, "Attempt to clone a null node!");
        }
        Object newnode = null;
        try {
            File fl = new File("treeNodeFile.ser");
            FileOutputStream out = new FileOutputStream(fl);
            ObjectOutputStream s = new ObjectOutputStream(out);
            s.writeObject(node);
            s.flush();
        }
        catch (Exception e) {
            Log.debug(20, "Exception in creating copy of node!");
        }
    }

    DefaultMutableTreeNode readDeepNodeCopyFile(String filename) {
        DefaultMutableTreeNode node = null;
        try {
            FileInputStream in = new FileInputStream(filename);
            ObjectInputStream os = new ObjectInputStream(in);
            node = (DefaultMutableTreeNode)os.readObject();
        }
        catch (Exception e) {
            return null;
        }
        return node;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        DocFrame df = new DocFrame();
        df.setVisible(true);
        Node domnode = null;
        try {
            domnode = XMLUtilities.getXMLAsDOMTreeRootNode((String)"/test.xml");
        }
        catch (Exception e) {
            Log.debug(4, "Problem in creating DOM!" + e);
        }
        df.initDoc(null, domnode, null, null, null);
    }

    void setLeafNodes(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parentNode = null;
        DefaultMutableTreeNode curNode = node.getFirstLeaf();
        Vector<DefaultMutableTreeNode> leafs = new Vector<DefaultMutableTreeNode>();
        leafs.addElement(curNode);
        while (curNode != null) {
            if ((curNode = curNode.getNextLeaf()) == null) continue;
            leafs.addElement(curNode);
        }
        Enumeration enumeration = leafs.elements();
        while (enumeration.hasMoreElements()) {
            parentNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (((NodeInfo)parentNode.getUserObject()).getName().equals("#PCDATA")) continue;
            NodeInfo ni = new NodeInfo("#PCDATA");
            ni.setPCValue(" ");
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(ni);
            parentNode.add(newNode);
        }
    }

    public void setSelectedNodes(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parentNode = null;
        Object tempNode = null;
        DefaultMutableTreeNode curNode = node.getFirstLeaf();
        Vector<DefaultMutableTreeNode> leafs = new Vector<DefaultMutableTreeNode>();
        leafs.addElement(curNode);
        while (curNode != null) {
            if ((curNode = curNode.getNextLeaf()) == null) continue;
            leafs.addElement(curNode);
        }
        Enumeration enumeration = leafs.elements();
        while (enumeration.hasMoreElements()) {
            String pcdata;
            curNode = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeInfo ni = (NodeInfo)curNode.getUserObject();
            if (!ni.name.equals("#PCDATA") || (pcdata = ni.getPCValue()).trim().length() <= 0) continue;
            Vector<DefaultMutableTreeNode> path2root = new Vector<DefaultMutableTreeNode>();
            path2root.addElement(curNode);
            for (parentNode = (DefaultMutableTreeNode)curNode.getParent(); parentNode != null; parentNode = (DefaultMutableTreeNode)parentNode.getParent()) {
                path2root.addElement(parentNode);
            }
            for (int i = path2root.size() - 1; i > -1; --i) {
                DefaultMutableTreeNode cNode = (DefaultMutableTreeNode)path2root.elementAt(i);
                NodeInfo cni = (NodeInfo)cNode.getUserObject();
                if (!cni.isChoice()) continue;
                Enumeration<? extends TreeNode> eee = cNode.getParent().children();
                while (eee.hasMoreElements()) {
                    DefaultMutableTreeNode nnn = (DefaultMutableTreeNode)eee.nextElement();
                    NodeInfo ni1 = (NodeInfo)nnn.getUserObject();
                    if (ni1.getName().equals(cni.getName()) || ni1.getName().startsWith("attribute-")) {
                        ni1.setSelected(true);
                        continue;
                    }
                    if (cni.isCheckbox() && this.hasNonEmptyTextLeaves(nnn)) {
                        ni1.setSelected(true);
                        continue;
                    }
                    ni1.setSelected(false);
                }
            }
        }
    }

    Vector getMatches(DefaultMutableTreeNode match, Vector vec) {
        Vector<DefaultMutableTreeNode> matches = new Vector<DefaultMutableTreeNode>();
        Enumeration enumeration = vec.elements();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!this.compareNodes(tn, match)) continue;
            matches.addElement(tn);
        }
        return matches;
    }

    void putXMLintoTree(DefaultTreeModel tm, String xmlText) {
        if (xmlText != null) {
            CatalogEntityResolver cer = new CatalogEntityResolver();
            DocFrame docFrame = this;
            this.config = docFrame.morpho.getConfiguration();
            DocFrame docFrame2 = this;
            String local_dtd_directory = docFrame2.config.getConfigDirectory() + File.separator + this.config.get("local_dtd_directory", 0);
            String catalogPath = this.config.get("local_catalog_path", 0);
            String xmlcatalogfile = local_dtd_directory + "/catalog";
            try {
                this.myCatalog = new Catalog();
                this.myCatalog.loadSystemCatalogs();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                URL catalogURL = cl.getResource(catalogPath);
                this.myCatalog.parseCatalog(catalogURL.toString());
                cer.setCatalog(this.myCatalog);
            }
            catch (Exception e) {
                Log.debug(10, "Problem creating Catalog (772)!\n" + e.getMessage());
            }
            try {
                String temp;
                StringReader sr = new StringReader(xmlText);
                XMLReader parser = null;
                XMLDisplayHandler mh = new XMLDisplayHandler(tm);
                parser = Morpho.createSaxParser(mh, null);
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", mh);
                parser.setEntityResolver(cer);
                InputSource is = new InputSource(sr);
                parser.parse(is);
                DefaultMutableTreeNode rt = (DefaultMutableTreeNode)tm.getRoot();
                if (mh.getPublicId() != null) {
                    this.publicIDString = this.doctype = mh.getPublicId();
                } else {
                    this.doctype = mh.getSystemId() != null ? mh.getSystemId() : ((NodeInfo)rt.getUserObject()).toString();
                }
                this.rootnodeName = mh.getDocname();
                if (this.rootnodeName == null) {
                    this.rootnodeName = ((DefaultMutableTreeNode)tm.getRoot()).toString();
                }
                if ((temp = this.myCatalog.resolvePublic(this.doctype, null)) != null) {
                    if (temp.startsWith("file:")) {
                        temp = temp.substring(5, temp.length());
                    }
                    this.dtdfile = temp;
                    this.systemIDString = temp;
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
        }
    }

    DefaultTreeModel putDOMintoTree(Node node) {
        this.rootnodeName = node.getNodeName();
        Document doc = node.getOwnerDocument();
        DOMTree domtree = new DOMTree(doc);
        return (DefaultTreeModel)domtree.getModel();
    }

    void tree_valueChanged(TreePath tp) {
        if (this.treeValueFlag && tp != null) {
            Object ob = tp.getLastPathComponent();
            DefaultMutableTreeNode node = null;
            if (ob != null) {
                node = (DefaultMutableTreeNode)ob;
            }
            this.selectedNode = node;
            NodeInfo ni = (NodeInfo)node.getUserObject();
            if (ni.isChoice() && !ni.isCheckbox()) {
                Enumeration<? extends TreeNode> eee = node.getParent().children();
                while (eee.hasMoreElements()) {
                    DefaultMutableTreeNode nnn = (DefaultMutableTreeNode)eee.nextElement();
                    NodeInfo ni1 = (NodeInfo)nnn.getUserObject();
                    if (ni1.getName().equals(ni.getName())) {
                        ni1.setSelected(true);
                        continue;
                    }
                    ni1.setSelected(false);
                }
                this.tree.repaint();
                this.tree.invalidate();
            }
            int width = this.getSize().width - this.DocControlPanel.getDividerLocation() - 40;
            XMLPanels xp = new XMLPanels(node, width);
            xp.setTreeModel(this.treeModel);
            xp.setContainer(this);
            xp.setTree(this.tree);
            this.NestedPanelScrollPanel.getViewport().removeAll();
            this.NestedPanelScrollPanel.getViewport().add(xp.topPanel);
        }
        this.treeValueFlag = true;
    }

    void Copy_actionPerformed(ActionEvent event) {
        TreePath tp = this.tree.getSelectionPath();
        if (tp != null) {
            Object ob = tp.getLastPathComponent();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ob;
            nodeCopy = this.deepNodeCopy(node);
            if (this.controller != null) {
                this.controller.setClipboardObject(nodeCopy);
            }
        }
    }

    void Paste_actionPerformed(ActionEvent event) {
        TreePath tp = this.tree.getSelectionPath();
        if (tp != null) {
            Object ob = tp.getLastPathComponent();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ob;
            DefaultMutableTreeNode localcopy = this.deepNodeCopy(nodeCopy);
            String nodename = ((NodeInfo)node.getUserObject()).getName();
            if (this.controller != null) {
                nodeCopy = (DefaultMutableTreeNode)this.controller.getClipboardObject();
            }
            if (nodeCopy != null) {
                String savenodename = ((NodeInfo)localcopy.getUserObject()).getName();
                if (savenodename.startsWith("attribute-")) {
                    savenodename = "attribute-";
                }
                if (nodename.startsWith(savenodename) || ((NodeInfo)node.getUserObject()).isChoice()) {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    int indx = parent.getIndex(node);
                    parent.insert(localcopy, indx + 1);
                    this.tree.expandPath(tp);
                    this.treeModel.reload(parent);
                    this.tree.setSelectionPath(tp);
                }
            }
        }
    }

    void Addtext_actionPerformed(ActionEvent event) {
        TreePath tp = this.tree.getSelectionPath();
        if (tp != null) {
            Object ob = tp.getLastPathComponent();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ob;
            NodeInfo ni = new NodeInfo("#PCDATA");
            ni.setPCValue(" ");
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(ni);
            node.add(newNode);
            this.AddtextItem.setEnabled(false);
        }
    }

    void Replace_actionPerformed(ActionEvent event) {
        TreePath tp = this.tree.getSelectionPath();
        if (tp != null) {
            Object ob = tp.getLastPathComponent();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ob;
            DefaultMutableTreeNode localcopy = this.deepNodeCopy(nodeCopy);
            String nodename = ((NodeInfo)node.getUserObject()).getName();
            if (nodename.startsWith("attribute-")) {
                nodename = "attribute";
            }
            if (nodeCopy != null) {
                String savenodename = ((NodeInfo)localcopy.getUserObject()).getName();
                if (savenodename.startsWith("attribute-")) {
                    savenodename = "attribute";
                }
                if (nodename.equals(savenodename)) {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    int indx = parent.getIndex(node);
                    parent.insert(localcopy, indx + 1);
                    parent.remove(indx);
                    this.tree.expandPath(tp);
                    this.treeModel.reload(parent);
                    this.tree.setSelectionPath(tp);
                }
            }
        }
    }

    void Attr_actionPerformed(ActionEvent event) {
        TreePath tp = this.tree.getSelectionPath();
        if (tp != null) {
            Object ob = tp.getLastPathComponent();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ob;
            String title = "Attributes of " + ((NodeInfo)node.getUserObject()).getName();
            AttributeEditDialog aed = new AttributeEditDialog((Frame)this, title, node);
            aed.show();
        }
    }

    void Dup_actionPerformed(ActionEvent event) {
        TreePath tp = this.tree.getSelectionPath();
        if (tp != null) {
            Object ob = tp.getLastPathComponent();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ob;
            DefaultMutableTreeNode par = (DefaultMutableTreeNode)node.getParent();
            int iii = par.getIndex(node);
            DefaultMutableTreeNode newnode = this.deepNodeCopy(node);
            if (((NodeInfo)newnode.getUserObject()).isChoice() && ((NodeInfo)newnode.getUserObject()).isSelected()) {
                ((NodeInfo)newnode.getUserObject()).setSelected(false);
            }
            this.tree.expandPath(tp);
            par.insert(newnode, iii + 1);
            this.treeModel.reload(par);
            this.tree.setSelectionPath(tp);
        }
    }

    void Del_actionPerformed(ActionEvent event) {
        int selRow = -1;
        TreePath currentSelection = this.tree.getSelectionPath();
        int[] selRows = this.tree.getSelectionRows();
        if (selRows != null && selRows.length > 0) {
            selRow = selRows[0];
        }
        if (currentSelection != null) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent();
            NodeInfo ni = (NodeInfo)currentNode.getUserObject();
            String curNodeName = ni.getName();
            if (curNodeName.startsWith("attribute-")) {
                curNodeName = "attribute";
            }
            int cnt = 0;
            MutableTreeNode parent = (MutableTreeNode)currentNode.getParent();
            if (parent != null) {
                Enumeration<? extends TreeNode> eee = parent.children();
                while (eee.hasMoreElements()) {
                    DefaultMutableTreeNode cn = (DefaultMutableTreeNode)eee.nextElement();
                    NodeInfo ni1 = (NodeInfo)cn.getUserObject();
                    String name = ni1.getName();
                    if (name.startsWith("attribute-")) {
                        name = "attribute";
                    }
                    if (!name.equals(curNodeName) && !ni1.isChoice()) continue;
                    ++cnt;
                }
            }
            if (parent != null) {
                if (cnt > 1) {
                    this.treeModel.removeNodeFromParent(currentNode);
                } else if (ni.getCardinality().equalsIgnoreCase("OPTIONAL") || ni.getCardinality().equalsIgnoreCase("ZERO to MANY")) {
                    this.treeModel.removeNodeFromParent(currentNode);
                }
                if (selRow > 0) {
                    this.tree.setSelectionRow(selRow - 1);
                }
                return;
            }
        }
        Toolkit.getDefaultToolkit().beep();
    }

    void writeXML(DefaultMutableTreeNode node, String fn) {
        DefaultMutableTreeNode clone = this.deepNodeCopy(node);
        this.trimAttributeNames(clone);
        File outputFile = new File(fn);
        try {
            FileWriter out = new FileWriter(outputFile);
            this.tempStack = new Stack();
            this.start = new StringBuffer();
            if (this.trimFlag) {
                this.trimNoInfoNodes(clone);
            }
            this.saveAttributeValues(clone);
            this.write_loop(clone, 0);
            String str1 = this.start.toString();
            String doctype = "";
            if (this.publicIDString != null) {
                String rootNodeName = ((NodeInfo)node.getUserObject()).getName();
                String temp = "";
                if (this.publicIDString != null) {
                    temp = "\"" + this.publicIDString + "\"";
                }
                String temp1 = "";
                if (this.systemIDString != null) {
                    temp1 = "\"file://" + this.systemIDString + "\"";
                }
                doctype = "<!DOCTYPE " + rootNodeName + " PUBLIC " + temp + " " + temp1 + ">\n";
            }
            str1 = "<?xml version=\"1.0\"?>\n" + str1;
            out.write(str1);
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String writeXMLString(DefaultMutableTreeNode node, boolean returnError) {
        String errorString;
        DefaultMutableTreeNode clone = this.deepNodeCopy(node);
        this.trimAttributeNames(clone);
        this.tempStack = new Stack();
        this.start = new StringBuffer();
        if (this.trimFlag && (errorString = this.trimNoInfoNodes(clone)) != null && returnError) {
            return errorString;
        }
        this.saveAttributeValues(clone);
        this.write_loop(clone, 0);
        String str1 = this.start.toString();
        String doctype = "";
        if (this.publicIDString != null) {
            String rootNodeName = ((NodeInfo)node.getUserObject()).getName();
            String temp = "";
            if (this.publicIDString != null) {
                temp = "\"" + this.publicIDString + "\"";
            }
            String temp1 = "";
            if (this.systemIDString != null) {
                temp1 = "\"file://" + this.systemIDString + "\"";
            }
            doctype = "<!DOCTYPE " + rootNodeName + " PUBLIC " + temp + " " + temp1 + ">\n";
        }
        str1 = "<?xml version=\"1.0\"?>\n" + doctype + str1;
        return str1;
    }

    public Node writeToDOM(DefaultMutableTreeNode node) {
        String xml = this.writeXMLString(node, false);
        StringReader sr = new StringReader(xml);
        Node DOMOut = null;
        try {
            DOMOut = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)sr);
        }
        catch (Exception e) {
            Log.debug(4, "Problem writing DOM from XML string!\n" + e.toString());
        }
        return DOMOut;
    }

    void write_loop(DefaultMutableTreeNode node, int indent) {
        String indentString = "";
        while (indentString.length() < indent) {
            indentString = indentString + " ";
        }
        StringBuffer start1 = new StringBuffer();
        boolean emptyNodeParent = false;
        NodeInfo ni = (NodeInfo)node.getUserObject();
        String name = ni.name;
        if ((!ni.isChoice() || ni.isChoice() && ni.isSelected() || !this.removeExtraInfoFlag) && !ni.isXMLAttribute()) {
            Enumeration<TreeNode> enumeration;
            if (ni.isXMLAttribute()) {
                Log.debug(0, "node " + ni.name + " is Attribute");
            }
            if (name.indexOf("CHOICE") <= -1 && name.indexOf("SEQUENCE") <= -1 && !name.equals("Empty") || !this.removeExtraInfoFlag && !name.equals("Empty")) {
                if (name.equals(this.docnode.getLocalName())) {
                    start1.append("\n" + indentString + "<" + this.docnode.getNodeName());
                } else {
                    start1.append("\n" + indentString + "<" + name);
                }
                Enumeration keys = ni.attr.keys();
                while (keys.hasMoreElements()) {
                    String str = (String)keys.nextElement();
                    String val = (String)ni.attr.get(str);
                    val = val.trim();
                    if (str.equals("minOccurs") || str.equals("maxOccurs") || str.equals("editor") || str.equals("help") || str.equals("") || val.equals("")) continue;
                    start1.append(" " + str + "=\"" + val + "\"");
                }
                if (!this.removeExtraInfoFlag) {
                    start1.append(" cardinality=\"" + ni.getCardinality() + "\"");
                    start1.append(" help=\"" + ni.getHelp() + "\"");
                }
                start1.append(">");
                String end = name.equals(this.docnode.getLocalName()) ? "</" + this.docnode.getNodeName() + ">" : "</" + name + ">";
                this.tempStack.push(end);
            }
            if (!(enumeration = node.children()).hasMoreElements()) {
                this.start.append(start1.toString());
                start1 = new StringBuffer();
            }
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode nd = (DefaultMutableTreeNode)enumeration.nextElement();
                NodeInfo ni1 = (NodeInfo)nd.getUserObject();
                if (ni1.name.equals("#PCDATA")) {
                    String card;
                    String pcdata = ni1.getPCValue();
                    if (this.emptyFlag && pcdata.trim().length() < 1 && ((card = ni.getCardinality()).equals("ZERO to MANY") || card.equals("OPTIONAL"))) {
                        start1 = new StringBuffer();
                        this.tempStack.pop();
                        this.tempStack.push("");
                    }
                    this.start.append(start1.toString());
                    start1 = new StringBuffer();
                    this.start.append(XMLUtil.normalize(ni1.getPCValue()));
                    this.textnode = true;
                    continue;
                }
                if (ni1.name.equals("Empty")) {
                    start1.setCharAt(start1.length() - 1, '/');
                    start1.append(">");
                    this.start.append(start1.toString());
                    start1 = new StringBuffer();
                    this.tempStack.pop();
                    emptyNodeParent = true;
                    this.write_loop(nd, indent + 2);
                    continue;
                }
                this.start.append(start1.toString());
                start1 = new StringBuffer();
                this.write_loop(nd, indent + 2);
            }
            if (name.indexOf("CHOICE") <= -1 && name.indexOf("SEQUENCE") <= -1 && !name.equals("Empty") || !this.removeExtraInfoFlag && !name.equals("Empty")) {
                if (this.textnode) {
                    if (!this.tempStack.isEmpty()) {
                        this.start.append((String)this.tempStack.pop());
                    }
                } else if (!emptyNodeParent) {
                    if (!this.tempStack.isEmpty()) {
                        this.start.append("\n" + indentString + (String)this.tempStack.pop());
                    }
                } else {
                    emptyNodeParent = false;
                }
                this.textnode = false;
            }
        }
    }

    String trimNoInfoNodes(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parentNode = null;
        DefaultMutableTreeNode tempNode = null;
        DefaultMutableTreeNode curNode = node.getFirstLeaf();
        String errorString = "";
        Vector<DefaultMutableTreeNode> leafs = new Vector<DefaultMutableTreeNode>();
        leafs.addElement(curNode);
        while (curNode != null) {
            if ((curNode = curNode.getNextLeaf()) == null) continue;
            leafs.addElement(curNode);
        }
        Enumeration enumeration = leafs.elements();
        block1: while (enumeration.hasMoreElements()) {
            String pcdata;
            curNode = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeInfo ni = (NodeInfo)curNode.getUserObject();
            if (!ni.name.equals("#PCDATA") || (pcdata = ni.getPCValue()).trim().length() >= 1) continue;
            Vector<DefaultMutableTreeNode> path2root = new Vector<DefaultMutableTreeNode>();
            path2root.addElement(curNode);
            String pathToRoot = "";
            pathToRoot = curNode.toString() + pathToRoot;
            for (parentNode = (DefaultMutableTreeNode)curNode.getParent(); parentNode != null; parentNode = (DefaultMutableTreeNode)parentNode.getParent()) {
                path2root.addElement(parentNode);
                pathToRoot = parentNode.toString() + "/" + pathToRoot;
            }
            for (int i = path2root.size() - 1; i > -1 && curNode.getRoot() == node; --i) {
                DefaultMutableTreeNode cNode = (DefaultMutableTreeNode)path2root.elementAt(i);
                NodeInfo cni = (NodeInfo)cNode.getUserObject();
                String card = cni.getCardinality();
                if ((cni.isCheckbox() || cni.isChoice()) && !cni.isSelected()) {
                    pathToRoot = cNode.toString() + pathToRoot;
                    while (parentNode != null) {
                        pathToRoot = parentNode.toString() + "/" + pathToRoot;
                        parentNode = (DefaultMutableTreeNode)parentNode.getParent();
                    }
                    tempNode = cNode;
                    parentNode = (DefaultMutableTreeNode)cNode.getParent();
                    if (parentNode == null) continue;
                    parentNode.remove(tempNode);
                    continue;
                }
                if (card.equals("ZERO to MANY") || card.equals("OPTIONAL")) {
                    if (this.hasNonEmptyTextLeaves(cNode)) continue;
                    tempNode = cNode;
                    parentNode = (DefaultMutableTreeNode)cNode.getParent();
                    if (parentNode == null) continue;
                    parentNode.remove(tempNode);
                    continue;
                }
                if (card.equals("ONE to MANY")) {
                    NodeInfo nni;
                    NodeInfo pni;
                    DefaultMutableTreeNode nextSibling = cNode.getNextSibling();
                    DefaultMutableTreeNode prevSibling = cNode.getPreviousSibling();
                    String cNodeName = cni.getName();
                    boolean multipleFlag = false;
                    if (prevSibling != null && (pni = (NodeInfo)prevSibling.getUserObject()).getName().equals(cNodeName)) {
                        multipleFlag = true;
                    }
                    if (nextSibling != null && (nni = (NodeInfo)nextSibling.getUserObject()).getName().equals(cNodeName)) {
                        multipleFlag = true;
                    }
                    if (this.hasNonEmptyTextLeaves(cNode)) continue;
                    if (multipleFlag) {
                        tempNode = cNode;
                        parentNode = (DefaultMutableTreeNode)cNode.getParent();
                        if (parentNode == null) continue;
                        parentNode.remove(tempNode);
                        continue;
                    }
                    if (cNode.getRoot() != node) continue;
                    if (errorString.equals("")) {
                        errorString = errorString + "\n\t\t" + pathToRoot;
                        continue block1;
                    }
                    errorString = errorString + ",\n\t\t" + pathToRoot;
                    continue block1;
                }
                if (!card.equals("ONE") || cni.isXMLAttribute()) continue;
                parentNode = (DefaultMutableTreeNode)cNode.getParent();
                boolean generateError = false;
                if (parentNode != null) {
                    Enumeration<TreeNode> childEnum = parentNode.children();
                    while (childEnum.hasMoreElements()) {
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childEnum.nextElement();
                        NodeInfo childInfo = (NodeInfo)childNode.getUserObject();
                        if (childNode == cNode || childInfo.isXMLAttribute() || childInfo.isCheckbox() || childInfo.isChoice() || !this.hasNonEmptyTextLeaves(childNode)) continue;
                        generateError = true;
                    }
                }
                if (!generateError || this.hasNonEmptyTextLeaves(cNode)) continue;
                if (errorString.equals("")) {
                    errorString = errorString + "\n\t\t" + pathToRoot;
                    continue block1;
                }
                errorString = errorString + ",\n\t\t" + pathToRoot;
                continue block1;
            }
        }
        if (!errorString.equals("")) {
            return errorString;
        }
        return null;
    }

    boolean hasNonEmptyTextLeaves(DefaultMutableTreeNode node) {
        boolean res = false;
        Object parentNode = null;
        Enumeration<TreeNode> enumeration = node.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            String pcdata;
            NodeInfo ni;
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!curNode.isLeaf() || (ni = (NodeInfo)curNode.getUserObject()).isXMLAttribute() || !ni.name.equals("#PCDATA") || (pcdata = ni.getPCValue()).trim().length() <= 0) continue;
            return true;
        }
        return res;
    }

    boolean hasEmptyTextLeaves(DefaultMutableTreeNode node) {
        boolean res = false;
        Object parentNode = null;
        Enumeration<TreeNode> enumeration = node.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!curNode.isLeaf()) continue;
            NodeInfo ni = (NodeInfo)curNode.getUserObject();
            if (!ni.name.equals("#PCDATA")) continue;
            String pcdata = ni.getPCValue();
            Log.debug(1, "White space check: " + pcdata);
            if (pcdata.trim().length() != 0) continue;
            return true;
        }
        return res;
    }

    void expandTreeToLevel(JTree jt, int level) {
        TreeModel tm = jt.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tm.getRoot();
        Enumeration<TreeNode> enumeration = root.breadthFirstEnumeration();
        DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)enumeration.nextElement();
        while (enumeration.hasMoreElements() && curNode.getLevel() < level) {
            try {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)curNode.getFirstChild();
                NodeInfo ni = (NodeInfo)childNode.getUserObject();
                if (!ni.getName().equals("#PCDATA")) {
                    Object[] tn = curNode.getPath();
                    TreePath tp = new TreePath(tn);
                    this.tree.expandPath(tp);
                }
            }
            catch (Exception w) {
                // empty catch block
            }
            curNode = (DefaultMutableTreeNode)enumeration.nextElement();
        }
    }

    void treeUnion(DefaultMutableTreeNode input, DefaultMutableTreeNode template) {
        Vector tempVector = new Vector();
        Object qw = null;
        if (!this.compareNodes(input, template)) {
            Log.debug(20, "Root nodes do not match!!!");
        } else {
            Vector<DefaultMutableTreeNode> currentLevelInputNodes = new Vector<DefaultMutableTreeNode>();
            currentLevelInputNodes.addElement(input);
            Vector<DefaultMutableTreeNode> currentLevelTemplateNodes = new Vector<DefaultMutableTreeNode>();
            currentLevelTemplateNodes.addElement(template);
            for (int j = 0; j < this.numlevels; ++j) {
                Vector<DefaultMutableTreeNode> nextLevelInputNodes = new Vector<DefaultMutableTreeNode>();
                Enumeration enumeration = currentLevelInputNodes.elements();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode nd = (DefaultMutableTreeNode)enumeration.nextElement();
                    Enumeration<TreeNode> qq = nd.children();
                    while (qq.hasMoreElements()) {
                        DefaultMutableTreeNode nd1 = (DefaultMutableTreeNode)qq.nextElement();
                        nextLevelInputNodes.addElement(nd1);
                    }
                }
                Vector<DefaultMutableTreeNode> nextLevelTemplateNodes = new Vector<DefaultMutableTreeNode>();
                Enumeration enum1 = currentLevelTemplateNodes.elements();
                while (enum1.hasMoreElements()) {
                    DefaultMutableTreeNode ndt = (DefaultMutableTreeNode)enum1.nextElement();
                    Enumeration<TreeNode> qq1 = ndt.children();
                    while (qq1.hasMoreElements()) {
                        DefaultMutableTreeNode ndt1 = (DefaultMutableTreeNode)qq1.nextElement();
                        nextLevelTemplateNodes.addElement(ndt1);
                    }
                }
                enumeration = nextLevelTemplateNodes.elements();
                while (enumeration.hasMoreElements()) {
                    boolean insTest = false;
                    DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    NodeInfo ni = (NodeInfo)tNode.getUserObject();
                    if (ni.getName().indexOf("CHOICE") <= -1 && ni.getName().indexOf("SEQUENCE") <= -1) continue;
                    DefaultMutableTreeNode templParent = (DefaultMutableTreeNode)tNode.getParent();
                    DefaultMutableTreeNode specCopy = (DefaultMutableTreeNode)tNode.clone();
                    Vector choiceParentHits = this.getMatches(templParent, currentLevelInputNodes);
                    for (int m = 0; m < choiceParentHits.size(); ++m) {
                        DefaultMutableTreeNode workingInstanceNode = (DefaultMutableTreeNode)choiceParentHits.elementAt(m);
                        DefaultMutableTreeNode specCopyClone = (DefaultMutableTreeNode)specCopy.clone();
                        specCopyClone.setUserObject(((NodeInfo)specCopy.getUserObject()).cloneNodeInfo());
                        Enumeration<TreeNode> kids = workingInstanceNode.children();
                        Vector<DefaultMutableTreeNode> kidsVec = new Vector<DefaultMutableTreeNode>();
                        while (kids.hasMoreElements()) {
                            kidsVec.addElement((DefaultMutableTreeNode)kids.nextElement());
                        }
                        int cindex = -1;
                        boolean insertTest = true;
                        for (int n = 0; n < kidsVec.size(); ++n) {
                            DefaultMutableTreeNode kidNode = (DefaultMutableTreeNode)kidsVec.elementAt(n);
                            if (!this.hasAMatch(kidNode, tNode)) continue;
                            cindex = workingInstanceNode.getIndex(kidNode);
                            if (insertTest) {
                                workingInstanceNode.insert(specCopyClone, cindex);
                                nextLevelInputNodes.insertElementAt(specCopyClone, cindex);
                                insertTest = false;
                            }
                            specCopyClone.add(kidNode);
                        }
                    }
                }
                currentLevelInputNodes = nextLevelInputNodes;
                currentLevelTemplateNodes = nextLevelTemplateNodes;
            }
        }
        this.mergeData(input, template);
        if (this.mergeMissingFlag) {
            this.mergingMissingSubtrees(input, template);
        }
    }

    void mergeData(DefaultMutableTreeNode instance, DefaultMutableTreeNode template) {
        if (!this.compareNodes(instance, template)) {
            Log.debug(20, "Root nodes do not match!!!");
        } else {
            this.mergeNodes(instance, template);
            Vector<DefaultMutableTreeNode> currentLevelInputNodes = new Vector<DefaultMutableTreeNode>();
            currentLevelInputNodes.addElement(instance);
            Vector<DefaultMutableTreeNode> currentLevelTemplateNodes = new Vector<DefaultMutableTreeNode>();
            currentLevelTemplateNodes.addElement(template);
            for (int j = 0; j < instance.getDepth(); ++j) {
                Vector<DefaultMutableTreeNode> nextLevelInputNodes = new Vector<DefaultMutableTreeNode>();
                Enumeration enumeration = currentLevelInputNodes.elements();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode nd = (DefaultMutableTreeNode)enumeration.nextElement();
                    Enumeration<TreeNode> qq = nd.children();
                    while (qq.hasMoreElements()) {
                        DefaultMutableTreeNode nd1 = (DefaultMutableTreeNode)qq.nextElement();
                        nextLevelInputNodes.addElement(nd1);
                    }
                }
                Vector<DefaultMutableTreeNode> nextLevelTemplateNodes = new Vector<DefaultMutableTreeNode>();
                Hashtable<String, DefaultMutableTreeNode> nextLevelTemplateHash = new Hashtable<String, DefaultMutableTreeNode>();
                Enumeration enum1 = currentLevelTemplateNodes.elements();
                while (enum1.hasMoreElements()) {
                    DefaultMutableTreeNode ndt = (DefaultMutableTreeNode)enum1.nextElement();
                    Enumeration<TreeNode> qq1 = ndt.children();
                    while (qq1.hasMoreElements()) {
                        DefaultMutableTreeNode ndt1 = (DefaultMutableTreeNode)qq1.nextElement();
                        nextLevelTemplateNodes.addElement(ndt1);
                        String name = this.pathToString(ndt1);
                        nextLevelTemplateHash.put(name, ndt1);
                    }
                }
                Enumeration enumeration2 = nextLevelInputNodes.elements();
                while (enumeration2.hasMoreElements()) {
                    DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)enumeration2.nextElement();
                    String nm = this.pathToString(tNode);
                    DefaultMutableTreeNode fromNode = (DefaultMutableTreeNode)nextLevelTemplateHash.get(nm);
                    if (fromNode == null) continue;
                    this.mergeNodes(tNode, fromNode);
                }
                currentLevelInputNodes = nextLevelInputNodes;
                currentLevelTemplateNodes = nextLevelTemplateNodes;
            }
        }
    }

    void mergingMissingSubtrees(DefaultMutableTreeNode instance, DefaultMutableTreeNode template) {
        if (!this.compareNodes(instance, template)) {
            Log.debug(20, "Root nodes do not match!!!");
        } else {
            Vector<DefaultMutableTreeNode> currentLevelInputNodes = new Vector<DefaultMutableTreeNode>();
            currentLevelInputNodes.addElement(instance);
            Vector<DefaultMutableTreeNode> currentLevelTemplateNodes = new Vector<DefaultMutableTreeNode>();
            currentLevelTemplateNodes.addElement(template);
            for (int j = 0; j < instance.getDepth(); ++j) {
                Vector<DefaultMutableTreeNode> nextLevelInputNodes = new Vector<DefaultMutableTreeNode>();
                Enumeration enumeration = currentLevelInputNodes.elements();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode nd = (DefaultMutableTreeNode)enumeration.nextElement();
                    Enumeration<TreeNode> qq = nd.children();
                    while (qq.hasMoreElements()) {
                        DefaultMutableTreeNode nd1 = (DefaultMutableTreeNode)qq.nextElement();
                        nextLevelInputNodes.addElement(nd1);
                    }
                }
                Vector<DefaultMutableTreeNode> nextLevelTemplateNodes = new Vector<DefaultMutableTreeNode>();
                Hashtable<String, DefaultMutableTreeNode> curLevelTemplateHash = new Hashtable<String, DefaultMutableTreeNode>();
                Enumeration enum1 = currentLevelTemplateNodes.elements();
                while (enum1.hasMoreElements()) {
                    DefaultMutableTreeNode ndt = (DefaultMutableTreeNode)enum1.nextElement();
                    String name = this.pathToString(ndt);
                    curLevelTemplateHash.put(name.trim(), ndt);
                    Enumeration<TreeNode> qq1 = ndt.children();
                    while (qq1.hasMoreElements()) {
                        DefaultMutableTreeNode ndt1 = (DefaultMutableTreeNode)qq1.nextElement();
                        nextLevelTemplateNodes.addElement(ndt1);
                    }
                }
                Enumeration enum2 = currentLevelInputNodes.elements();
                while (enum2.hasMoreElements()) {
                    DefaultMutableTreeNode inNode = (DefaultMutableTreeNode)enum2.nextElement();
                    String nm = this.pathToString(inNode);
                    DefaultMutableTreeNode fromNode = (DefaultMutableTreeNode)curLevelTemplateHash.get(nm.trim());
                    if (fromNode == null) continue;
                    this.mergeMissingChildren(inNode, fromNode);
                }
                currentLevelInputNodes = nextLevelInputNodes;
                currentLevelTemplateNodes = nextLevelTemplateNodes;
            }
        }
    }

    void mergeMissingChildren(DefaultMutableTreeNode instance, DefaultMutableTreeNode template) {
        Enumeration<TreeNode> enumeration = instance.children();
        Vector<DefaultMutableTreeNode> instChildren = new Vector<DefaultMutableTreeNode>();
        Hashtable<String, String> pathHash = new Hashtable<String, String>();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode instanceNode = (DefaultMutableTreeNode)enumeration.nextElement();
            instChildren.addElement(instanceNode);
            String childPath = this.fullpathToString(instanceNode);
            String storedPath = (String)pathHash.get(childPath);
            if (storedPath != null && storedPath.equals(childPath)) {
                this.duplicatePathHash.put(childPath, childPath);
            }
            pathHash.put(childPath, childPath);
        }
        instChildren.addElement(this.newNode("end"));
        int instChildrenIndex = 0;
        Enumeration<TreeNode> enum1 = template.children();
        Vector<TreeNode> templChildren = new Vector<TreeNode>();
        while (enum1.hasMoreElements()) {
            templChildren.addElement(enum1.nextElement());
        }
        for (int i = 0; i < templChildren.size(); ++i) {
            DefaultMutableTreeNode templChild = (DefaultMutableTreeNode)templChildren.elementAt(i);
            if (instChildren.size() == 0) {
                instance.add(templChild);
                continue;
            }
            DefaultMutableTreeNode instChild = (DefaultMutableTreeNode)instChildren.elementAt(instChildrenIndex);
            if (!this.simpleCompareNodes(instChild, templChild)) {
                String instanceChildPath = this.fullpathToString(instChild);
                String tempPath = this.fullpathToString(templChild);
                Enumeration en = this.duplicatePathHash.keys();
                boolean copy = false;
                while (en.hasMoreElements()) {
                    String path = (String)en.nextElement();
                    System.out.println("the stored duplicate path " + path);
                    if (tempPath == null || !tempPath.startsWith(path)) continue;
                    copy = true;
                    break;
                }
                DefaultMutableTreeNode newNode = null;
                newNode = copy ? this.deepNodeCopy(templChild) : templChild;
                if (instChildrenIndex < instChildren.size() - 1) {
                    instance.insert(newNode, instance.getIndex(instChild));
                    continue;
                }
                instance.add(newNode);
                continue;
            }
            if (instChildrenIndex < instChildren.size() - 1) {
                ++instChildrenIndex;
            }
            if (instChildrenIndex >= instChildren.size() || instChildrenIndex <= 0) continue;
            instChild = (DefaultMutableTreeNode)instChildren.elementAt(instChildrenIndex);
            DefaultMutableTreeNode prevInstChild = (DefaultMutableTreeNode)instChildren.elementAt(instChildrenIndex - 1);
            while (this.simpleCompareNodes(instChild, prevInstChild) && instChildrenIndex < instChildren.size() - 1) {
                instChild = (DefaultMutableTreeNode)instChildren.elementAt(++instChildrenIndex);
                prevInstChild = (DefaultMutableTreeNode)instChildren.elementAt(instChildrenIndex - 1);
            }
        }
    }

    boolean hasAMatch(DefaultMutableTreeNode input, DefaultMutableTreeNode tempparent) {
        Vector<DefaultMutableTreeNode> specNodes = new Vector<DefaultMutableTreeNode>();
        String inputS = ((NodeInfo)input.getUserObject()).getName();
        Enumeration<TreeNode> enumeration = tempparent.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode enumNode = (DefaultMutableTreeNode)enumeration.nextElement();
            String matchS = ((NodeInfo)enumNode.getUserObject()).getName();
            if (matchS.indexOf("CHOICE") > -1 || matchS.indexOf("SEQUENCE") > -1) {
                specNodes.addElement(enumNode);
            }
            if (!matchS.startsWith(inputS)) continue;
            return true;
        }
        if (specNodes.size() > 0) {
            for (int i = 0; i < specNodes.size(); ++i) {
                DefaultMutableTreeNode specialNode = (DefaultMutableTreeNode)specNodes.elementAt(i);
                Vector list = this.getRealChildren(specialNode);
                Enumeration enum1 = list.elements();
                while (enum1.hasMoreElements()) {
                    DefaultMutableTreeNode enum1Node = (DefaultMutableTreeNode)enum1.nextElement();
                    String matchSpecial = ((NodeInfo)enum1Node.getUserObject()).getName();
                    if (!matchSpecial.startsWith(inputS)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Vector getRealChildren(DefaultMutableTreeNode nd) {
        Vector res = new Vector();
        Enumeration<TreeNode> enumeration = nd.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode curnode = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeInfo ni = (NodeInfo)curnode.getUserObject();
            if (ni.getName().indexOf("CHOICE") > -1 || ni.getName().indexOf("SEQUENCE") > -1) {
                Vector temp = this.getRealChildren(curnode);
                for (int j = 0; j < temp.size(); ++j) {
                    res.addElement(temp.elementAt(j));
                }
                continue;
            }
            res.addElement(curnode);
        }
        return res;
    }

    void treeTrim(DefaultMutableTreeNode input, DefaultMutableTreeNode template) {
        if (!this.compareNodes(input, template)) {
            Log.debug(20, "Root nodes do not match!!!");
        } else {
            Vector<DefaultMutableTreeNode> currentLevelInputNodes = new Vector<DefaultMutableTreeNode>();
            currentLevelInputNodes.addElement(input);
            Vector<DefaultMutableTreeNode> currentLevelTemplateNodes = new Vector<DefaultMutableTreeNode>();
            currentLevelTemplateNodes.addElement(template);
            for (int j = 0; j < this.numlevels; ++j) {
                Vector<DefaultMutableTreeNode> nextLevelInputNodes = new Vector<DefaultMutableTreeNode>();
                Enumeration enumeration = currentLevelInputNodes.elements();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode nd = (DefaultMutableTreeNode)enumeration.nextElement();
                    Enumeration<TreeNode> qq = nd.children();
                    while (qq.hasMoreElements()) {
                        DefaultMutableTreeNode nd1 = (DefaultMutableTreeNode)qq.nextElement();
                        nextLevelInputNodes.addElement(nd1);
                    }
                }
                Vector<DefaultMutableTreeNode> nextLevelTemplateNodes = new Vector<DefaultMutableTreeNode>();
                Enumeration enum1 = currentLevelTemplateNodes.elements();
                while (enum1.hasMoreElements()) {
                    DefaultMutableTreeNode ndt = (DefaultMutableTreeNode)enum1.nextElement();
                    Enumeration<TreeNode> qq1 = ndt.children();
                    while (qq1.hasMoreElements()) {
                        DefaultMutableTreeNode ndt1 = (DefaultMutableTreeNode)qq1.nextElement();
                        nextLevelTemplateNodes.addElement(ndt1);
                    }
                }
                enumeration = nextLevelInputNodes.elements();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode inNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    Vector hits = this.simpleGetMatches(inNode, nextLevelTemplateNodes);
                    if (hits.size() >= 1) continue;
                    DefaultMutableTreeNode parNode = (DefaultMutableTreeNode)inNode.getParent();
                    parNode.remove(inNode);
                }
                currentLevelInputNodes = nextLevelInputNodes;
                currentLevelTemplateNodes = nextLevelTemplateNodes;
            }
        }
    }

    Vector simpleGetMatches(DefaultMutableTreeNode match, Vector vec) {
        Vector<DefaultMutableTreeNode> matches = new Vector<DefaultMutableTreeNode>();
        Enumeration enumeration = vec.elements();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!this.simpleCompareNodes(tn, match)) continue;
            matches.addElement(tn);
        }
        return matches;
    }

    boolean compareNodes(DefaultMutableTreeNode node1, DefaultMutableTreeNode node2) {
        String node2Str;
        boolean ret = false;
        String node1Str = this.pathToString(node1);
        if (node1Str.equals(node2Str = this.pathToString(node2))) {
            ret = true;
        }
        return ret;
    }

    boolean simpleCompareNodes(DefaultMutableTreeNode node1, DefaultMutableTreeNode node2) {
        boolean ret = false;
        NodeInfo node1ni = (NodeInfo)node1.getUserObject();
        NodeInfo node2ni = (NodeInfo)node2.getUserObject();
        if (node1ni.getName().equals(node2ni.getName())) {
            ret = true;
        }
        return ret;
    }

    String pathToString(DefaultMutableTreeNode node) {
        int pathLength;
        int start = 0;
        StringBuffer sb = new StringBuffer();
        TreeNode[] tset = node.getPath();
        int numiterations = tset.length;
        if (numiterations > (pathLength = 3)) {
            start = numiterations - pathLength;
        }
        for (int i = start; i < numiterations; ++i) {
            String temp = ((NodeInfo)((DefaultMutableTreeNode)tset[i]).getUserObject()).getName();
            sb.append(temp + "/");
        }
        return sb.toString();
    }

    String fullpathToString(DefaultMutableTreeNode node) {
        int start = 0;
        StringBuffer sb = new StringBuffer();
        TreeNode[] tset = node.getPath();
        int numiterations = tset.length;
        for (int i = start; i < numiterations; ++i) {
            String temp = ((NodeInfo)((DefaultMutableTreeNode)tset[i]).getUserObject()).getName();
            sb.append(temp + "/");
        }
        return sb.toString();
    }

    void mergeNodes(DefaultMutableTreeNode input, DefaultMutableTreeNode template) {
        if (this.compareNodes(input, template)) {
            String help;
            String rooteditor;
            NodeInfo inputni = (NodeInfo)input.getUserObject();
            NodeInfo templateni = (NodeInfo)template.getUserObject();
            inputni.setCardinality(templateni.getCardinality());
            inputni.setChoice(templateni.isChoice());
            if (templateni.isChoice()) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)input.getParent();
                if (((NodeInfo)parent.getUserObject()).isChoice()) {
                    DefaultMutableTreeNode grandparent = (DefaultMutableTreeNode)parent.getParent();
                    if (grandparent != null) {
                        Enumeration<TreeNode> penum = grandparent.children();
                        while (penum.hasMoreElements()) {
                            DefaultMutableTreeNode sib = (DefaultMutableTreeNode)penum.nextElement();
                            ((NodeInfo)sib.getUserObject()).setSelected(false);
                        }
                    }
                    ((NodeInfo)parent.getUserObject()).setSelected(true);
                }
                Enumeration<TreeNode> enumeration = parent.children();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode sib = (DefaultMutableTreeNode)enumeration.nextElement();
                    ((NodeInfo)sib.getUserObject()).setSelected(false);
                }
                inputni.setSelected(true);
            }
            if (templateni.getHelp() != null) {
                inputni.setHelp(templateni.getHelp());
            }
            Enumeration attrlist = templateni.attr.keys();
            while (attrlist.hasMoreElements()) {
                String key = (String)attrlist.nextElement();
                if (inputni.attr.containsKey(key)) continue;
                inputni.attr.put(key, templateni.attr.get(key));
            }
            String editor = (String)inputni.attr.get("editor");
            if (editor != null) {
                inputni.setEditor(editor);
                inputni.attr.remove("editor");
            }
            if ((rooteditor = (String)inputni.attr.get("rooteditor")) != null) {
                inputni.setRootEditor(rooteditor);
                inputni.attr.remove("rooteditor");
            }
            if ((help = (String)inputni.attr.get("help")) != null) {
                inputni.setHelp(help);
                inputni.attr.remove("help");
            }
        }
    }

    void EditingExit_actionPerformed(ActionEvent event) {
        this.treeModel = (DefaultTreeModel)this.tree.getModel();
        this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        String xmlout = this.writeXMLString(this.rootNode, true);
        if (xmlout.indexOf("<?xml version=\"1.0\"?>") < 0) {
            Log.debug(5, "Unable to trim following nodes: " + xmlout + "\n\nPlease check if all the required values are entered " + "and that there are no empty fields");
            return;
        }
        Log.debug(20, xmlout);
        String valresult = this.xmlvalidate(xmlout);
        if (valresult.indexOf("<valid />") > -1) {
            if (this.controller != null) {
                this.controller.fireEditingCompleteEvent(this, xmlout);
                this.setVisible(false);
                this.dispose();
                this.tree = null;
                this.treeModel = null;
                this.OutputScrollPanelContainer = null;
                this.NestedPanelScrollPanel = null;
                System.gc();
            } else {
                this.writeOutputFile(xmlout);
            }
        } else {
            Log.debug(20, "Validation problem: " + valresult);
            String msg = "The saved document is not valid for some reason.\nYou can save it locally and fix the problem later,\nbut you will be unable to submit it to the network storage system.\n\nDo you want to Continue Exiting the Editor?";
            int opt1 = JOptionPane.showConfirmDialog(null, msg, "Validation Problem!", 0);
            if (opt1 == 0) {
                if (this.controller != null) {
                    this.controller.fireEditingCompleteEvent(this, xmlout);
                    this.setVisible(false);
                    this.dispose();
                    System.gc();
                } else {
                    this.writeOutputFile(xmlout);
                }
            }
        }
    }

    void writeOutputFile(String xmlout) {
        JFileChooser fc = new JFileChooser();
        String userdir = System.getProperty("user.dir");
        fc.setCurrentDirectory(new File(userdir));
        fc.setSelectedFile(new File("out.xml"));
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File savefile = fc.getSelectedFile();
            StringReader sr = null;
            try {
                int c;
                FileWriter w = new FileWriter(savefile);
                sr = new StringReader(xmlout);
                while ((c = sr.read()) != -1) {
                    w.write(c);
                }
                w.close();
                sr.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    void DocFrame_windowClosing(WindowEvent event) {
        if (this.controller != null) {
            this.controller.fireEditingCanceledEvent(this, this.XMLTextString);
        }
        this.setVisible(false);
        this.dispose();
        this.tree = null;
        this.treeModel = null;
        this.OutputScrollPanelContainer = null;
        this.NestedPanelScrollPanel = null;
        System.gc();
        if (this.controller == null) {
            System.exit(0);
        }
    }

    void OpenButton_actionPerformed(ActionEvent event) {
        JFileChooser fc = new JFileChooser();
        String userdir = System.getProperty("user.dir");
        fc.setCurrentDirectory(new File(userdir));
        fc.setSelectedFile(new File("*.xml"));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            this.openfile = fc.getSelectedFile();
            this.id = this.openfile.getName();
            StringWriter sw = null;
            try {
                int c;
                FileReader r = new FileReader(this.openfile);
                sw = new StringWriter();
                while ((c = r.read()) != -1) {
                    sw.write(c);
                }
                r.close();
                sw.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.logoLabel.setIcon((ImageIcon)icons.get("Btfly4.gif"));
            this.headLabel.setText("Working...");
            this.initDoc(null, sw.toString());
        }
    }

    void NewButton_actionPerformed(ActionEvent event) {
        this.templateFlag = false;
        this.logoLabel.setIcon((ImageIcon)icons.get("Btfly4.gif"));
        this.headLabel.setText("Working...");
        this.openfile = new File("./lib/eml.xml");
        StringWriter sw = null;
        try {
            int c;
            FileReader r = new FileReader(this.openfile);
            sw = new StringWriter();
            while ((c = r.read()) != -1) {
                sw.write(c);
            }
            r.close();
            sw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initDoc(null, sw.toString());
    }

    void CancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.dispose();
        System.gc();
    }

    void createDTDInstance() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Select a DTD file to see schema");
        String userdir = System.getProperty("user.dir");
        fc.setCurrentDirectory(new File(userdir));
        fc.setSelectedFile(new File("*.dtd"));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File dtdfile = fc.getSelectedFile();
            DefaultMutableTreeNode nd = this.buildDTDTree(dtdfile.getAbsolutePath());
            if (nd != null) {
                this.rootNode = nd;
                this.treeModel = new DefaultTreeModel(this.rootNode);
                this.treeModel.reload();
                this.tree.setModel(this.treeModel);
                this.tree.expandRow(1);
                this.tree.expandRow(5);
                this.tree.setSelectionRow(0);
                this.setTitle("Morpho Editor:" + this.id);
                this.headLabel.setText("Morpho Editor");
                this.logoLabel.setIcon((ImageIcon)icons.get("logo-icon.gif"));
                this.headLabel.setText("Morpho Editor");
            } else {
                Log.debug(0, "dtd tree root node is null!");
            }
        }
    }

    void TrimTreeButton_actionPerformed(ActionEvent event) {
        this.removeReferencesFlag = true;
        this.logoLabel.setIcon((ImageIcon)icons.get("Btfly4.gif"));
        this.headLabel.setText("Working...");
        this.treeModel = (DefaultTreeModel)this.tree.getModel();
        this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        this.trimNoInfoNodes(this.rootNode);
        this.TrimTreeButton.setEnabled(false);
        this.UntrimTreeButton.setEnabled(true);
        this.treeModel.reload();
        this.tree.expandRow(1);
        this.tree.setSelectionRow(0);
        this.headLabel.setText("Morpho Editor");
        this.logoLabel.setIcon((ImageIcon)icons.get("logo-icon.gif"));
    }

    void UntrimTreeButton_actionPerformed(ActionEvent event) {
        this.logoLabel.setIcon((ImageIcon)icons.get("Btfly4.gif"));
        this.headLabel.setText("Working...");
        this.treeModel = (DefaultTreeModel)this.tree.getModel();
        this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        String xmlout = this.writeXMLString(this.rootNode, false);
        this.mergeMissingFlag = true;
        this.removeReferencesFlag = false;
        this.initDoc(null, xmlout);
        this.TrimTreeButton.setEnabled(true);
        this.UntrimTreeButton.setEnabled(false);
    }

    void ContractTreeButton_actionPerformed(ActionEvent event) {
        --this.exp_level;
        if (this.exp_level < 0) {
            this.exp_level = 0;
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.expandTreeToLevel(this.tree, this.exp_level);
        this.tree.setSelectionRow(0);
    }

    void ExpandTreeButton_actionPerformed(ActionEvent event) {
        ++this.exp_level;
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.expandTreeToLevel(this.tree, this.exp_level);
        this.tree.setSelectionRow(0);
    }

    void DocFrame_componentResized() {
        int width = this.getSize().width - this.DocControlPanel.getDividerLocation() - 40;
        XMLPanels xp = new XMLPanels(this.selectedNode, width);
        xp.setTreeModel(this.treeModel);
        xp.setContainer(this);
        xp.setTree(this.tree);
        this.NestedPanelScrollPanel.getViewport().removeAll();
        this.NestedPanelScrollPanel.getViewport().add(xp.topPanel);
    }

    void selectMatchingNode(DefaultMutableTreeNode topnode, String name) {
        DefaultMutableTreeNode nd = null;
        boolean hit = false;
        Enumeration<TreeNode> enumeration = topnode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements() && !hit) {
            nd = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeInfo ni = (NodeInfo)nd.getUserObject();
            if (!ni.getName().equals(name)) continue;
            hit = true;
        }
        if (hit) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)nd.getParent();
            this.setTreeValueFlag(false);
            TreePath tp = new TreePath(parent.getPath());
            this.tree.setSelectionPath(tp);
            this.tree.scrollPathToVisible(tp);
        }
    }

    void selectMatchingNode(DefaultMutableTreeNode topnode, String nodename, String text) {
        DefaultMutableTreeNode nd = null;
        boolean hit = false;
        Enumeration<TreeNode> enumeration = topnode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements() && !hit) {
            nd = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeInfo ni = (NodeInfo)nd.getUserObject();
            if (!ni.getName().equals(nodename)) continue;
            Enumeration<TreeNode> nodes = nd.children();
            String txt = "";
            DefaultMutableTreeNode ndchild = null;
            while (nodes.hasMoreElements()) {
                ndchild = (DefaultMutableTreeNode)nodes.nextElement();
                NodeInfo info1 = (NodeInfo)ndchild.getUserObject();
                if (info1.name.equals("#PCDATA")) {
                    txt = info1.getPCValue();
                }
                if (!txt.equals(text)) continue;
                hit = true;
            }
        }
        if (hit) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)nd.getParent();
            TreePath tp = new TreePath(parent.getPath());
            this.tree.setSelectionPath(tp);
            this.tree.scrollPathToVisible(tp);
        }
    }

    private void getRealChildren(DefaultMutableTreeNode node, Vector vec) {
        if (node != null && node.children() != null) {
            Enumeration<TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
                vec.addElement(child);
                if (((NodeInfo)child.getUserObject()).getName().indexOf("SEQUENCE") > -1) {
                    this.getRealChildren(child, vec);
                    continue;
                }
                if (((NodeInfo)child.getUserObject()).getName().indexOf("CHOICE") <= -1) continue;
                this.getRealChildren(child, vec);
            }
        }
    }

    private Vector sameParent(Vector list) {
        Vector ret = new Vector();
        ret.addElement(list.elementAt(0));
        if (list.size() == 1) {
            return ret;
        }
        DefaultMutableTreeNode node0 = (DefaultMutableTreeNode)list.elementAt(0);
        DefaultMutableTreeNode pnode = (DefaultMutableTreeNode)node0.getParent();
        for (int i = 1; i < list.size(); ++i) {
            DefaultMutableTreeNode nd = (DefaultMutableTreeNode)list.elementAt(i);
            DefaultMutableTreeNode pnd = (DefaultMutableTreeNode)nd.getParent();
            if (!pnd.equals(pnode)) continue;
            ret.addElement(nd);
        }
        return ret;
    }

    private int findDuplicateIndex(Enumeration enumeration, int indx) {
        int dupcount = 0;
        int uniquecount = 1;
        if (indx == 0) {
            return 0;
        }
        DefaultMutableTreeNode oldnd = (DefaultMutableTreeNode)enumeration.nextElement();
        while (uniquecount <= indx && enumeration.hasMoreElements()) {
            DefaultMutableTreeNode nd = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!this.compareNodes(oldnd, nd)) {
                ++uniquecount;
            } else {
                ++dupcount;
            }
            oldnd = nd;
        }
        return indx + dupcount;
    }

    private void trimSpecialAttributes(DefaultMutableTreeNode nd) {
        if (nd != null) {
            String help;
            String rooteditor;
            NodeInfo ni = (NodeInfo)nd.getUserObject();
            Hashtable ht = ni.attr;
            String editor = (String)ht.get("editor");
            if (editor != null) {
                ni.setEditor(editor);
                ht.remove("editor");
            }
            if ((rooteditor = (String)ht.get("rooteditor")) != null) {
                ni.setRootEditor(rooteditor);
                ht.remove("rooteditor");
            }
            if ((help = (String)ht.get("help")) != null) {
                ni.setHelp(help);
                ht.remove("help");
            }
            Enumeration<TreeNode> childnodes = nd.children();
            while (childnodes.hasMoreElements()) {
                DefaultMutableTreeNode nd1 = (DefaultMutableTreeNode)childnodes.nextElement();
                this.trimSpecialAttributes(nd1);
            }
        }
    }

    public void choiceCombo_actionPerformed(ActionEvent event) {
        String sel = (String)this.choiceCombo.getSelectedItem();
        if (sel.equals("eml")) {
            this.treeModel.setRoot(this.rootNode);
            this.treeModel.reload();
            this.tree.setModel(this.treeModel);
            this.tree.expandRow(1);
            this.tree.setSelectionRow(0);
        } else {
            this.findNodeCount = sel.equals(this.lastFoundString) ? (this.previousEvent.equals("comboBoxEdited") && event.getActionCommand().equals("comboBoxEdited") ? ++this.findNodeCount : 0) : 0;
            this.findNode(this.rootNode, sel, this.findNodeCount);
            this.lastFoundString = sel;
            this.previousEvent = event.getActionCommand();
        }
    }

    void setAttributeNames(DefaultMutableTreeNode root) {
        this.setLeafNodes(root);
        String attr_name = "";
        Enumeration<TreeNode> kids = root.breadthFirstEnumeration();
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)kids.nextElement();
            NodeInfo ni = (NodeInfo)node.getUserObject();
            if (!ni.toString().equals("attribute")) continue;
            Enumeration<TreeNode> attr_kids = node.breadthFirstEnumeration();
            while (attr_kids.hasMoreElements()) {
                DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)attr_kids.nextElement();
                NodeInfo ni1 = (NodeInfo)node1.getUserObject();
                if (!ni1.toString().equals("attributeName")) continue;
                DefaultMutableTreeNode name_node = (DefaultMutableTreeNode)node1.getFirstChild();
                attr_name = ((NodeInfo)name_node.getUserObject()).toString();
                ni.setName(ni.getName() + "-" + attr_name);
            }
        }
    }

    void trimAttributeNames(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> kids = root.breadthFirstEnumeration();
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)kids.nextElement();
            NodeInfo ni = (NodeInfo)node.getUserObject();
            if (!ni.toString().startsWith("attribute-")) continue;
            ni.setName("attribute");
        }
    }

    void setChoiceNodes(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent == null) continue;
            NodeInfo ni = (NodeInfo)parent.getUserObject();
            if (ni.getName().indexOf("CHOICE") > -1) {
                NodeInfo nc = (NodeInfo)node.getUserObject();
                nc.setChoice(true);
                if (!ni.getCardinality().equals("ONE to MANY") && !ni.getCardinality().equals("ZERO to MANY")) continue;
                nc.setCheckboxFlag(true);
                continue;
            }
            ni.setChoice(false);
        }
    }

    void setAllNodesAsSelected(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeInfo ni = (NodeInfo)node.getUserObject();
            ni.setSelected(true);
        }
        Enumeration<TreeNode> enum1 = root.depthFirstEnumeration();
        while (enum1.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enum1.nextElement();
            NodeInfo ni = (NodeInfo)node.getUserObject();
            if (ni.getName().indexOf("CHOICE") <= -1) continue;
            Enumeration<TreeNode> kids = node.children();
            boolean flag = true;
            while (kids.hasMoreElements()) {
                DefaultMutableTreeNode kidnode = (DefaultMutableTreeNode)kids.nextElement();
                NodeInfo kidni = (NodeInfo)kidnode.getUserObject();
                if (!flag) continue;
                flag = false;
                kidni.setSelected(true);
            }
        }
    }

    void removeNodesVisLevel(DefaultMutableTreeNode root, int vlev) {
        Enumeration<TreeNode> enumeration = root.breadthFirstEnumeration();
        Vector<TreeNode> vec = new Vector<TreeNode>();
        while (enumeration.hasMoreElements()) {
            vec.addElement(enumeration.nextElement());
        }
        for (int i = 0; i < vec.size(); ++i) {
            DefaultMutableTreeNode parent;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)vec.elementAt(i);
            NodeInfo ni = (NodeInfo)node.getUserObject();
            if (ni.getNodeVisLevel() <= vlev || (parent = (DefaultMutableTreeNode)node.getParent()) == null) continue;
            parent.remove(node);
        }
    }

    void addXMLAttributeNodes(DefaultMutableTreeNode root) {
        if (root == null) {
            Log.debug(0, "root is null!");
        } else {
            Enumeration<TreeNode> enumeration = root.breadthFirstEnumeration();
            Vector<TreeNode> vec = new Vector<TreeNode>();
            while (enumeration.hasMoreElements()) {
                vec.addElement(enumeration.nextElement());
            }
            for (int i = 0; i < vec.size(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)vec.elementAt(i);
                NodeInfo ni = (NodeInfo)node.getUserObject();
                Enumeration enum1 = ni.attr.keys();
                while (enum1.hasMoreElements()) {
                    String keyName = (String)enum1.nextElement();
                    String value = (String)ni.attr.get(keyName);
                    if (keyName.equalsIgnoreCase("minOccurs") || keyName.equalsIgnoreCase("maxOccurs") || keyName.equalsIgnoreCase("editor") || keyName.equalsIgnoreCase("help") || keyName.startsWith("xmlns") || keyName.indexOf(ATTRIB_NAME_FOR_SCHEMA_LOCATION) > -1 || keyName.equals("")) continue;
                    if (value == null || value.length() == 0) {
                        value = "";
                    }
                    NodeInfo newni = new NodeInfo(keyName);
                    newni.setXMLAttribute(true);
                    newni.setCardinality("ONE");
                    newni.setIcon("equal.gif");
                    DefaultMutableTreeNode newnode = new DefaultMutableTreeNode();
                    newnode.setUserObject(newni);
                    NodeInfo valni = new NodeInfo("#PCDATA");
                    valni.setCardinality("ONE");
                    valni.setXMLAttribute(true);
                    valni.setPCValue(value);
                    DefaultMutableTreeNode valNode = new DefaultMutableTreeNode();
                    valNode.setUserObject(valni);
                    newnode.add(valNode);
                    node.insert(newnode, 0);
                }
            }
        }
    }

    void saveAttributeValues(DefaultMutableTreeNode root) {
        if (root == null) {
            Log.debug(0, "root  in 'saveAttribute' method is null!");
        } else {
            Enumeration<TreeNode> enumeration = root.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
                NodeInfo ni = (NodeInfo)node.getUserObject();
                if (!ni.isXMLAttribute() || !ni.name.equalsIgnoreCase("#PCDATA")) continue;
                String val = ni.toString();
                DefaultMutableTreeNode dad = (DefaultMutableTreeNode)node.getParent();
                String attName = ((NodeInfo)dad.getUserObject()).name;
                DefaultMutableTreeNode granddad = (DefaultMutableTreeNode)dad.getParent();
                NodeInfo gdni = (NodeInfo)granddad.getUserObject();
                if (!gdni.attr.containsKey(attName)) continue;
                gdni.attr.put(attName, val);
            }
        }
    }

    void removeAttributeNodes(DefaultMutableTreeNode root) {
        Vector<DefaultMutableTreeNode> attrNodes = new Vector<DefaultMutableTreeNode>();
        if (root == null) {
            Log.debug(0, "root  in 'saveAttribute' method is null!");
        } else {
            Enumeration<TreeNode> enumeration = root.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
                NodeInfo ni = (NodeInfo)node.getUserObject();
                if (!ni.isXMLAttribute()) continue;
                attrNodes.addElement(node);
            }
            for (int i = 0; i < attrNodes.size(); ++i) {
                DefaultMutableTreeNode nd = (DefaultMutableTreeNode)attrNodes.elementAt(i);
                DefaultMutableTreeNode par = (DefaultMutableTreeNode)nd.getParent();
                par.remove(nd);
            }
        }
    }

    DefaultMutableTreeNode buildDTDTree(String filename) {
        this.trimFlag = false;
        this.removeExtraInfoFlag = false;
        DTDTree dtdtree = new DTDTree(filename);
        dtdtree.setRootElementName("dtdroot");
        dtdtree.parseDTD();
        DefaultMutableTreeNode root = dtdtree.rootNode;
        return root;
    }

    public String xmlvalidate(String xml) {
        StringReader sr = new StringReader(xml);
        try {
            SAXValidate validator = new SAXValidate(true);
            String emlVersion = ((EML200DataPackage)UIController.getInstance().getCurrentAbstractDataPackage()).getEMLVersion();
            String xsdPath = "xsd/" + emlVersion + "/eml.xsd";
            Log.debug(30, "Loading schema: " + xsdPath);
            File fff = new File(xsdPath);
            Log.debug(30, "Real schema path: " + fff.getAbsolutePath());
            String emlpath = "";
            if (fff.exists()) {
                emlpath = fff.getAbsolutePath();
                emlpath = emlpath.trim().replaceAll("\\s", "%20").replace('\\', '/');
            }
            validator.runTest(sr, "DEFAULT", "eml://ecoinformatics.org/" + emlVersion + " file:///" + emlpath);
            return "<valid />";
        }
        catch (IOException ioe) {
            return "IOException: Error reading file:" + ioe.getMessage();
        }
        catch (ClassNotFoundException cnfe) {
            return "Parser class not found";
        }
        catch (Exception w) {
            Log.debug(30, "Validation problem: " + w.toString());
            return "Exception:" + w.getMessage();
        }
    }

    public DefaultMutableTreeNode findTemplateNodeByName(String nodeName) {
        if (frootNode == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = frootNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode nd = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeInfo ni = (NodeInfo)nd.getUserObject();
            String ndname = ni.getName();
            if (!ndname.equals(nodeName)) continue;
            return nd;
        }
        return null;
    }

    void removeAllReferences(DefaultMutableTreeNode node) {
        if (!this.removeReferencesFlag) {
            return;
        }
        Vector<DefaultMutableTreeNode> refsnodes = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = node.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeInfo ni = (NodeInfo)dmtn.getUserObject();
            if (!ni.getName().equals("references")) continue;
            refsnodes.addElement(dmtn);
        }
        for (int i = 0; i < refsnodes.size(); ++i) {
            DefaultMutableTreeNode nd = (DefaultMutableTreeNode)refsnodes.elementAt(i);
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)nd.getParent();
            NodeInfo pni = (NodeInfo)parent.getUserObject();
            String parname = pni.getName();
            if (parname.indexOf("SEQUENCE") > -1) {
                nd = parent;
                parent = (DefaultMutableTreeNode)parent.getParent();
            }
            DefaultMutableTreeNode grandparent = (DefaultMutableTreeNode)parent.getParent();
            int parentIndex = grandparent.getIndex(parent);
            nd.removeFromParent();
            parent.removeFromParent();
            Enumeration<TreeNode> kids = parent.children();
            int indx = parentIndex;
            while (kids.hasMoreElements()) {
                DefaultMutableTreeNode cnd = (DefaultMutableTreeNode)kids.nextElement();
                NodeInfo ni_cnd = (NodeInfo)cnd.getUserObject();
                ni_cnd.setChoice(false);
                ni_cnd.setSelected(ni_cnd.isSelected());
                grandparent.insert(cnd, indx);
                ++indx;
            }
        }
    }

    private String getXMLLocation(String identifier) {
        try {
            this.getXSLTResolverService();
        }
        catch (ServiceNotHandledException ee) {
            Log.debug(0, "Error acquiring XSLT Resolver plugin: " + ee);
            ee.printStackTrace();
            return null;
        }
        return resolver.getTreeEditorXMLLocation(identifier);
    }

    private XSLTResolverInterface getXSLTResolverService() throws ServiceNotHandledException {
        if (resolver == null) {
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(XSLTResolverInterface.class);
            resolver = (XSLTResolverInterface)((Object)provider);
        }
        return resolver;
    }

    class SymComponent
    extends ComponentAdapter {
        SymComponent() {
        }

        public void componentMoved(ComponentEvent event) {
            Object object = event.getSource();
            if (object == DocFrame.this) {
                // empty if block
            }
        }

        public void componentResized(ComponentEvent event) {
            DocFrame.this.validate();
            DocFrame.this.setVisible(true);
            Graphics g = DocFrame.this.getGraphics();
            DocFrame.this.paint(g);
            g.dispose();
            Object object = event.getSource();
            if (object == DocFrame.this) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DocFrame.this.DocFrame_componentResized();
                    }
                });
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == DocFrame.this) {
                DocFrame.this.DocFrame_windowClosing(event);
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        boolean trigger = false;

        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.trigger = true;
            } else {
                TreePath tp = DocFrame.this.tree.getPathForLocation(e.getX(), e.getY());
                if (tp != null && !DocFrame.this.treeSelChangedFlag) {
                    NodeInfo ni;
                    Object ob = tp.getLastPathComponent();
                    DefaultMutableTreeNode node = null;
                    if (ob != null) {
                        node = (DefaultMutableTreeNode)ob;
                    }
                    if (node != null && DocFrame.this.compareNodes(node, DocFrame.this.selectedNode) && (ni = (NodeInfo)node.getUserObject()).isCheckbox()) {
                        ni.setSelected(!ni.isSelected());
                    }
                    DocFrame.this.tree.invalidate();
                    DocFrame.this.OutputScrollPanel.repaint();
                }
                DocFrame.this.treeSelChangedFlag = false;
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() || this.trigger) {
                DocFrame.this.PastemenuItem.setEnabled(false);
                DocFrame.this.ReplacemenuItem.setEnabled(false);
                this.trigger = false;
                TreePath selPath = DocFrame.this.tree.getPathForLocation(e.getX(), e.getY());
                DocFrame.this.tree.setSelectionPath(selPath);
                if (DocFrame.this.selectedNode != null) {
                    if (DocFrame.this.controller != null) {
                        nodeCopy = (DefaultMutableTreeNode)DocFrame.this.controller.getClipboardObject();
                    }
                    if (nodeCopy != null) {
                        String nodename = ((NodeInfo)DocFrame.this.selectedNode.getUserObject()).getName();
                        String savenodename = ((NodeInfo)nodeCopy.getUserObject()).getName();
                        String card = ((NodeInfo)DocFrame.this.selectedNode.getUserObject()).getCardinality();
                        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)DocFrame.this.selectedNode.getParent();
                        NodeInfo parni = (NodeInfo)parent.getUserObject();
                        if (nodename.equals(savenodename) && !card.equals("ONE") || parni.getName().indexOf("CHOICE") > -1 && !parni.getCardinality().equals("ONE")) {
                            DocFrame.this.PastemenuItem.setEnabled(true);
                        }
                        if (nodename.startsWith("attribute") && savenodename.startsWith("attribute")) {
                            DocFrame.this.PastemenuItem.setEnabled(true);
                        }
                        if (nodename.equals(savenodename)) {
                            DocFrame.this.ReplacemenuItem.setEnabled(true);
                        }
                        if (nodename.startsWith("attribute") && savenodename.startsWith("attribute")) {
                            DocFrame.this.ReplacemenuItem.setEnabled(true);
                        }
                    }
                    NodeInfo ni = (NodeInfo)DocFrame.this.selectedNode.getUserObject();
                    if (DocFrame.this.selectedNode.isLeaf()) {
                        if (!ni.getName().equals("#PCDATA") && !ni.getName().equals("Empty")) {
                            DocFrame.this.AddtextItem.setEnabled(true);
                        } else {
                            DocFrame.this.AddtextItem.setEnabled(false);
                        }
                    }
                    DocFrame.this.CardmenuItem.setText("Number: " + ni.getCardinality());
                    if (ni.getCardinality().equalsIgnoreCase("ONE") && !ni.isChoice()) {
                        DocFrame.this.DupmenuItem.setEnabled(false);
                        DocFrame.this.DeletemenuItem.setEnabled(false);
                    } else {
                        DocFrame.this.DupmenuItem.setEnabled(true);
                        DocFrame.this.DeletemenuItem.setEnabled(true);
                    }
                    if (ni.getCardinality().equalsIgnoreCase("OPTIONAL")) {
                        DocFrame.this.DupmenuItem.setEnabled(false);
                    }
                }
                DocFrame.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class SymTreeSelection
    implements TreeSelectionListener {
        SymTreeSelection() {
        }

        public void valueChanged(TreeSelectionEvent event) {
            Object object = event.getSource();
            if (object == DocFrame.this.tree) {
                TreePath tp = event.getNewLeadSelectionPath();
                DocFrame.this.tree_valueChanged(tp);
                DocFrame.this.treeSelChangedFlag = true;
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == DocFrame.this.DeletemenuItem) {
                DocFrame.this.Del_actionPerformed(event);
            } else if (object == DocFrame.this.DupmenuItem) {
                DocFrame.this.Dup_actionPerformed(event);
            } else if (object == DocFrame.this.AttrmenuItem) {
                DocFrame.this.Attr_actionPerformed(event);
            } else if (object == DocFrame.this.CopymenuItem) {
                DocFrame.this.Copy_actionPerformed(event);
            } else if (object == DocFrame.this.ReplacemenuItem) {
                DocFrame.this.Replace_actionPerformed(event);
            } else if (object == DocFrame.this.PastemenuItem) {
                DocFrame.this.Paste_actionPerformed(event);
            } else if (object == DocFrame.this.AddtextItem) {
                DocFrame.this.Addtext_actionPerformed(event);
            } else if (object == DocFrame.this.EditingExit) {
                DocFrame.this.EditingExit_actionPerformed(event);
            } else if (object == DocFrame.this.CancelButton) {
                DocFrame.this.CancelButton_actionPerformed(event);
            } else if (object == DocFrame.this.OpenButton) {
                DocFrame.this.OpenButton_actionPerformed(event);
            } else if (object == DocFrame.this.NewButton) {
                DocFrame.this.NewButton_actionPerformed(event);
            } else if (object == DocFrame.this.TrimTreeButton) {
                DocFrame.this.TrimTreeButton_actionPerformed(event);
            } else if (object == DocFrame.this.UntrimTreeButton) {
                DocFrame.this.UntrimTreeButton_actionPerformed(event);
            } else if (object == DocFrame.this.ExpandTreeButton) {
                DocFrame.this.ExpandTreeButton_actionPerformed(event);
            } else if (object == DocFrame.this.ContractTreeButton) {
                DocFrame.this.ContractTreeButton_actionPerformed(event);
            } else if (object == DocFrame.this.choiceCombo) {
                DocFrame.this.choiceCombo_actionPerformed(event);
            }
        }
    }
}

