/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AddContactCommand
implements Command {
    private final String DATAPACKAGE_CONTACT_GENERIC_NAME = "contact";
    private List exsitingContactRoot;
    private Node contactRoot;
    private AbstractDataPackage adp;
    private AbstractUIPage contactPage;

    public void execute(ActionEvent event) {
        this.adp = UIController.getInstance().getCurrentAbstractDataPackage();
        this.exsitingContactRoot = this.adp.getSubtrees("contact");
        if (this.showContactDialog()) {
            try {
                this.insertContact();
                UIController.showNewPackage(this.adp);
            }
            catch (Exception w) {
                Log.debug(15, "Exception trying to modify contact DOM: " + w);
                w.printStackTrace();
                Log.debug(5, "Unable to add contact details!");
            }
        } else {
            this.adp.deleteAllSubtrees("contact");
            if (!this.exsitingContactRoot.isEmpty()) {
                Object nextXPathObj = null;
                int count = this.exsitingContactRoot.size();
                DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
                for (int i = count - 1; i > -1; --i) {
                    this.contactRoot = (Node)this.exsitingContactRoot.get(i);
                    Node check = this.adp.insertSubtree("contact", this.contactRoot, 0);
                    if (check != null) {
                        Log.debug(45, "added new creator details to package...");
                        continue;
                    }
                    Log.debug(5, "** ERROR: Unable to add new creator details to package **");
                }
            }
        }
    }

    private boolean showContactDialog() {
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, se.getMessage());
            se.printStackTrace();
        }
        if (dpwPlugin == null) {
            return false;
        }
        this.contactPage = dpwPlugin.getPage("PARTY_CONTACT_PAGE");
        OrderedMap existingValuesMap = new OrderedMap();
        List contactList = this.adp.getSubtrees("contact");
        if (!contactList.isEmpty()) {
            Iterator listIt = contactList.iterator();
            Object nextObj = null;
            Object nextTempObj2 = null;
            String nextTempString = null;
            int count = 1;
            while (listIt.hasNext()) {
                nextObj = listIt.next();
                OrderedMap tempMap = XMLUtilities.getDOMTreeAsXPathMap((Node)nextObj);
                for (Object nextTempObj2 : tempMap.keySet()) {
                    nextTempString = nextTempObj2;
                    if (nextTempString == null) continue;
                    existingValuesMap.put((Object)("/contact[" + count + "]" + nextTempString.substring("contact".length() + 1, nextTempString.length())), tempMap.get(nextTempObj2));
                }
                ++count;
            }
        }
        Log.debug(45, "sending previous data to contactPage -\n\n" + existingValuesMap);
        boolean pageCanHandleAllData = this.contactPage.setPageData(existingValuesMap, null);
        ModalDialog dialog = null;
        if (!pageCanHandleAllData) {
            UIController.getInstance().launchEditorAtSubtreeForCurrentFrame("contact", 0);
            return false;
        }
        dialog = new ModalDialog(this.contactPage, UIController.getInstance().getCurrentActiveWindow(), 770, 570);
        return dialog.USER_RESPONSE == 10;
    }

    private void insertContact() {
        OrderedMap contactMap;
        OrderedMap map = this.contactPage.getPageData("/contact[");
        Log.debug(45, "\n insertContact() Got contact details from contact page -\n" + map.toString());
        if (map == null) {
            Log.debug(5, "Unable to get contact details from input!");
            return;
        }
        if (map.isEmpty()) {
            Log.debug(45, "Deleting all contact details!");
        }
        DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
        this.adp.deleteAllSubtrees("contact");
        Iterator contactIt = map.keySet().iterator();
        Object nextXPathObj2 = null;
        String nextXPath = null;
        HashMap<String, OrderedMap> contactSetMap = new HashMap<String, OrderedMap>();
        while (contactIt.hasNext()) {
            nextXPathObj2 = contactIt.next();
            if (nextXPathObj2 == null) continue;
            nextXPath = nextXPathObj2;
            String temp = nextXPath.substring("contact".length() + 2, nextXPath.length());
            temp = temp.substring(0, temp.indexOf("]"));
            nextXPath = nextXPath.replaceFirst(temp, "1");
            if (contactSetMap.containsKey(temp)) {
                contactMap = (OrderedMap)contactSetMap.get(temp);
                contactMap.put((Object)nextXPath, map.get(nextXPathObj2));
                continue;
            }
            contactMap = new OrderedMap();
            contactMap.put((Object)nextXPath, map.get(nextXPathObj2));
            contactSetMap.put(temp, contactMap);
        }
        for (Object nextXPathObj2 : contactSetMap.keySet()) {
            contactMap = (OrderedMap)contactSetMap.get(nextXPathObj2);
            Document doc = impl.createDocument("", "contact", null);
            this.contactRoot = doc.getDocumentElement();
            try {
                XMLUtilities.getXPathMapAsDOMTree((Map)contactMap, (Node)this.contactRoot);
            }
            catch (TransformerException w) {
                Log.debug(5, "Unable to add contact details to package!");
                Log.debug(15, "TransformerException (" + w + ") calling " + "XMLUtilities.getXPathMapAsDOMTree(map, contactRoot) with \n" + "map = " + map + " and contactRoot = " + this.contactRoot);
                return;
            }
            Node check = this.adp.insertSubtree("contact", this.contactRoot, 0);
            if (check != null) {
                Log.debug(45, "added new contact details to package...");
                continue;
            }
            Log.debug(5, "** ERROR: Unable to add new contact details to package **");
        }
    }
}

