/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AddAccessCommand
implements Command {
    private final String DATAPACKAGE_ACCESS_GENERIC_NAME = "access";
    private final String ACCESS_SUBTREE_NODENAME = "/access/";
    private Node accessRoot;
    private AbstractDataPackage adp;
    private AbstractUIPage accessPage;

    public void execute(ActionEvent event) {
        this.adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (this.showAccessDialog()) {
            try {
                this.insertAccess();
                UIController.showNewPackage(this.adp);
            }
            catch (Exception w) {
                Log.debug(15, "Exception trying to modify access DOM: " + w);
                w.printStackTrace();
                Log.debug(5, "Unable to add access details!");
            }
        }
    }

    private boolean showAccessDialog() {
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, se.getMessage());
            se.printStackTrace();
        }
        if (dpwPlugin == null) {
            return false;
        }
        this.accessPage = dpwPlugin.getPage("ACCESS");
        OrderedMap existingValuesMap = null;
        this.accessRoot = this.adp.getSubtree("access", 0);
        if (this.accessRoot != null) {
            existingValuesMap = XMLUtilities.getDOMTreeAsXPathMap((Node)this.accessRoot);
        }
        Log.debug(45, "sending previous data to accessPage -\n\n" + existingValuesMap);
        boolean pageCanHandleAllData = this.accessPage.setPageData(existingValuesMap, "/access/");
        ModalDialog dialog = null;
        if (!pageCanHandleAllData) {
            UIController.getInstance().launchEditorAtSubtreeForCurrentFrame("access", 0);
            return false;
        }
        dialog = new ModalDialog(this.accessPage, UIController.getInstance().getCurrentActiveWindow(), 770, 570);
        return dialog.USER_RESPONSE == 10;
    }

    private void insertAccess() {
        OrderedMap map = this.accessPage.getPageData("/access/");
        Log.debug(45, "\n insertAccess() Got access details from Access page -\n" + map.toString());
        if (map == null || map.isEmpty()) {
            Log.debug(5, "Unable to get access details from input!");
            return;
        }
        DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
        Document doc = impl.createDocument("", "access", null);
        this.accessRoot = doc.getDocumentElement();
        try {
            XMLUtilities.getXPathMapAsDOMTree((Map)map, (Node)this.accessRoot);
        }
        catch (TransformerException w) {
            Log.debug(5, "Unable to add access details to package!");
            Log.debug(15, "TransformerException (" + w + ") calling " + "XMLUtilities.getXPathMapAsDOMTree(map, accessRoot) with \n" + "map = " + map + " and accessRoot = " + this.accessRoot);
            return;
        }
        this.adp.deleteSubtree("access", 0);
        Node check = this.adp.insertSubtree("access", this.accessRoot, 0);
        if (check != null) {
            Log.debug(45, "added new access details to package...");
        } else {
            Log.debug(5, "** ERROR: Unable to add new access details to package **");
        }
    }
}

