/*
 * Decompiled with CFR 0.152.
 */
package edu.tesc.scidb.morpho.plugins;

import edu.tesc.scidb.MetadataChecker.CreateTdmRep;
import edu.tesc.scidb.databank.sms.tdm.Database;
import edu.tesc.scidb.databank.sms.tdm.Table;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.Entity;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.PluginInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceExistsException;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Node;

public class ImportMSAccessPlugin
implements PluginInterface,
ServiceProvider,
Command {
    private MorphoFrame morphoFrame = null;
    private Morpho myMorpho;
    private DataViewContainerPanel resultPane;
    private AbstractDataPackage adp;
    private Database accessDatabase;

    public void execute(ActionEvent event) {
        Log.debug(11, "ImportAccess: Importing an MS Access Database design");
        this.adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (this.pickDatabase()) {
            try {
                this.insertDatabase();
                this.reopenPackage();
            }
            catch (Exception w) {
                Log.debug(20, "Exception trying to import an MS Access Database!");
            }
        }
    }

    private boolean pickDatabase() {
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new MdbFilter());
        chooser.showOpenDialog(this.morphoFrame);
        if (chooser.getSelectedFile() == null) {
            return false;
        }
        this.accessDatabase = CreateTdmRep.getRep(chooser.getSelectedFile());
        return this.accessDatabase != null;
    }

    private void insertDatabase() {
        Collection tables = this.accessDatabase.getTables();
        for (Table table : tables) {
            Node dataTableNode = table.getDataTableNode();
            Entity dataTableEntity = new Entity(dataTableNode);
            this.adp.addEntity(dataTableEntity);
        }
    }

    private void reopenPackage() {
        this.adp.setLocation("");
        MorphoFrame morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        Point pos = morphoFrame.getLocation();
        Dimension size = morphoFrame.getSize();
        try {
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
            DataPackageInterface dataPackage = (DataPackageInterface)((Object)provider);
            morphoFrame.setVisible(false);
            dataPackage.openNewDataPackage(this.adp, null);
            UIController controller = UIController.getInstance();
            MorphoFrame newMorphoFrame = controller.getCurrentActiveWindow();
            newMorphoFrame.setLocation(pos);
            newMorphoFrame.setSize(size);
            newMorphoFrame.setVisible(true);
            controller.removeWindow(morphoFrame);
            morphoFrame.dispose();
        }
        catch (ServiceNotHandledException snhe) {
            Log.debug(6, snhe.getMessage());
            morphoFrame.setVisible(true);
        }
    }

    public void initialize(Morpho morpho) {
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("windows") <= -1) {
            return;
        }
        this.myMorpho = morpho;
        try {
            ServiceController services = ServiceController.getInstance();
            services.addService(ImportMSAccessPlugin.class, this);
            Log.debug(20, "Service added: ImportMSAccessPlugin.");
        }
        catch (ServiceExistsException see) {
            Log.debug(6, "Service registration failed: ImportMSAccessPlugin");
            Log.debug(6, see.toString());
        }
        GUIAction ImportMSAccessDesign = new GUIAction("Import MS Access Database", null, new ImportMSAccessPlugin());
        ImportMSAccessDesign.setToolTipText("Imports a Microsoft Access database design");
        ImportMSAccessDesign.setSeparatorPosition(Morpho.SEPARATOR_PRECEDING);
        ImportMSAccessDesign.setMenuItemPosition(100);
        ImportMSAccessDesign.setMenu("Data", 4);
        ImportMSAccessDesign.setEnabled(false);
        ImportMSAccessDesign.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        ImportMSAccessDesign.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        UIController controller = UIController.getInstance();
        controller.addGuiAction(ImportMSAccessDesign);
    }

    public class MdbFilter
    extends FileFilter {
        public boolean accept(File f) {
            String ext;
            if (f.isDirectory()) {
                return true;
            }
            String filename = f.getName();
            int lastPeriodIndex = filename.lastIndexOf(".");
            return lastPeriodIndex > 0 && (ext = filename.substring(lastPeriodIndex)).equalsIgnoreCase(".MDB");
        }

        public String getDescription() {
            return "Microsoft Access Database (*.mdb)";
        }
    }
}

