/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.Component;
import java.awt.Point;
import java.util.StringTokenizer;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.eventdata.EventDataConstants;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import junit.framework.Assert;
import org.w3c.dom.Element;

public abstract class BaseEventDataTagHandler
extends AbstractTagHandler
implements EventDataConstants,
JFCXMLConstants {
    private AbstractMouseEventData m_eventData = null;

    public BaseEventDataTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public JFCTestCase getJFCTestCase() {
        IXMLTestCase tc = super.getXMLTestCase();
        if (tc instanceof JFCTestCase) {
            return (JFCTestCase)((Object)tc);
        }
        return null;
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("refid");
    }

    protected int getClicks() {
        return this.getInt("clicks", 1);
    }

    protected Component getComponent() {
        Component comp = (Component)this.getXMLTestCase().getProperty(this.getString("refid"));
        Assert.assertNotNull((String)("Component for " + this.getString("refid") + " is null"), (Object)comp);
        return comp;
    }

    protected int getModifiers() {
        if (this.getPopupTrigger()) {
            return this.getModifiers(4);
        }
        return this.getModifiers(16);
    }

    protected int getModifiers(int defaultValue) {
        int modifiers = 0;
        String s = this.getString("modifiers");
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            StringTokenizer tok = new StringTokenizer(s, "+");
            boolean button = false;
            while (tok.hasMoreElements()) {
                String token = tok.nextToken();
                if (token.equalsIgnoreCase(JFCXMLConstants.SHIFT)) {
                    ++modifiers;
                }
                if (token.equalsIgnoreCase(JFCXMLConstants.CTRL)) {
                    modifiers += 2;
                }
                if (token.equalsIgnoreCase(JFCXMLConstants.ALT)) {
                    modifiers += 8;
                }
                if (token.equalsIgnoreCase(JFCXMLConstants.ALTGR)) {
                    modifiers += 32;
                }
                if (token.equalsIgnoreCase(JFCXMLConstants.META)) {
                    modifiers += 4;
                }
                if (token.equalsIgnoreCase(JFCXMLConstants.BUTTON1)) {
                    button = true;
                    modifiers += 16;
                }
                if (token.equalsIgnoreCase(JFCXMLConstants.BUTTON2)) {
                    button = true;
                    modifiers += 8;
                }
                if (!token.equalsIgnoreCase(JFCXMLConstants.BUTTON3)) continue;
                button = true;
                modifiers += 4;
            }
            if (!button) {
                int defModifiers = AbstractMouseEventData.getDefaultModifiers(this.getPopupTrigger());
                modifiers |= defModifiers;
            }
            return modifiers;
        }
    }

    protected int getOffset() {
        try {
            return this.getInt("index", -1);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid offset specification");
        }
    }

    protected boolean getPopupTrigger() {
        return this.getBoolean("popup");
    }

    protected int getPosition() {
        String str = this.getString("position");
        if ("CENTER".equalsIgnoreCase(str)) {
            return 0;
        }
        if ("NORTH".equalsIgnoreCase(str) || "N".equalsIgnoreCase(str)) {
            return 1;
        }
        if ("NORTH_EAST".equalsIgnoreCase(str) || "NORTHEAST".equalsIgnoreCase(str) || "NE".equalsIgnoreCase(str)) {
            return 2;
        }
        if ("EAST".equalsIgnoreCase(str) || "E".equalsIgnoreCase(str)) {
            return 3;
        }
        if ("SOUTH_EAST".equalsIgnoreCase(str) || "SOUTHEAST".equalsIgnoreCase(str) || "SE".equalsIgnoreCase(str)) {
            return 4;
        }
        if ("SOUTH".equalsIgnoreCase(str) || "S".equalsIgnoreCase(str)) {
            return 5;
        }
        if ("SOUTH_WEST".equalsIgnoreCase(str) || "SOUTHWEST".equalsIgnoreCase(str) || "SW".equalsIgnoreCase(str)) {
            return 6;
        }
        if ("WEST".equalsIgnoreCase(str) || "W".equalsIgnoreCase(str)) {
            return 7;
        }
        if ("NORTH_WEST".equalsIgnoreCase(str) || "NORTHWEST".equalsIgnoreCase(str) || "NW".equalsIgnoreCase(str)) {
            return 8;
        }
        if ("CUSTOM".equalsIgnoreCase(str)) {
            return 12;
        }
        if ("PERCENT".equalsIgnoreCase(str)) {
            return 13;
        }
        return this.getInt("position", 0);
    }

    protected Point getReference() throws XMLException {
        return this.getPoint("reference", null);
    }

    protected long getSleepTime() {
        return this.getLong("sleeptime", 300L);
    }

    void setEventData(AbstractMouseEventData data) {
        this.m_eventData = data;
    }

    AbstractMouseEventData getEventData() throws XMLException {
        this.processElement();
        return this.m_eventData;
    }
}

