/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.util.StringTokenizer;
import junit.extensions.jfcunit.eventdata.PathData;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;

public class PathTagHandler
extends AbstractTagHandler
implements JFCXMLConstants {
    private PathData m_pathData = null;

    public PathTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public PathData getPathData() throws XMLException {
        if (this.m_pathData == null) {
            this.processElement();
        }
        return this.m_pathData;
    }

    public void processElement() throws XMLException {
        String pathDelimiter;
        String indexDelimiter = super.getString("indexdelimiter");
        if (indexDelimiter == null || indexDelimiter.length() == 0) {
            indexDelimiter = ".";
        }
        if ((pathDelimiter = super.getString("pathdelimiter")) == null || pathDelimiter.length() == 0) {
            pathDelimiter = ":";
        }
        String path = this.getString("path");
        String name = this.getString("id");
        StringTokenizer tok = new StringTokenizer(path, pathDelimiter);
        this.m_pathData = new PathData(tok.countTokens());
        int i = 0;
        while (tok.hasMoreTokens()) {
            int index = 0;
            String token = tok.nextToken();
            int split = token.indexOf(indexDelimiter);
            if (split > 0) {
                index = Integer.parseInt(token.substring(split + 1));
                token = token.substring(0, split);
            }
            this.m_pathData.set(i++, token, index);
        }
        if (name != null) {
            this.getXMLTestCase().addProperty(name, this.m_pathData);
        }
    }

    public void validateElement() throws XMLException {
        super.checkRequiredAttribute("path");
    }
}

