/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JViewport;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import org.w3c.dom.Element;

public class MouseEventData
extends AbstractMouseEventData {
    public static final boolean DEFAULT_ISPOPUPTRIGGER = false;
    private Component m_comp;

    public MouseEventData() {
        this.setValid(false);
    }

    public MouseEventData(JFCTestCase testCase, Component comp) {
        this(testCase, comp, 1);
    }

    public MouseEventData(JFCTestCase testCase, Component comp, int numberOfClicks) {
        this(testCase, comp, numberOfClicks, 16);
    }

    public MouseEventData(JFCTestCase testCase, Component comp, long sleepTime) {
        this(testCase, comp, 1, sleepTime);
    }

    public MouseEventData(JFCTestCase testCase, Component comp, int numberOfClicks, int modifiers) {
        this(testCase, comp, numberOfClicks, modifiers, false);
    }

    public MouseEventData(JFCTestCase testCase, Component comp, int numberOfClicks, boolean isPopupTrigger) {
        this(testCase, comp, numberOfClicks, MouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger);
    }

    public MouseEventData(JFCTestCase testCase, Component comp, int numberOfClicks, long sleepTime) {
        this(testCase, comp, numberOfClicks, 16, false, sleepTime);
    }

    public MouseEventData(JFCTestCase testCase, Component comp, int numberOfClicks, int modifiers, boolean isPopupTrigger) {
        this(testCase, comp, numberOfClicks, modifiers, isPopupTrigger, 300L);
    }

    public MouseEventData(JFCTestCase testCase, Component comp, int numberOfClicks, boolean isPopupTrigger, long sleepTime) {
        this(testCase, comp, numberOfClicks, MouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, sleepTime);
    }

    public MouseEventData(JFCTestCase testCase, Component comp, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, comp, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, null);
    }

    public MouseEventData(JFCTestCase testCase, Component comp, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, comp, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, null);
    }

    public MouseEventData(JFCTestCase testCase, Component comp, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, comp, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint);
    }

    public MouseEventData(JFCTestCase testCase, Component comp, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint) {
        this.setTestCase(testCase);
        this.setSource(comp);
        this.setNumberOfClicks(numberOfClicks);
        this.setModifiers(modifiers);
        this.setPopupTrigger(isPopupTrigger);
        this.setSleepTime(sleepTime);
        this.setPosition(position);
        this.setReferencePoint(referencePoint);
        this.setValid(true);
    }

    public Component getComponent() {
        return this.getSource();
    }

    public void setSource(Component comp) {
        this.m_comp = comp;
    }

    public Component getSource() {
        return this.m_comp;
    }

    public boolean canConsume(AWTEvent ae) {
        if (this.isValid() && ae.getSource() != this.getSource()) {
            return false;
        }
        return super.canConsume(ae);
    }

    public boolean consume(AWTEvent ae) {
        if (super.consume(ae)) {
            return true;
        }
        MouseEvent me = (MouseEvent)ae;
        Component source = (Component)me.getSource();
        this.setSource(source);
        this.setModifiers(me.getModifiers());
        this.setNumberOfClicks(me.getClickCount());
        this.setPopupTrigger(me.isPopupTrigger());
        this.setSleepTime(this.getDefaultSleepTime());
        Point p = new Point(me.getX(), me.getY());
        try {
            Point screen = source.getLocationOnScreen();
            screen.translate(p.x, p.y);
            this.setLocationOnScreen(screen);
            this.setPosition(12);
            this.setReferencePoint(p);
        }
        catch (IllegalComponentStateException exception) {
            // empty catch block
        }
        this.setValid(true);
        return true;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void populate(Element e) {
        super.populate(e);
        e.setAttribute("type", "MouseEventData");
    }

    public boolean prepareComponent() {
        if (!this.isValidForProcessing(this.m_comp)) {
            return false;
        }
        Rectangle bounds = this.m_comp.getBounds();
        this.insureVisibleLocation(this.calculatePoint(bounds));
        bounds.setLocation(this.m_comp.getLocationOnScreen());
        this.setLocationOnScreen(this.calculatePoint(bounds));
        return true;
    }

    public void insureVisibleLocation(Point p) {
        Container parent;
        for (parent = this.m_comp.getParent(); parent != null && !(parent instanceof JViewport); parent = parent.getParent()) {
        }
        if (parent != null && parent instanceof JViewport) {
            JViewport port = (JViewport)parent;
            Rectangle r = port.getViewRect();
            r.x = p.x - r.width / 2;
            r.y = p.y - r.height / 2;
            port.scrollRectToVisible(r);
        }
    }
}

