/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import junit.extensions.jfcunit.eventdata.AbstractEventData;
import org.w3c.dom.Element;

public abstract class AbstractMouseEventData
extends AbstractEventData {
    private boolean m_isPopupTrigger;
    private int m_numberOfClicks = 0;

    public static int getDefaultModifiers(boolean popupTrigger) {
        if (popupTrigger) {
            return 4;
        }
        return 16;
    }

    public int getDefaultModifiers() {
        return AbstractMouseEventData.getDefaultModifiers(this.getPopupTrigger());
    }

    public final String getModifierText() {
        StringBuffer buf = new StringBuffer();
        int modifiers = this.getModifiers();
        if ((modifiers & 8) != 0) {
            buf.append(Toolkit.getProperty("AWT.alt", "Alt"));
            buf.append("+");
        }
        if ((modifiers & 2) != 0) {
            buf.append(Toolkit.getProperty("AWT.control", "Ctrl"));
            buf.append("+");
        }
        if ((modifiers & 1) != 0) {
            buf.append(Toolkit.getProperty("AWT.shift", "Shift"));
            buf.append("+");
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
            buf.append("+");
        }
        if ((modifiers & 0x10) != 0) {
            buf.append(Toolkit.getProperty("AWT.button1", "Button1"));
            buf.append("+");
        }
        if ((modifiers & 8) != 0) {
            buf.append(Toolkit.getProperty("AWT.button2", "Button2"));
            buf.append("+");
        }
        if ((modifiers & 4) != 0) {
            buf.append(Toolkit.getProperty("AWT.button3", "Button3"));
            buf.append("+");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public final void setNumberOfClicks(int numberOfClicks) {
        this.m_numberOfClicks = numberOfClicks;
    }

    public final int getNumberOfClicks() {
        return this.m_numberOfClicks;
    }

    public int getDefaultNumberOfClicks() {
        return 1;
    }

    public boolean getDefaultPopupTrigger() {
        return false;
    }

    public void setPopupTrigger(boolean isPopupTrigger) {
        this.m_isPopupTrigger = isPopupTrigger;
    }

    public boolean getPopupTrigger() {
        return this.m_isPopupTrigger;
    }

    public boolean canConsume(AWTEvent ae) {
        String name;
        if (!(ae instanceof MouseEvent)) {
            return false;
        }
        MouseEvent me = (MouseEvent)ae;
        if (me.getID() == 506) {
            return false;
        }
        Object source = ae.getSource();
        if (source instanceof JScrollPane) {
            return false;
        }
        if (source instanceof JComponent && (name = ((JComponent)source).getName()) != null && name.endsWith(".glassPane")) {
            return false;
        }
        if (source instanceof AbstractButton && ((AbstractButton)source).getParent() instanceof JComboBox) {
            return false;
        }
        return !ae.getSource().equals(this.getRoot((Component)ae.getSource()));
    }

    public boolean consume(AWTEvent ae) {
        MouseEvent me = (MouseEvent)ae;
        int id = me.getID();
        return id == 503 || id == 504 || id == 505 || this.isValid() && ae.getSource() == this.getRoot();
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AbstractMouseEventData data = (AbstractMouseEventData)o;
        return data.getNumberOfClicks() == this.getNumberOfClicks() && data.getPopupTrigger() == this.getPopupTrigger();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void populate(Element e) {
        boolean trigger;
        super.populate(e);
        if (this.getNumberOfClicks() != this.getDefaultNumberOfClicks() && this.getNumberOfClicks() > 0) {
            e.setAttribute("clicks", "" + this.getNumberOfClicks());
        }
        if ((trigger = this.getPopupTrigger()) != this.getDefaultPopupTrigger()) {
            String value = "true";
            if (!trigger) {
                value = "false";
            }
            e.setAttribute("popup", value);
        }
    }

    public boolean sameSource(AWTEvent ae) {
        if (this.isValid()) {
            return (Component)ae.getSource() == this.getComponent();
        }
        return true;
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer buf = new StringBuffer(1000);
        buf.append(super.toString());
        buf.append(" clicks: " + this.getNumberOfClicks());
        buf.append(" popup: " + this.getPopupTrigger());
        return buf.toString();
    }
}

