<?xml version="1.0"?>
<!--
	*  '$RCSfile: edml-qti.xsl,v $'
	*      Authors: leinfelder
	*    Copyright: 2000 Regents of the University of California and the
	*               National Center for Ecological Analysis and Synthesis
	*  For Details: http://www.nceas.ucsb.edu/
	*
	*   '$Author: leinfelder $'
	*     '$Date: 2008/05/28 22:40:06 $'
	* '$Revision: 1.6 $'
	*
	* This program is free software; you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation; either version 2 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program; if not, write to the Free Software
	* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	*
	* This is an XSLT (http://www.w3.org/TR/xslt) stylesheet designed to
	* convert an XML file that is valid with respect to the edml.xsd
	* module of the Educational Metadata Language (EdML) into an HTML format
	* suitable for rendering with modern web browsers.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/02/xpath-function"
	xmlns:edml="edml://ecoinformatics.org/edml"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">

	<xsl:output method="html" encoding="iso-8859-1"
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
		doctype-system="http://www.w3.org/TR/html4/loose.dtd" indent="yes" />
	
	<!--********************************************************
		Question item part
		********************************************************-->
	<xsl:template name="question">
		<li>
			
			<table>
				<tr valign="top">
					<th colspan="2">
						<xsl:value-of select="@title" /> (<xsl:value-of select="@ident" />)
					</th>
					<xsl:element name="input">
						<xsl:attribute name="type">hidden</xsl:attribute>
						<xsl:attribute name="id">assessmentItemId</xsl:attribute>
						<xsl:attribute name="name">assessmentItemId</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of select="@ident"/>
						</xsl:attribute>
					</xsl:element>
				</tr>
				<tr valign="top">
					<td width="{$firstColWidth}" class="{$firstColStyle}">Prompt:</td>
					<td>
						<xsl:for-each select="presentation/flow/material/mattext" >
							<xsl:value-of select="." />
							<br/>
						</xsl:for-each>	
					</td>
				</tr>
				
				<tr valign="top">
					<td width="{$firstColWidth}" class="{$firstColStyle}">Choices:</td>
					<td>
						<xsl:for-each select="presentation/flow/response_lid/render_choice/flow_label/response_label">
							<xsl:value-of select="@ident"/>) <xsl:value-of select="material/mattext"/>
							<br/> 
						</xsl:for-each>
					</td>
				</tr>
				
				<!-- 				
				<tr valign="top">
					<td width="{$firstColWidth}" class="{$firstColStyle}">Answer/Grading:</td>
					<td>
						Possible points: <xsl:value-of select="resprocessing/outcomes/decvar/@maxvalue" />
						<br/>
						<xsl:for-each select="resprocessing/respcondition/conditionvar">
							<xsl:value-of select="../@title" />
								(point value: <xsl:value-of select="../setvar"/>)
								<br/>
								<xsl:for-each select="*[local-name() = 'varequal'] | *[local-name() = 'varsubset']">
									<xsl:value-of select="local-name()" />: <xsl:value-of select="." />
									<br/>
								</xsl:for-each>	
						</xsl:for-each>
					</td>
				</tr>
				-->
				
				<!-- 
				<tr valign="top">
					<td width="{$firstColWidth}" class="{$firstColStyle}">Objectives:</td>
					<td>
						<xsl:for-each select="objectives/material">
							<xsl:value-of select="mattext"/>
							<br />
						</xsl:for-each>
					</td>
				</tr>
				-->
				
				<tr valign="top">
					<td width="{$firstColWidth}" class="{$firstColStyle}">Metadata:</td>
					<td>
						<xsl:for-each select="itemmetadata/qtimetadata">
							<xsl:call-template name="qtiMetadata" />
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</li>
	</xsl:template>		
				
	
	<!--********************************************************
		Asssessment - QTI metadata part
		********************************************************-->
	<xsl:template name="qtiMetadata">
		<table xsl:use-attribute-sets="cellspacing" class="{$tabledefaultStyle}" width="100%">
			<tr valign="top">
				<td>
					<xsl:value-of select="vocabulary" />
					(<xsl:value-of select="vocabulary/@uri" />)
				</td>
			</tr>
			<tr>	
				<td>
					<xsl:for-each select=".">
						<table>
							<xsl:for-each select="qtimetadatafield">
								<tr>
									<td width="{$firstColWidth}" class="{$firstColStyle}">
										<xsl:value-of
											select="fieldlabel" />:
									</td>
									<td>
										<xsl:value-of
											select="fieldentry" />
									</td>
								</tr>
							</xsl:for-each>
						</table>
					</xsl:for-each>
				</td>
			</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>
