<?xml version="1.0"?>
<!--
	*  '$RCSfile: edml-assessment.xsl,v $'
	*      Authors: leinfelder
	*    Copyright: 2000 Regents of the University of California and the
	*               National Center for Ecological Analysis and Synthesis
	*  For Details: http://www.nceas.ucsb.edu/
	*
	*   '$Author: leinfelder $'
	*     '$Date: 2008/05/28 22:43:51 $'
	* '$Revision: 1.6 $'
	*
	* This program is free software; you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation; either version 2 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program; if not, write to the Free Software
	* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	*
	* This is an XSLT (http://www.w3.org/TR/xslt) stylesheet designed to
	* convert an XML file that is valid with respect to the edml.xsd
	* module of the Educational Metadata Language (EdML) into an HTML format
	* suitable for rendering with modern web browsers.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/02/xpath-function"
	xmlns:edml="edml://ecoinformatics.org/edml"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">
	
	<xsl:output method="html" encoding="iso-8859-1"
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
		doctype-system="http://www.w3.org/TR/html4/loose.dtd" indent="yes" />

	<!--********************************************************
		Assessment part
		********************************************************-->
	<xsl:template name="assessment">
		<table xsl:use-attribute-sets="cellspacing" class="{$tabledefaultStyle}" width="100%">
			<tr>
				<th colspan="2" class="tablehead">
					Assessment Information
				</th>
			</tr>
			<xsl:for-each select=".">
				<tr>
					<th colspan="2">
						General
					</th>
				</tr>			
				<tr>
					<td width="{$firstColWidth}" class="{$firstColStyle}">Title:</td>
					<td><xsl:value-of select="@title" /></td>
				</tr>
				<tr>	
					<td width="{$firstColWidth}" class="{$firstColStyle}">ID:</td>
					<td><xsl:value-of select="@id" /></td>
				</tr>
				<tr>
					<td width="{$firstColWidth}" class="{$firstColStyle}">Type:</td>
					<td><xsl:value-of select="@type" /></td>
				</tr>
				<tr valign="top">	
					<td width="{$firstColWidth}" class="{$firstColStyle}">Publishing Information:</td>
					<td>
						Published Source?: <xsl:value-of select="publication/@used" />
						<br/>
						Source: <xsl:value-of select="publication" />
						<br/>
						Permission to Use?: <xsl:value-of select="publication/@permission" />
						<br/>
					</td>
				</tr>
				<tr>	
					<td width="{$firstColWidth}" class="{$firstColStyle}">Duration:</td>
					<td><xsl:value-of select="duration" /><xsl:value-of select="string(' ')" /><xsl:value-of select="duration/@measurementUnit" /></td>
				</tr>
			</xsl:for-each>
			
			<!-- additional assessment info -->
			<xsl:for-each select=".">
				<tr valign="top">
					<td width="{$firstColWidth}" class="{$firstColStyle}">Administered:</td>
					<td>
						<xsl:value-of select="administered/coverage/singleDateTime/calendarDate" />
					</td>
				</tr>
				<tr>	
					<td width="{$firstColWidth}" class="{$firstColStyle}">Group Grading:</td>
					<td><xsl:value-of select="grading/@group" /></td>
				</tr>
				<tr>	
					<td width="{$firstColWidth}" class="{$firstColStyle}">Group Size:</td>
					<td><xsl:value-of select="grading/@size" /></td>
				</tr>
				<tr>	
					<td width="{$firstColWidth}" class="{$firstColStyle}">Group Grading Approach:</td>
					<td><xsl:value-of select="grading" /></td>
				</tr>
				<tr valign="top">	
					<td width="{$firstColWidth}" class="{$firstColStyle}">Characteristics:</td>
					<td>
						Timing: <xsl:value-of select="characteristics/timing" />
						<br/>
						Location: <xsl:value-of select="characteristics/location" />
						<br/>
						Resources: <xsl:value-of select="characteristics/resources" />
						<br/>
					</td>
				</tr>
				<tr>	
					<td width="{$firstColWidth}" class="{$firstColStyle}">% of Course Grade:</td>
					<td><xsl:value-of select="scoring/weighting" /></td>
				</tr>
			
			</xsl:for-each>	
				
			<!-- Questions below -->	
			<xsl:for-each select="../assessmentItems">	
				<tr>
					<th colspan="2">Assessment Items</th>
				</tr>
				<tr valign="top">
					<td></td>
					<td colspan="1">
					
						<div id="ajaxResults">Loading Assessment Items...</div>
						<script type="text/javascript" language="Javascript">
							<![CDATA[
							function generateSearchString(assessmentItemIds) {
								var query = 
									"<pathquery version='1.2'>"
									     +"<querytitle>Web-Search</querytitle>"
									     
									     //+"<returndoctype>edml://ecoinformatics.org/edml</returndoctype>"
									     +"<returndoctype>http://www.imsglobal.org/xsd/ims_qtiasiv1p2</returndoctype>"
									     
									     //classification
									     +"<returnfield>fieldlabel</returnfield>"
									     +"<returnfield>fieldentry</returnfield>"
									     +"<returnfield>objectives/material/mattext</returnfield>"
									     
									     //question content
									     +"<returnfield>presentation/flow/material/mattext</returnfield>"
									     +"<returnfield>response_label/@ident</returnfield>"
									     +"<returnfield>response_label/material/mattext</returnfield>"
									      
									     +"<returnfield>item/@title</returnfield>"
									     +"<returnfield>item/@ident</returnfield>"
									     
									     +"<querygroup operator='UNION'>";
									     
									    for (var i=0; i < assessmentItemIds.length; i++) {
									     	query +=
									     		"<queryterm searchmode='contains' casesensitive='false'>"
									                  +"<value>"
									                  + assessmentItemIds[i]
									                  +"</value>"
									                  //+"<pathexpr>item/@ident</pathexpr>"
									          +"</queryterm>";
										}
									          
									     query +=
									     "</querygroup>"
									+"</pathquery>";
								return query;	
							}
							
							function callAjax(myQuery) {
								var metacatURL = "]]><xsl:value-of select="$servletPath" /><![CDATA[";
																								
								//alert("calling ajax: " + metacatURL);
								//alert("myQuery: " + myQuery);
								
								//var myRequest = new Ajax.Request(
								var myUpdate = new Ajax.Updater(
									'ajaxResults',
									metacatURL,
									{	method: 'post',
										parameters: { action: 'squery', qformat: 'first-item', query: myQuery},
										evalScripts: true, 
										//onSuccess: function(transport) {alert('success: ' + transport.status);},
										onFailure: function(transport) {alert('failure making ajax call');}
									 });
									 
								 //alert("done calling ajax");
							}
							//generate the array of ids
							var myArray = new Array();
							var index = 0;
							]]><xsl:for-each select="assessmentItem/assessmentItemId"><![CDATA[
								myArray[index++]="]]><xsl:value-of select="." /><![CDATA[";]]>
							</xsl:for-each><![CDATA[
							var myQuery = generateSearchString(myArray);
							callAjax(myQuery);
						 ]]>	
						</script>
					</td>
				</tr>
			
			</xsl:for-each>
			
			<!-- Response data below -->	
			<xsl:for-each select=".">	
				<tr>
					<th class="tablehead" colspan="2">Assessment Response Data</th>
				</tr>
				<tr valign="top">
					<td></td>
					<td colspan="1">
						<div id="ajaxResponseData">Loading Assessment Data...</div>
						<script type="text/javascript" language="Javascript">
							<![CDATA[
							function getResponseData(docid) {
								var styleURL = "]]><xsl:value-of select="$stylePath" />/<xsl:value-of select="$qformat" /><![CDATA[";
								styleURL += "/assessmentQuery.jsp";
																								
								//alert("calling ajax: " + styleURL);
								//alert("docid: " + docid);
								
								//var myRequest = new Ajax.Request(
								var myUpdate = new Ajax.Updater(
									'ajaxResponseData',
									styleURL,
									{	method: 'post',
										parameters: { docids: docid},
										//parameters: $('responseDataSearch').serialize(true),
										evalScripts: true, 
										//onSuccess: function(transport) {alert('success: ' + transport.status);},
										onFailure: function(transport) {alert('failure making ajax call');}
									 });
									 
								 //alert("done calling response ajax");
							}
							//getResponseData("edml.4");
							getResponseData("]]><xsl:value-of select="//@packageId" /><![CDATA[");
						 ]]>	
						</script>
					</td>
				</tr>
			
			</xsl:for-each>
			
		</table>

	</xsl:template>
	
</xsl:stylesheet>
