<?xml version="1.0"?>
<!--
	*  '$RCSfile: edml-instructor.xsl,v $'
	*      Authors: leinfelder
	*    Copyright: 2000 Regents of the University of California and the
	*               National Center for Ecological Analysis and Synthesis
	*  For Details: http://www.nceas.ucsb.edu/
	*
	*   '$Author: leinfelder $'
	*     '$Date: 2007/11/02 21:34:27 $'
	* '$Revision: 1.2 $'
	*
	* This program is free software; you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation; either version 2 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program; if not, write to the Free Software
	* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	*
	* This is an XSLT (http://www.w3.org/TR/xslt) stylesheet designed to
	* convert an XML file that is valid with respect to the edml.xsd
	* module of the Educational Metadata Language (EdML) into an HTML format
	* suitable for rendering with modern web browsers.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/02/xpath-function"
	xmlns:edml="edml://ecoinformatics.org/edml"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">

	<xsl:output method="html" encoding="iso-8859-1"
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
		doctype-system="http://www.w3.org/TR/html4/loose.dtd" indent="yes" />
	
	<!--********************************************************
		instructor part
		********************************************************-->
	<xsl:template name="instructor">
		<table xsl:use-attribute-sets="cellspacing">
			<tr>
				<th colspan="2">
					Instructor Information
				</th>
			</tr>
			<tr valign="top">
				<td width="{$firstColWidth}" class="{$firstColStyle}">Name:</td>
				<td>
					<xsl:for-each select="individualName">
						<xsl:value-of select="surName" />,&#160;
						<xsl:value-of select="givenName" />
						<br/>
					</xsl:for-each>
				</td>
			</tr>
			<tr valign="top">
				<td width="{$firstColWidth}" class="{$firstColStyle}">Organization:</td>
				<td><xsl:value-of select="organizationName" /></td>
			</tr>
			<tr valign="top">
				<td width="{$firstColWidth}" class="{$firstColStyle}">Address:</td>
				<td>
					<xsl:value-of select="address/deliveryPoint" />
					<br/>
					<xsl:value-of select="address/city" />, 
					<xsl:value-of select="address/administrativeArea" />&#160;
					<xsl:value-of select="address/postalCode" />
				</td>
			</tr>
			<tr valign="top">
				<td width="{$firstColWidth}" class="{$firstColStyle}">Phone:</td>
				<td>
					<xsl:for-each select="phone">
						<xsl:value-of select="@phonetype" />: <xsl:value-of select="." />
						<br/>
					</xsl:for-each>	
				</td>
			</tr>
			<tr valign="top">
				<td width="{$firstColWidth}" class="{$firstColStyle}">Email:</td>
				<td>
					<xsl:for-each select="electronicMailAddress">
						<xsl:value-of select="." />
						<br/>
					</xsl:for-each>			
				</td>
			</tr>
			
		</table>
	</xsl:template>

	
</xsl:stylesheet>
