package edu.msu.first.parser.gui.undo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import javax.swing.undo.*;

import edu.msu.first.parser.assessment.Question;
import edu.msu.first.parser.gui.actions.RedoAction;
import edu.msu.first.parser.gui.actions.UndoAction;


public class UndoMediator extends UndoManager {
	

	@Override
	public synchronized boolean addEdit(UndoableEdit anEdit) {
		
		boolean retVal = super.addEdit(anEdit);
		updateUndoActions();
		
		return retVal;
	}
	
	public void updateUndoActions() {
		UndoAction.getInstance().putValue(UndoAction.NAME, getUndoPresentationName());
		UndoAction.getInstance().setEnabled(canUndo());
		RedoAction.getInstance().putValue(RedoAction.NAME, getRedoPresentationName());
		RedoAction.getInstance().setEnabled(canRedo());
	}
		

		

			


}