package edu.msu.first.parser.gui.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import edu.msu.first.parser.question.TextAndImage;


public class ImageChangeUndoableEdit extends AbstractUndoableEdit {

	private TextAndImage model1;
	private String oldImage1;
	private String newImage1;
	private TextAndImage model2;
	private String oldImage2;
	private String newImage2;
	
	public ImageChangeUndoableEdit(TextAndImage model1, String oldImage1, String newImage1, TextAndImage model2, String oldImage2, String newImage2) {
		super();
		this.model1 = model1;
		this.oldImage1 = oldImage1;
		this.newImage1 = newImage1;
		this.model2 = model2;
		this.oldImage2 = oldImage2;
		this.newImage2 = newImage2;
	}
	
	public ImageChangeUndoableEdit(TextAndImage model, String oldImage, String newImage) {
		this(model, oldImage, newImage, null, null, null);
	}
	
	@Override
	public String getPresentationName() {
		if (model2 != null) {
			return "move image";
		}
		else {
			return "change image";
		}
	}
	
	@Override
	public void undo() throws CannotUndoException {
		model1.setImage(oldImage1);
		if (model2 != null) {
			model2.setImage(oldImage2);
		}
		super.undo();
	}
	
	@Override
	public void redo() throws CannotRedoException {
		model1.setImage(newImage1);
		if (model2 != null) {
			model2.setImage(newImage2);
		}
		super.redo();
	}
}
