package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.List;
import java.util.Map;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.QuestionList;
import edu.msu.first.parser.question.Question;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.utilities.XMLUtilities;

/**
 * Action for adding a new <code>Question</code>. For now, it's added at the end of the document.
 * @author Garrison Benson
 *
 */
public class SaveDocumentAction extends AbstractAction {

	public static Log log = LogFactory.getLog(SaveDocumentAction.class);
	
	private static SaveDocumentAction instance;
	
	private SaveDocumentAction() {
		super("Save document", new ImageIcon(MainWindow.getInstance().getClass().getResource("Save16.gif")));
	}
	
	/**
	 * @return A singleton instance of AddQuestionAction.
	 */
	public static SaveDocumentAction getInstance() {
		if (instance == null) {
			instance = new SaveDocumentAction();
		}
		return instance;
	}
	
	/**
	 * Load a new PDF document.
	 */
	public void actionPerformed(ActionEvent e) {
		//serialize the xml
		QuestionList questions = MainWindow.getInstance().getQuestionsPane().getQuestionList();
		for (int i = 0; i < questions.questionCount(); i++) {
			StringBuffer qtiXML = new StringBuffer();
			qtiXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			qtiXML.append("<questestinterop>");
			qtiXML.append("<assessment>");
			qtiXML.append("<section>");

			Question question = questions.getQuestion(i);
			qtiXML.append(question.generateXML());

			qtiXML.append("</section>");
			qtiXML.append("</assessment>");
			qtiXML.append("</questestinterop>");
			
//			log.debug("the qti doc is:");
//			log.debug(qtiXML.toString());
//			log.debug("----------------");
			
			try {
				Document qtiDocument = 
					XMLUtilities.getXMLReaderAsDOMDocument(new StringReader(qtiXML.toString()));
				String title = 
					XMLUtilities.getTextNodeWithXPath(
							qtiDocument, 
							"//questestinterop/assessment/section/item/@title").getNodeValue();
				log.debug("qtiDocument item title=" + title);
				Map allElements = XMLUtilities.getDOMTreeAsXPathMap(qtiDocument);
				log.debug("xPathMap = " + allElements);
			} catch (Exception e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		
		
	}

}
