package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import edu.msu.first.parser.gui.MainWindow;

/**
 * Action for going to the previous page of the original document
 * shown in the PDF pane.
 * @author garrison.benson
 *
 */
public class PreviousPageAction extends AbstractAction {

	private static PreviousPageAction instance;
	
	private PreviousPageAction() {
		super("Previous page", new ImageIcon(MainWindow.getInstance().getClass().getResource("Back16.gif")));
	}
	
	/**
	 * @return A singleton instance of PreviousPageAction.
	 */
	public static PreviousPageAction getInstance() {
		if (instance == null) {
			instance = new PreviousPageAction();
		}
		return instance;
	}
	
	/**
	 * Turns to the previous page of the PDF document.
	 * @param e The ActionEvent. No particular action command is needed.
	 */
	public void actionPerformed(ActionEvent e) {
		int newPageNumber = MainWindow.getInstance().getOriginalDocumentPane().getCurrentPageNumber() - 1;
		MainWindow.getInstance().getOriginalDocumentPane().jumpToPage(newPageNumber);
	}

}
