package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.question.Question;

/**
 * Action for when the user clicks the "Choose from source" button on
 * a question.
 * @author Garrison Benson
 */
public class ChooseFromSourceAction extends AbstractAction {

	private Question question;
	
	public ChooseFromSourceAction(Question question) {
		super("Choose question from source");
		this.question = question;
	}
	
	public void actionPerformed(ActionEvent e) {
		MainWindow.getInstance().setMode(MainWindow.MODE_CHOOSETEXT);
		MainWindow.getInstance().getQuestionsPane().setChooseFromSourceQuestion(question);
	}

}
