package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import edu.msu.first.parser.gui.CategoryComponent;
import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.undo.AddCategoryUndoableEdit;
import edu.msu.first.parser.question.ResponseItem;
import edu.msu.first.parser.question.VocabItem;
import edu.ucsb.nceas.morpho.first.plugins.wizard.EdMLWizardInterface;
import edu.ucsb.nceas.morpho.first.plugins.wizard.EdMLWizardPageLibrary;
import edu.ucsb.nceas.morpho.first.plugins.wizard.pages.ThesaurusLookupPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.util.UISettings;


/**
 * Pops up a ThesaurusLookupPage. If the user selects a term and clicks OK,
 * the selected term is added to this Action's associated ResponseItem as a category
 * @author bridger.hamilton
 */
public class AddCategoryAction extends AbstractAction {
	public static String VOCABULARY = "NBII";
	private ResponseItem ri;
	
	public AddCategoryAction(ResponseItem rItem) {
		super("Add");
		ri = rItem;
	}
	
	public void actionPerformed(ActionEvent e) {
		ThesaurusLookupPage thesaurusPage = 
	    	(ThesaurusLookupPage) EdMLWizardPageLibrary.getPage(EdMLWizardInterface.THESAURUS_LOOKUP);
		
		ModalDialog thesDialog = new ModalDialog(
	    		thesaurusPage,
	    		MainWindow.getInstance(),
	    		UISettings.POPUPDIALOG_WIDTH,
	    		UISettings.POPUPDIALOG_HEIGHT, false);
	    thesDialog.resetBounds();
	    thesDialog.setVisible(true);
	    
	    if (thesDialog.USER_RESPONSE == ModalDialog.OK_OPTION) {
	    	String term = thesaurusPage.getSelectedTermValue();
	    	if(!term.equals("")){
	    		VocabItem newVItem = new VocabItem(VOCABULARY,term);
	    		if(ri.addMetadataItem(CategoryComponent.KEY,newVItem))
	    		{
	    			MainWindow.getInstance().getUndoMediator().addEdit(new AddCategoryUndoableEdit(ri,newVItem));
	    		}
	    	}
	    }
	}

}