<?xml version="1.0"?>
<!--
	*  '$RCSfile: edml.xsl,v $'
	*      Authors: leinfelder
	*    Copyright: 2000 Regents of the University of California and the
	*               National Center for Ecological Analysis and Synthesis
	*  For Details: http://www.nceas.ucsb.edu/
	*
	*   '$Author: leinfelder $'
	*     '$Date: 2008/05/27 16:10:12 $'
	* '$Revision: 1.9 $'
	*
	* This program is free software; you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation; either version 2 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program; if not, write to the Free Software
	* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	*
	* This is an XSLT (http://www.w3.org/TR/xslt) stylesheet designed to
	* convert an XML file that is valid with respect to the edml.xsd
	* module of the Educational Metadata Language (EdML) into an HTML format
	* suitable for rendering with modern web browsers.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/02/xpath-function"
	xmlns:edml="edml://ecoinformatics.org/edml"
	xmlns:rp="eml://ecoinformatics.org/party-2.0.1"
	xmlns:res="eml://ecoinformatics.org/resource-2.0.1"
	xmlns:lom="http://ltsc.ieee.org/xsd/LOM"
	xmlns:qti="http://www.imsglobal.org/xsd/ims_qtiasiv1p2"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">

	<!-- config the css styles -->
	<xsl:import href="edml-settings.xsl" />
	
	<!--  import the supporting templates -->
	<xsl:import href="edml-assessment.xsl"/> 
	<xsl:import href="edml-instructor.xsl"/>
	<xsl:import href="edml-institution.xsl"/>
	<xsl:import href="edml-course.xsl"/>
	<xsl:import href="edml-access.xsl"/>
	
	<!-- <xsl:import href="edml-qti.xsl"/> -->
	
	<xsl:output method="html" encoding="iso-8859-1"
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
		doctype-system="http://www.w3.org/TR/html4/loose.dtd" indent="yes" />
	<!-- global variables to store id node set in case to be referenced-->
	<xsl:variable name="ids" select="//*[@id!='']" />

	<xsl:template match="/">
		<html>
			<head>
				<title>Assessment Metadata</title>
				<link rel="stylesheet" type="text/css"
					href="{$stylePath}/{$qformat}/{$qformat}.css">
				</link>
				<script language="Javascript" type="text/JavaScript"
					src="{$stylePath}/{$qformat}/{$qformat}.js">
				</script>
				<script language="Javascript" type="text/JavaScript"
					src="{$styleCommonPath}/branding.js">
				</script>
				<script language="Javascript" type="text/JavaScript"
					src="{$styleCommonPath}/prototype-1.5.1.1/prototype.js">
				</script>
			</head>
			<body>

				<div id="{$mainTableAligmentStyle}">
					<script language="JavaScript"
						type="text/JavaScript">
						<xsl:if test="$insertTemplate='0'">
							<xsl:comment>
								insertTemplateOpening();//
							</xsl:comment>
						</xsl:if>
						<xsl:if test="$insertTemplate='1'">
							insertTemplateOpening();
						</xsl:if>
					</script>


					<table xsl:use-attribute-sets="cellspacing" class="{$mainContainerTableStyle}">
						<xsl:apply-templates select="*[local-name()='edml']" />
					</table>
					<script language="JavaScript"
						type="text/JavaScript">
						<xsl:if test="$insertTemplate='0'">
							<xsl:comment>
								insertTemplateClosing();//
							</xsl:comment>
						</xsl:if>
						<xsl:if test="$insertTemplate='1'">
							insertTemplateClosing();
						</xsl:if>
					</script>
				</div>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="*[local-name()='edml']">
		<tr valign="top">
			<td colspan="2">&#160;</td>
		</tr>
		<tr valign="top">
			<th colspan="2" class="tablehead">Contact Information</th>
		</tr>	
		<tr valign="top">
			<td>	
				<xsl:for-each select="instructor">
					<xsl:call-template name="instructor" />
				</xsl:for-each>
			</td>
			<td>
				<xsl:for-each select="institution">
					<xsl:call-template name="institution" />
				</xsl:for-each>
			</td>
		</tr>
		<tr valign="top">
			<td colspan="2">&#160;</td>
		</tr>
		<tr valign="top">
			<td colspan="2">		
				<xsl:for-each select="course">
					<xsl:call-template name="course" />
				</xsl:for-each>
			</td>
		</tr>
		<tr valign="top">
			<td colspan="2">&#160;</td>
		</tr>
		<tr valign="top">
			<td colspan="2">
				<xsl:for-each select="assessment">
					<xsl:call-template name="assessment" />
				</xsl:for-each>
			</td>
		</tr>
		<tr valign="top">
			<td colspan="2">&#160;</td>
		</tr>
		<tr valign="top">
			<td colspan="2">
				<xsl:for-each select="access">
					<xsl:call-template name="access" />
				</xsl:for-each>
			</td>
		</tr>
	</xsl:template>


</xsl:stylesheet>
