<?xml version="1.0"?>
<!--
	*  '$RCSfile: edml-course.xsl,v $'
	*      Authors: leinfelder
	*    Copyright: 2000 Regents of the University of California and the
	*               National Center for Ecological Analysis and Synthesis
	*  For Details: http://www.nceas.ucsb.edu/
	*
	*   '$Author: leinfelder $'
	*     '$Date: 2008/05/30 01:05:21 $'
	* '$Revision: 1.4 $'
	*
	* This program is free software; you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation; either version 2 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program; if not, write to the Free Software
	* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	*
	* This is an XSLT (http://www.w3.org/TR/xslt) stylesheet designed to
	* convert an XML file that is valid with respect to the edml.xsd
	* module of the Educational Metadata Language (EdML) into an HTML format
	* suitable for rendering with modern web browsers.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/02/xpath-function"
	xmlns:edml="edml://ecoinformatics.org/edml"
	xmlns:lom="http://ltsc.ieee.org/xsd/LOM"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">

	<xsl:output method="html" encoding="iso-8859-1"
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
		doctype-system="http://www.w3.org/TR/html4/loose.dtd" indent="yes" />

	<!--********************************************************
		Course part
		********************************************************-->
	<xsl:template name="course">
		<table xsl:use-attribute-sets="cellspacing" class="{$tabledefaultStyle}" width="100%">
			<tr>
				<th colspan="2" class="tablehead">
					Course Information
				</th>
			</tr>
			<tr valign="top">
				<td width="50%">
					<!-- general info from LOM-->
					<xsl:for-each select="lom/lom:general">
						<xsl:call-template name="lomGeneral"/>
					</xsl:for-each>
					
					<!-- custom general info -->
					<xsl:for-each select=".">
						<xsl:call-template name="customGeneral"/>
					</xsl:for-each>
				</td>
			
				<td>
					<!-- education info -->
					<xsl:for-each select="lom/lom:educational">
						<xsl:call-template name="lomEducational"/>
					</xsl:for-each>
				</td>
			</tr>
			
			<tr valign="top">	
				<td>
					<!-- relation info -->
					<xsl:for-each select="lom/lom:relation">
						<xsl:call-template name="lomRelation"/>
					</xsl:for-each>
				</td>
				
				<td>
					<!-- classification info -->
					<xsl:for-each select="lom/lom:classification">
						<xsl:call-template name="lomClassification"/>
					</xsl:for-each>
				</td>
				
			</tr>
			
		</table>

	</xsl:template>
	
	<!--********************************************************
		customGeneral part
		********************************************************-->	
	<xsl:template name="customGeneral">
		<xsl:for-each select=".">
			<table>
				<tr>
					<td width="{$firstColWidth}" class="{$firstColStyle}">Year:</td>
					<td><xsl:value-of select="year"/></td>
				</tr>
				<tr>
					<td width="{$firstColWidth}" class="{$firstColStyle}">Term:</td>
					<td><xsl:value-of select="term"/></td>
				</tr>
				<tr>
					<td width="{$firstColWidth}" class="{$firstColStyle}">Dates:</td>
					<td>
						<xsl:value-of select="coverage/rangeOfDates/beginDate"/>
						to
						<xsl:value-of select="coverage/rangeOfDates/endDate"/>
					</td>
				</tr>
				<tr>
					<td width="{$firstColWidth}" class="{$firstColStyle}"><xsl:value-of select="credit/@measurementUnit"/>:</td>
					<td>
						<xsl:value-of select="credit"/>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	
	
	<!--********************************************************
		lomGeneral part
		********************************************************-->
	<xsl:template name="lomGeneral">
		<xsl:for-each select=".">
			<table>
				<!--
				<tr>
					<th colspan="2">
						General
					</th>
				</tr>
				-->
				<xsl:if test="normalize-space(lom:title/lom:string) != ''">
					<tr>
						<td width="{$firstColWidth}" class="{$firstColStyle}">Title:</td>
						<td>
							<xsl:value-of select="lom:title/lom:string" />
						</td>
					</tr>
				</xsl:if>
				<xsl:if test="normalize-space(lom:identifier/lom:entry) != ''">					
					<tr>
						<td width="{$firstColWidth}" class="{$firstColStyle}">ID:</td>
						<td>
							<xsl:value-of
								select="lom:identifier/lom:entry" />
						</td>
					</tr>
				</xsl:if>
				<xsl:if test="normalize-space(lom:description/lom:string) != ''">
					<tr>
						<td width="{$firstColWidth}" class="{$firstColStyle}">Description:</td>
						<td>
							<xsl:value-of
								select="lom:description/lom:string" />
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:for-each>
	</xsl:template>	

	<!--********************************************************
		lomEducational part
		********************************************************-->
	<xsl:template name="lomEducational">
		<table>
			<!--
			<tr>
				<th colspan="2">
					Educational
				</th>
			</tr>
			-->
			<!--
			<tr>
				<td width="{$firstColWidth}" class="{$firstColStyle}">Context:</td>
				<td>
					<ul>
						<xsl:for-each select="lom:context">
							<li>
								<xsl:value-of select="lom:value" /> (<xsl:value-of select="lom:source" />)
							</li>	
						</xsl:for-each>	
					</ul>	
				</td>
			</tr>
			<tr>
				<td width="{$firstColWidth}" class="{$firstColStyle}">Intended End-User Role:</td>
				<td>
					<ul>
						<xsl:for-each select="lom:intendedEndUserRole">
							<li>
								<xsl:value-of select="lom:value" /> (<xsl:value-of select="lom:source" />)
							</li>	
						</xsl:for-each>	
					</ul>	
				</td>
			</tr>
			<tr>
				<td width="{$firstColWidth}" class="{$firstColStyle}">Typical Age Range:</td>
				<td>
					<ul>
						<xsl:for-each select="lom:typicalAgeRange/lom:string">
							<li>
								<xsl:value-of select="." />
							</li>	
						</xsl:for-each>	
					</ul>	
				</td>
			</tr>
			<tr>
				<td width="{$firstColWidth}" class="{$firstColStyle}">Difficulty:</td>
				<td>
					<ul>
						<xsl:for-each select="lom:difficulty">
							<li>
								<xsl:value-of select="lom:value" /> (<xsl:value-of select="lom:source" />)
							</li>	
						</xsl:for-each>	
					</ul>	
				</td>
			</tr>
			-->
			<xsl:if test="normalize-space(lom:learningResourceType/lom:value) != ''">				
				<tr>
					<td width="{$firstColWidth}" class="{$firstColStyle}">Course Type:</td>
					<td>
						<ul>
							<xsl:for-each select="lom:learningResourceType">
								<li>
									<xsl:value-of select="lom:value" />
								</li>	
							</xsl:for-each>	
						</ul>	
					</td>
				</tr>
			</xsl:if>	
			<xsl:if test="normalize-space(lom:interactivityType/lom:value) != ''">		
				<tr>
					<td width="{$firstColWidth}" class="{$firstColStyle}">Interactivity Type:</td>
					<td>
						<ul>
							<xsl:for-each select="lom:interactivityType">
								<li>
									<xsl:value-of select="lom:value" />
								</li>	
							</xsl:for-each>	
						</ul>	
					</td>
				</tr>
			</xsl:if>	
			
			<!--
			<tr>
				<td width="{$firstColWidth}" class="{$firstColStyle}">Typical Learning Time:</td>
				<td>
					<ul>
						<xsl:for-each select="lom:typicalLearningTime">
							<li>
								<xsl:value-of select="lom:description/lom:string" />  (<xsl:value-of select="lom:duration" />)
							</li>	
						</xsl:for-each>	
					</ul>	
				</td>
			</tr>
			-->
			<xsl:if test="normalize-space(lom:interactivityLevel/lom:value) != ''">		
				<tr>
					<td width="{$firstColWidth}" class="{$firstColStyle}">Interactivity Level:</td>
					<td>
						<ul>
							<xsl:for-each select="lom:interactivityLevel">
								<li>
									<xsl:value-of select="lom:value" />
								</li>	
							</xsl:for-each>	
						</ul>	
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
	
	<!--********************************************************
		lomRelation part
		********************************************************-->
	<xsl:template name="lomRelation">
		<table>
			<tr>
				<th colspan="2">
					Relationship
				</th>
			</tr>
			<tr>
				<td width="{$firstColWidth}" class="{$firstColStyle}">Kind:</td>
				<td>
					<xsl:for-each select="lom:kind">
						<xsl:value-of select="lom:value" /> (<xsl:value-of select="lom:source" />)
					</xsl:for-each>
				</td>
			</tr>
			<tr>
				<td width="{$firstColWidth}" class="{$firstColStyle}">Target:</td>
				<td>
					<xsl:for-each select="lom:resource">
						<xsl:for-each select="lom:identifier">
							<xsl:value-of select="lom:entry" /> (<xsl:value-of select="lom:catalog" />)
						</xsl:for-each>	
					</xsl:for-each>	
				</td>
			</tr>
			<tr>
				<td width="{$firstColWidth}" class="{$firstColStyle}">Description:</td>
				<td>
					<xsl:for-each select="lom:resource">
						<xsl:for-each select="lom:description/lom:string">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</xsl:for-each>	
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<!--********************************************************
		lomClassification part
		********************************************************-->
	<xsl:template name="lomClassification">
		<table>
			<tr>
				<th colspan="2">
					Classification
				</th>
			</tr>
			<tr>
				<td width="{$firstColWidth}" class="{$firstColStyle}">Purpose:</td>
				<td>
					<xsl:for-each select="lom:purpose">
						<xsl:value-of select="lom:value" /> (<xsl:value-of select="lom:source" />)
					</xsl:for-each>	
				</td>
			</tr>
			
			<xsl:for-each select="lom:taxonPath">
				<tr valign="top">
					<td width="{$firstColWidth}" class="{$firstColStyle}">Taxon (<xsl:value-of select="lom:source/lom:string"/>):</td>
					<td>						
						<xsl:for-each select="lom:taxon">
							<xsl:value-of select="lom:id" />: <xsl:value-of select="lom:entry/lom:string" />
							<br/>
						</xsl:for-each>
					</td>
				</tr>
			</xsl:for-each>	
		</table>
	</xsl:template>

</xsl:stylesheet>
