package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import edu.msu.first.parser.gui.MainWindow;

/**
 * Jumps to the page specified as an integer in the ActionCommand.
 * @author garrison.benson
 *
 */
public class PageJumpAction extends AbstractAction {

	private static PageJumpAction instance;
	
	private PageJumpAction() {
		super();
	}
	
	/**
	 * @return A singleton instance of PageJumpAction.
	 */
	public static PageJumpAction getInstance() {
		if (instance == null) {
			instance = new PageJumpAction();
		}
		return instance;
	}
	
	/**
	 * Jumps to a certain page of the document in the PDFPane.
	 * @param e The ActionEvent. Its action command should be the
	 * desired page number in string form, i.e. "5".
	 */
	public void actionPerformed(ActionEvent e) {
		MainWindow.getInstance().getOriginalDocumentPane().jumpToPage(e.getActionCommand());
	}

}
