package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.undo.AddQuestionUndoableEdit;
import edu.msu.first.parser.question.Question;

/**
 * Action for adding a new <code>Question</code>. For now, it's added at the end of the document.
 * @author Garrison Benson
 *
 */
public class AddQuestionAction extends AbstractAction {

	private static AddQuestionAction instance;
	
	private AddQuestionAction() {
		super("Add question");
	}
	
	/**
	 * @return A singleton instance of AddQuestionAction.
	 */
	public static AddQuestionAction getInstance() {
		if (instance == null) {
			instance = new AddQuestionAction();
		}
		return instance;
	}
	
	/**
	 * Add a new <code>Question</code> to the <code>QuestionList</code>.
	 */
	public void actionPerformed(ActionEvent e) {
		// TODO: Fix the following so that it isn't dependent on a particular type of question (if possible).
		// (May want to make it so the question defaults to the type of the previous question, with the number
		// that comes next.)
		// Also, figure out a parameter to be passed in to the constructor.
		Question question = new Question(1);
		MainWindow.getInstance().getQuestionsPane().getQuestionList().addQuestion(question);
		MainWindow.getInstance().getUndoMediator().addEdit(new AddQuestionUndoableEdit(question));
		
		// TODO: Find some way to make it automatically put the question in "edit" mode.
	}

}
