/**
 *  '$RCSfile: EditAssessmentCommand.java,v $'
 *  Copyright: 2000 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *    Authors: Saurabh Garg
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008/05/13 23:06:42 $'
 * '$Revision: 1.1 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package edu.ucsb.nceas.morpho.first.edml.commands;

import java.awt.event.ActionEvent;
import java.util.List;

import javax.xml.transform.TransformerException;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.first.plugins.wizard.EdMLWizardInterface;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;

/**
 * Class to handle add assessment command
 */
public class EditAssessmentCommand implements Command {

	// generic name for lookup in edml listings
	private final String ASSESSMENT_GENERIC_NAME = "assessment";

	public EditAssessmentCommand() {
	}

	/**
	 * execute add command
	 * 
	 * @param event
	 *            ActionEvent
	 */
	public void execute(ActionEvent event) {

		adp = UIController.getInstance().getCurrentAbstractDataPackage();
		exsitingAssessmentRoot = adp.getSubtrees(ASSESSMENT_GENERIC_NAME);

		if (showAssessmentDialog()) {

			try {
				insertAssessment();
				UIController.showNewPackage(adp);
			} catch (Exception w) {
				Log.debug(15, "Exception trying to modify assessment DOM: " + w);
				w.printStackTrace();
				Log.debug(5, "Unable to add assessment details!");
			}
		} else {
			// gets here if user has pressed "cancel" on dialog...
			// ////////////////////

			// Restore project subtree to state it was in when we started...
			adp.deleteAllSubtrees(ASSESSMENT_GENERIC_NAME);
			if (!exsitingAssessmentRoot.isEmpty()) {
				Object nextXPathObj = null;
				int count = exsitingAssessmentRoot.size();
				DOMImplementation impl = 
					DOMImplementationImpl.getDOMImplementation();
				for (int i = count - 1; i > -1; i--) {
					assessmentRoot = (Node) exsitingAssessmentRoot.get(i);
					Node check = 
						adp.insertSubtree(ASSESSMENT_GENERIC_NAME, assessmentRoot, 0);
					if (check != null) {
						Log.debug(45, "added new assessment details to package...");
					} else {
						Log.debug(5, "** ERROR: Unable to add new assessment details to package **");
					}
				}
			}
		}

	}

	private boolean showAssessmentDialog() {

		ServiceController sc;
		DataPackageWizardInterface dpwPlugin = null;
		try {
			sc = ServiceController.getInstance();
			dpwPlugin = 
				(DataPackageWizardInterface) sc.getServiceProvider(DataPackageWizardInterface.class);

		} catch (ServiceNotHandledException se) {

			Log.debug(6, se.getMessage());
			se.printStackTrace();
		}
		if (dpwPlugin == null) {
			return false;
		}

		assessmentPage = dpwPlugin.getPage(EdMLWizardInterface.ASSESSMENT_PAGE);

		Node courseNode = adp.getSubtree(ASSESSMENT_GENERIC_NAME, 0);
		OrderedMap existingValuesMap = 
			XMLUtilities.getDOMTreeAsXPathMap(courseNode);

		Log.debug(45, "sending previous data to assessmentPage -\n\n"
				+ existingValuesMap);

		boolean pageCanHandleAllData = 
			assessmentPage.setPageData(existingValuesMap, "/" + ASSESSMENT_GENERIC_NAME);

		ModalDialog dialog = null;
		if (pageCanHandleAllData) {

			dialog = 
				new ModalDialog(
						assessmentPage, 
						UIController.getInstance().getCurrentActiveWindow(), 
						UISettings.POPUPDIALOG_WIDTH,
						UISettings.POPUPDIALOG_HEIGHT);
		} else {

			UIController.getInstance().launchEditorAtSubtreeForCurrentFrame(
					ASSESSMENT_GENERIC_NAME, 0);
			return false;
		}

		return (dialog.USER_RESPONSE == ModalDialog.OK_OPTION);
	}

	private void insertAssessment() {

		OrderedMap map = assessmentPage.getPageData("/" + ASSESSMENT_GENERIC_NAME);
		Log.debug(45, "\n Got assessment details from "
				+ "assessment page -\n" + map.toString());

		if (map == null) {
			Log.debug(5, "Unable to get assessment details from input!");
			return;
		} else if (map.isEmpty()) {
			Log.debug(45, "Deleting all assessment details!");
		}

		DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
		// delete old title from datapackage
		adp.deleteAllSubtrees(ASSESSMENT_GENERIC_NAME);

		Document doc = impl.createDocument("", ASSESSMENT_GENERIC_NAME, null);
		assessmentRoot = doc.getDocumentElement();

		try {
			XMLUtilities.getXPathMapAsDOMTree(map, assessmentRoot);
		} catch (TransformerException w) {
			Log.debug(5, "Unable to add assessment details to package!");
			Log.debug(15,
						"TransformerException ("
								+ w
								+ ") calling "
								+ "XMLUtilities.getXPathMapAsDOMTree(map, courseRoot) with \n"
								+ "map = " + map + " and assessment = "
								+ assessmentRoot);
			return;
		}

		// add to the datapackage
		Node check = adp.insertSubtree(ASSESSMENT_GENERIC_NAME, assessmentRoot, 0);
		if (check != null) {
			Log.debug(45, "added new assessment details to package...");
		} else {
			Log.debug(5,
					"** ERROR: Unable to add new assessment details to package **");
		}

	}

	private List exsitingAssessmentRoot;
	private Node assessmentRoot;
	private AbstractDataPackage adp;
	private AbstractUIPage assessmentPage;
}
