package edu.msu.first.parser.gui.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import edu.msu.first.parser.question.Choice;
import edu.msu.first.parser.question.MultipleChoiceResponseItem;

public class DeleteChoiceUndoableEdit extends AbstractUndoableEdit {

	MultipleChoiceResponseItem responseItem;
	Choice choice;
	int index;
	
	public DeleteChoiceUndoableEdit(MultipleChoiceResponseItem responseItem, Choice choice, int index) {
		super();
		this.responseItem = responseItem;
		this.choice = choice;
		this.index = index;
	}
	
	@Override
	public String getPresentationName() {
		return "delete choice";
	}
	
	@Override
	public void undo() throws CannotUndoException {
		responseItem.addChoice(index, choice);
		super.undo();
	}
	
	@Override
	public void redo() throws CannotRedoException {
		responseItem.removeChoice(choice);
		super.redo();
	}
}
