package edu.msu.first.parser.gui.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import edu.msu.first.parser.gui.CategoryComponent;
import edu.msu.first.parser.question.ResponseItem;
import edu.msu.first.parser.question.VocabItem;

public class AddCategoryUndoableEdit extends AbstractUndoableEdit {

	private ResponseItem responseItem;
	private VocabItem category;
	private int index;
	
	public AddCategoryUndoableEdit(ResponseItem responseItem, VocabItem category) {
		super();
		this.responseItem = responseItem;
		this.category = category;
	}
	
	@Override
	public String getPresentationName() {
		return "add category";
	}
	
	@Override
	public void undo() throws CannotUndoException {
		index = responseItem.indexOf(CategoryComponent.KEY, category);
		responseItem.removeMetadataItem(CategoryComponent.KEY, category);
		super.undo();
	}
	
	@Override
	public void redo() throws CannotRedoException {
		responseItem.addMetadataItem(CategoryComponent.KEY, category, index);
		super.redo();
		
	}
}
