package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.undo.UndoManager;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.undo.UndoMediator;

public class RedoAction extends AbstractAction {

	private static RedoAction instance;
	
	private RedoAction() {
		super("Redo", new ImageIcon(MainWindow.getInstance().getClass().getResource("Redo16.gif")));
		setEnabled(false);
	}
	
	public static RedoAction getInstance() {
		if (instance == null) {
			instance = new RedoAction();
		}
		return instance;
	}
	
	public void actionPerformed(ActionEvent e) {
		UndoMediator undoMediator = MainWindow.getInstance().getUndoMediator();
		undoMediator.redo();
		undoMediator.updateUndoActions();
	}

}
