package edu.msu.first.parser.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import edu.msu.first.parser.gui.MainWindow;

/**
 * Action for moving to the next page of the PDF document.
 * @author Garrison Benson
 *
 */
public class NextPageAction extends AbstractAction {

	private static NextPageAction instance;
	
	private NextPageAction() {
		super("Next page", new ImageIcon(MainWindow.getInstance().getClass().getResource("Forward16.gif")));
	}
	
	/**
	 * @return A singleton instance of NextPageAction.
	 */
	public static NextPageAction getInstance() {
		if (instance == null) {
			instance = new NextPageAction();
		}
		return instance;
	}
	
	/**
	 * Turns to the next page of the PDF document.
	 * @param e The ActionEvent. No particular action command is needed.
	 */
	public void actionPerformed(ActionEvent e) {
		int newPageNumber = MainWindow.getInstance().getOriginalDocumentPane().getCurrentPageNumber() + 1;
		MainWindow.getInstance().getOriginalDocumentPane().jumpToPage(newPageNumber);
	}

}
