package edu.msu.first.parser.gui.actions;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.QuestionComponent;
import edu.msu.first.parser.gui.undo.EditModeUndoableEdit;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

/**
 * <code>Action</code> for when the user has just edited a <code>Question</code> and clicks "Done". One instance
 * of this <code>Action</code> exists for each <code>Question</code> object.
 * @author Garrison Benson
 */
public class EditModeDoneAction extends AbstractAction {

	private QuestionComponent questionComponent;
	
	/**
	 * @param questionComponent The <code>QuestionComponent</code> for the <code>Question</code> with which this "Done" <code>Action</code> is associated.
	 */
	public EditModeDoneAction(QuestionComponent questionComponent) {
		super("Done editing", new ImageIcon(MainWindow.getInstance().getClass().getResource("Properties16.gif")));
		this.questionComponent = questionComponent;
	}
	
	/**
	 * 
	 * @param e The <code>ActionEvent</code>. No particular action command is needed.
	 */
	public void actionPerformed(ActionEvent e) {
		boolean old = questionComponent.isEditMode();
		questionComponent.setEditMode(false);
		MainWindow.getInstance().getUndoMediator().addEdit(new EditModeUndoableEdit(questionComponent, old, false));
	}

}
