package edu.msu.first.parser.gui.actions;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.gui.QuestionComponent;
import edu.msu.first.parser.gui.undo.EditModeUndoableEdit;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

/**
 * <code>Action</code> for when the user clicks the edit button for a particular
 * <code>Question</code>. One instance of this <code>Action</code> exists for each <code>Question</code>.
 * @author Garrison Benson
 */
public class EditModeAction extends AbstractAction {

	private QuestionComponent questionComponent;
	
	/**
	 * @param questionComponent The <code>QuestionComponent</code> for the <code>Question</code> with which this "Edit" <code>Action</code> is associated.
	 */
	public EditModeAction(QuestionComponent questionComponent) {
		super("Edit question", new ImageIcon(MainWindow.getInstance().getClass().getResource("Edit16.gif")));
		this.questionComponent = questionComponent;
	}
	
	/**
	 * @param e The <code>ActionEvent</code>. No particular action command is needed.
	 */
	public void actionPerformed(ActionEvent e) {
		boolean old = questionComponent.isEditMode();
		questionComponent.setEditMode(true);
		MainWindow.getInstance().getUndoMediator().addEdit(new EditModeUndoableEdit(questionComponent, old, true));
	}

}
