package edu.msu.first.parser.gui.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

import edu.msu.first.parser.question.Choice;
import edu.msu.first.parser.question.TextAndImage;


public class TextChangeUndoableEdit extends AbstractUndoableEdit {

	private TextAndImage model;
	private String fieldName;
	private String oldText;
	private String newText;
	
	public TextChangeUndoableEdit(TextAndImage model, String fieldName, String oldText, String newText) {
		super();
		this.model = model;
		this.fieldName = fieldName;
		this.oldText = oldText;
		this.newText = newText;
	}
	
	@Override
	public String getPresentationName() {
		return "edit " + fieldName;
	}
	
	@Override
	public void undo() throws CannotUndoException {
		model.setText(oldText);
		super.undo();
	}
	
	@Override
	public void redo() throws CannotRedoException {
		model.setText(newText);
		super.redo();
	}
	
	@Override
	public boolean addEdit(UndoableEdit anEdit) {
		
		boolean retVal = false;
		// If the other edit is the same type of edit and it affects the same TextAndImage object...
		if ((anEdit.getClass() == getClass()) &&
				((TextChangeUndoableEdit)anEdit).model == model) {
			
			// If the new edit's old text is the same as our new text (in other words,
			// if the edits are in chronological order)...
			if (((TextChangeUndoableEdit)anEdit).oldText.equals(newText)) {
				newText = ((TextChangeUndoableEdit)anEdit).newText;
				retVal = true;
			}
		}
		return retVal;
	}
}
