package edu.msu.first.parser.gui.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import edu.msu.first.parser.gui.MainWindow;
import edu.msu.first.parser.question.Question;

public class AddQuestionUndoableEdit extends AbstractUndoableEdit {

	Question question;
	
	public AddQuestionUndoableEdit(Question question) {
		super();
		this.question = question;
	}
	
	@Override
	public String getPresentationName() {
		return "add question";
	}
	
	@Override
	public void undo() throws CannotUndoException {
		MainWindow.getInstance().getQuestionsPane().getQuestionList().removeQuestion(question);
		super.undo();
	}
	
	@Override
	public void redo() throws CannotRedoException {
		MainWindow.getInstance().getQuestionsPane().getQuestionList().addQuestion(question);
		super.redo();
	}
}
