/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.FileList;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;

public class Uncompact {
    public static final String VERSION = "1.0 of $Date: 2004/05/11 23:56:56 $";
    public static final String COPYRIGHT = "Copyright (c) 2004-2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Uncompact [-password <OWNER-password>] <PDF-file...>";
    private boolean fgui_ = false;
    private String password_;

    public void setPassword(String string) {
        this.password_ = string;
    }

    public void uncompact(File file) throws IOException, ParseException {
        PDFReader pDFReader = new PDFReader(file);
        Dict dict = (Dict)pDFReader.getTrailer().get("Compress");
        System.out.println("comp = " + dict.get("Compact"));
        if (dict == null || !"Compact".equals(dict.get("Filter"))) {
            pDFReader.close();
            throw new IOException("not in Compact format");
        }
        pDFReader.setPassword(this.password_);
        if (this.fgui_) {
            // empty if block
        }
        dict.remove("Filter");
        System.out.println("writing to " + file);
        PDFWriter pDFWriter = new PDFWriter(new File("riggs.pdf"), pDFReader, false);
        pDFWriter.writePDF();
        pDFReader.close();
        pDFWriter.close();
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.equals("-password")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        int n;
        Uncompact uncompact = new Uncompact();
        int n2 = uncompact.commandLine(stringArray);
        if (n2 < (n = stringArray.length)) {
            Iterator<File> iterator = new FileList(stringArray, n2, COS.FILTER).iterator();
            while (iterator.hasNext()) {
                File file = iterator.next();
                if (System.getSecurityManager() != null) continue;
                try {
                    uncompact.uncompact(file);
                }
                catch (Exception exception) {}
            }
        } else {
            uncompact.fgui_ = true;
        }
        System.exit(0);
    }
}

