/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.awt.font.NFontType1;
import com.pt.io.FileList;
import com.pt.io.InputUni;
import com.pt.io.InputUniByteArray;
import com.pt.io.InputUniFile;
import java.awt.FontFormatException;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.Images;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import phelps.io.Files;
import phelps.io.PrintStreams;
import phelps.util.Units;

public class Extract {
    static final boolean DEBUG = true;
    static final byte[] EMPTY;
    public static final String VERSION = "0.2 of $Date: 2005/07/26 21:16:48 $";
    public static final String COPYRIGHT = "Copyright (c) 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Extract [<options>] <PDF-file...>\n\t[-obj <range>] [-embed] [-font] [-image] [-stream]\n\t[-page <range>] [-min <size>]\n\t[-edit] [-share]\n\t[-cache <directory>]\n\t[-password <password>] [-verbose] [-quiet]";
    private boolean fembed_ = false;
    private boolean ffont_ = false;
    private boolean fimage_ = false;
    private boolean fstream_ = false;
    private boolean fedit_ = false;
    private boolean fshare_ = false;
    private String range_ = null;
    private String objrange_ = null;
    private File cachepath_;
    private int min_ = 1;
    private String password_ = null;
    private boolean fverbose_ = false;
    private boolean fquiet_ = false;
    private boolean fmonitor_ = false;
    private PrintStream out_;
    private PDFReader pdfr_;
    private Map<Long, File> cache_ = new HashMap<Long, File>(100);
    static final /* synthetic */ boolean $assertionsDisabled;

    public Extract(File file) throws IOException, ParseException {
        this(new InputUniFile(file));
    }

    public Extract(byte[] byArray) throws IOException, ParseException {
        this(new InputUniByteArray(byArray));
    }

    public Extract(InputUni inputUni) throws IOException, ParseException {
        this(new PDFReader(inputUni));
    }

    public Extract(PDFReader pDFReader) {
        this.cachepath_ = new File(".");
        this.out_ = PrintStreams.DEVNULL;
    }

    public void setEmbed(boolean bl) {
        this.fembed_ = bl;
    }

    public void setFont(boolean bl) {
        this.ffont_ = bl;
    }

    public void setImage(boolean bl) {
        this.fimage_ = bl;
    }

    public void setStream(boolean bl) {
        this.fstream_ = bl;
    }

    public void setRange(String string) {
        this.range_ = string;
    }

    public void setMin(int n) {
        this.min_ = n;
    }

    public void setEdit(boolean bl) {
        this.fedit_ = bl;
    }

    public void setShare(boolean bl) {
        this.fshare_ = bl;
    }

    public void setCache(File file) {
        this.cachepath_ = file;
    }

    private void extract(File file) throws IOException, ParseException {
        String string = file.getPath();
        String string2 = (string.toLowerCase().endsWith(".pdf") ? string.substring(0, string.length() - 4) : string) + "-unem.pdf";
        this.extract(file, this.fedit_ || this.fshare_ ? new File(string2) : null);
    }

    private void extract(File file, File file2) throws IOException, ParseException {
        if (this.fverbose_) {
            System.out.println(file);
        }
        if (!($assertionsDisabled || file != null && file.exists())) {
            throw new AssertionError();
        }
        PDFReader pDFReader = new PDFReader(file);
        PDFWriter pDFWriter = this.fedit_ || this.fshare_ ? new PDFWriter(file2, pDFReader, false) : null;
        this.extract(pDFReader, pDFWriter);
        if (pDFWriter != null) {
            pDFWriter.writePDF();
            pDFWriter.close();
        }
        pDFReader.close();
    }

    private void extract(PDFReader pDFReader, PDFWriter pDFWriter) throws IOException, ParseException {
        Object object;
        int n;
        int n2;
        Object object2;
        Object object3;
        pDFReader.setPassword(this.password_);
        if (!pDFReader.isAuthorized()) {
            throw new ParseException("invalid password");
        }
        pDFReader.setExact(true);
        if (pDFWriter != null) {
            pDFWriter.setPassword(this.password_);
        }
        if (this.objrange_ != null) {
            object3 = Units.parseRange(this.objrange_, 1, pDFReader.getObjCnt());
            object2 = object3;
            int n3 = ((int[])object2).length;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                n = object2[n2];
                Object object4 = pDFReader.getObject(n);
                if (((Object)object3).length > 1) {
                    System.out.print(n + " = ");
                }
                System.out.println(object4);
                if (COS.CLASS_DICTIONARY != object4.getClass() || ((Dict)object4).get("DATA") == null) continue;
                object = pDFReader.getInputStream(new IRef(n, pDFReader.getObjGen(n)), false);
                while ((n4 = ((InputStream)object).read()) != -1) {
                    System.out.write((char)n4);
                }
                ((InputStream)object).close();
                System.out.println();
            }
        }
        if (this.range_ != null || this.objrange_ == null) {
            this.loadCache();
            object3 = new File(pDFReader.getURI());
            object2 = object3 != null ? ((File)object3).getName() : "obj";
            int[] nArray = Units.parseRange(this.range_, 1, pDFReader.getPageCnt());
            n = nArray.length;
            for (n2 = 0; n2 < n; ++n2) {
                int n5 = nArray[n2];
                object = pDFReader.getPage(n5);
                Dict dict = (Dict)pDFReader.getObject(((Dict)object).get("Resources"));
                if (dict == null) continue;
                Iterator iterator = dict.values().iterator();
                while (iterator.hasNext()) {
                    Object object5 = pDFReader.getObject(iterator.next());
                    if (COS.CLASS_DICTIONARY != object5.getClass()) continue;
                    Iterator iterator2 = ((Dict)object5).values().iterator();
                    while (iterator2.hasNext()) {
                        object5 = iterator2.next();
                        if (COS.CLASS_IREF != object5.getClass()) continue;
                        this.extractObject((String)object2, n2, pDFReader);
                    }
                }
            }
        }
    }

    private File extractObject(String string, int n, PDFReader pDFReader) throws IOException {
        Serializable serializable;
        Object object = pDFReader.getObject(n);
        if (COS.CLASS_DICTIONARY != object.getClass()) {
            return null;
        }
        Dict dict = (Dict)object;
        IRef iRef = new IRef(n, pDFReader.getObjGen(n));
        Object object2 = pDFReader.getObject(dict.get("Type"));
        Object object3 = pDFReader.getObject(dict.get("Subtype"));
        byte[] byArray = null;
        Dict dict2 = dict;
        String string2 = string + "#" + n;
        String string3 = null;
        if ("Page".equals(object2)) {
            // empty if block
        }
        if (!this.fembed_ || "Filespec".equals(object2)) {
            // empty if block
        }
        if ("Font".equals(object2) && (this.ffont_ || this.fstream_)) {
            string2 = (String)pDFReader.getObject(dict.get("BaseFont"));
            serializable = (Dict)pDFReader.getObject(dict.get("FontDescriptor"));
            if (serializable != null && string2.indexOf(43) == -1) {
                object = ((Dict)serializable).get("FontFile");
                if (object != null) {
                    dict2 = (Dict)pDFReader.getObject(object);
                    if (dict2.get("Length") != null) {
                        try {
                            byArray = NFontType1.toPFB(NFontType1.normalize(pDFReader.getStreamData(object, false, false)));
                        }
                        catch (FontFormatException fontFormatException) {
                            // empty catch block
                        }
                    }
                    string3 = "pfb";
                } else {
                    object = ((Dict)serializable).get("FontFile2");
                    if (object != null) {
                        dict2 = (Dict)pDFReader.getObject(object);
                        if (dict2.get("Length") != null) {
                            byArray = pDFReader.getStreamData(object, false, false);
                        }
                        string3 = "ttf";
                    } else {
                        object = ((Dict)serializable).get("FontFile3");
                        if (object != null) {
                            dict2 = (Dict)pDFReader.getObject(object);
                            if (dict2.get("Length") != null) {
                                byArray = pDFReader.getStreamData(object, false, false);
                            }
                            string3 = "cff";
                        }
                    }
                }
            }
            if (byArray != null) {
                ((Dict)serializable).remove("Filter");
                ((Dict)serializable).remove("DecodeParms");
            }
        }
        if ("Image".equals(object3) && (object2 == null || "XObject".equals(object2)) && (this.fimage_ || this.fstream_) && dict2.get("Length") != null) {
            byArray = pDFReader.getStreamData(iRef, false, false);
            object = Images.getFilter(dict, pDFReader);
            dict.remove("Filter");
            if (object != null) {
                dict.put("FFilter", object);
            }
            object = Images.getDecodeParms(dict, pDFReader);
            dict.remove("DecodeParms");
            if (object != null) {
                dict.put("FDecodeParms", object);
            }
            string3 = ".jpg";
        }
        if (this.fstream_ && byArray == null && dict2.get("Length") != null) {
            dict.remove("Filter");
            dict.remove("DecodeParms");
            string3 = ".raw";
        }
        if (byArray == null || byArray.length < this.min_) {
            return null;
        }
        serializable = this.getCache(byArray);
        if (this.fverbose_) {
            System.out.print("  extract object #" + n);
        }
        if (serializable == null) {
            serializable = new File(string2 + "." + string3);
            if (this.fverbose_) {
                System.out.println(" to " + serializable);
            }
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile((File)serializable, "rw");
                randomAccessFile.write(byArray);
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            this.addCache((File)serializable, byArray);
        } else if (this.fverbose_) {
            System.out.println(" -- same as " + serializable);
        }
        dict2.put("F", new StringBuffer(((File)serializable).toString()));
        dict2.put("DATA", EMPTY);
        dict2.remove("Length");
        return serializable;
    }

    private static void oa2Rect(Dict dict, String string, PDFReader pDFReader) throws IOException {
        Object[] objectArray = (Object[])pDFReader.getObject(dict.get(string));
        if (objectArray == null || objectArray.length != 4) {
            return;
        }
        int[] nArray = new int[4];
        double[] dArray = new double[4];
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            Object object = objectArray[i];
            if (COS.CLASS_REAL == object.getClass()) {
                bl = true;
            }
            nArray[i] = ((Number)object).intValue();
            dArray[i] = ((Number)object).doubleValue();
        }
        Rectangle2D rectangle2D = bl ? new Rectangle2D.Double(dArray[0], dArray[1], dArray[2], dArray[3]) : new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
        dict.put(string, rectangle2D);
    }

    private void loadCache() {
        if (this.cache_ != null) {
            return;
        }
        Iterator<File> iterator = new FileList(this.cachepath_, null).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (!file.isFile()) continue;
            try {
                this.addCache(file, Files.toByteArray(file));
            }
            catch (IOException iOException) {}
        }
    }

    private void addCache(File file, byte[] byArray) {
    }

    private File getCache(byte[] byArray) {
        return null;
    }

    private int commandLine(String[] stringArray) throws UnsupportedOperationException, NumberFormatException {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-obj")) {
                this.objrange_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-embed")) {
                this.setEmbed(true);
                continue;
            }
            if (string.startsWith("-font")) {
                this.setFont(true);
                continue;
            }
            if (string.startsWith("-image")) {
                this.setImage(true);
                continue;
            }
            if (string.startsWith("-stream")) {
                this.setStream(true);
                continue;
            }
            if (string.startsWith("-page") || string.startsWith("-range")) {
                this.setRange(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-min")) {
                this.setMin(Integer.parseInt(stringArray[++n]));
                continue;
            }
            if (string.startsWith("-edit") || string.startsWith("-share")) continue;
            if (string.startsWith("-cache")) {
                this.setCache(new File(stringArray[++n]));
                continue;
            }
            if (string.startsWith("-pass")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (!(this.fembed_ || this.ffont_ || this.fimage_ || this.fstream_)) {
            this.fembed_ = true;
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Extract extract = new Extract((PDFReader)null);
        int n = 0;
        try {
            n = extract.commandLine(stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(1);
        }
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (System.getSecurityManager() != null) continue;
            try {
                extract.pdfr_ = new PDFReader(file);
                extract.extract(file);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
        }
        System.exit(0);
    }

    static {
        $assertionsDisabled = !Extract.class.desiredAssertionStatus();
        EMPTY = new byte[0];
    }
}

