/*
 * Decompiled with CFR 0.152.
 */
package tool.file;

import com.pt.io.FileList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import phelps.io.Files;
import phelps.io.InputStreams;
import phelps.io.PrintStreams;

public class Zcat {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.0 of $Date: 2004/01/02 02:20:42 $";
    public static final String USAGE = "java tool.file.Zcat [<options>] <file...>";
    private boolean fverbose_;
    private boolean fquiet_;
    private boolean fmonitor_;
    private PrintStream out_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Zcat() {
        this.defaults();
    }

    public void defaults() {
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public void zcat(File file) throws IOException {
        if (this.fverbose_) {
            System.out.println(file);
        }
        if (!($assertionsDisabled || file != null && file.exists())) {
            throw new AssertionError();
        }
        InputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        inputStream = InputStreams.uncompress(inputStream, Files.getEncoding(file.getPath()));
        InputStreams.copy(inputStream, this.out_, true);
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.equals("-label")) continue;
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Zcat zcat = new Zcat();
        int n = zcat.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, null).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                zcat.zcat(file);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
        }
    }

    static {
        $assertionsDisabled = !Zcat.class.desiredAssertionStatus();
    }
}

